/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.example.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import ru.astemir.astemirlib.client.DeferredEntityRenderer;
import ru.astemir.astemirlib.client.RenderUtils;
import ru.astemir.astemirlib.client.bedrock.animation.Animated;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationData;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.animation.data.PartTransform;
import ru.astemir.astemirlib.client.bedrock.model.BedrockEntityModel;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModel;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModelLayer;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.astemir.example.common.ExampleEntity;

public class ExampleModel
extends BedrockEntityModel<ExampleEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("astemirlib", "textures/jas.png");
    private static final ResourceLocation MODEL = new ResourceLocation("astemirlib", "models/jas.geo.json");
    private static final ResourceLocation ANIMATION = new ResourceLocation("astemirlib", "animations/jas.animation.json");

    public ExampleModel() {
        super(MODEL, ANIMATION);
        this.addLayer(new EyesLayer(this));
        this.addLayer(new BedrockModelLayer<ExampleEntity>((BedrockModel)this){

            @Override
            public void render(ExampleEntity object, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
                if (object.m_146895_() != null) {
                    PoseStack armPose = RenderUtils.fromPose(this.getModel().getPart("RightArm").getLastPose());
                    DeferredEntityRenderer.renderDeferred(object.m_146895_().m_20148_(), armPose, new AVector3f(0.0f, -0.85f, 0.0f), 0.0f);
                }
            }
        });
    }

    @Override
    public void animate(Animator animator, ExampleEntity entity, EntityRenderData renderData) {
        PartTransform transform = animator.getTransform("Head");
        transform.setCustomRotation(0.0f, MathUtils.sin(renderData.ageInTicks / 4.0f) * 30.0f, 0.0f);
        transform.setLookAt(renderData.entityYaw, renderData.entityPitch);
        Animation animation = animator.getAnimation("animation.model.idle");
        if (this.isMoving((LivingEntity)entity, -0.1f, 0.1f, renderData.partialTick)) {
            animation = animator.getAnimation("animation.model.walk");
        }
        if (entity.controller.is(ExampleEntity.ACTION_SWING)) {
            animation = animation.merge(animator.getAnimation("animation.model.swing"));
        }
        animator.setAnimation(animation, AnimationBlending.create(InterpolationType.CATMULLROM, EasingType.NONE, 0.25), 1.0, 1);
    }

    @Override
    public void renderFinal(BedrockModel model, ExampleEntity object, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Color color) {
        super.renderFinal(model, (Animated)object, poseStack, bufferSource, packedLight, packedOverlay, color);
    }

    @Override
    public AnimationData getDefaultAnimation(Animator animator, Animation previousAnimation) {
        return animator.setAnimation("animation.model.land", AnimationBlending.create(InterpolationType.CATMULLROM, EasingType.NONE, 0.25), 1.0, 1);
    }

    @Override
    public ResourceLocation getTexture(ExampleEntity object) {
        return TEXTURE;
    }

    @Override
    public RenderType getRenderType(ExampleEntity object, ResourceLocation texture) {
        return super.getRenderType((Animated)object, texture);
    }

    private class EyesLayer
    extends BedrockModelLayer<ExampleEntity> {
        private static final ResourceLocation TEXTURE = new ResourceLocation("astemirlib", "textures/jas_eyes.png");

        public EyesLayer(BedrockModel<ExampleEntity> model) {
            super(model);
        }

        @Override
        public void render(ExampleEntity object, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
            this.renderModel(object, poseStack, bufferSource, 0xF00000, packedOverlay);
        }

        @Override
        public Color getColor(ExampleEntity object) {
            return new Color(1.0f, 1.0f, 1.0f, 1.0f);
        }

        @Override
        public RenderType getRenderType(ExampleEntity object, ResourceLocation texture) {
            return RenderType.m_110488_((ResourceLocation)texture);
        }

        @Override
        public ResourceLocation getTexture(ExampleEntity object) {
            return TEXTURE;
        }
    }
}

