/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.math;

import net.minecraft.nbt.CompoundTag;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.MathUtils;

public class AVector2f {
    public static final AVector2f ZERO = new AVector2f(0.0f, 0.0f);
    public static final AVector2f ONE = new AVector2f(1.0f, 1.0f);
    public float x;
    public float y;

    public AVector2f() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public AVector2f(float f) {
        this.x = f;
        this.y = f;
    }

    public AVector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public AVector2f(double x, double y) {
        this.x = (float)x;
        this.y = (float)y;
    }

    public AVector2f(AVector2f vector) {
        this.x = vector.x;
        this.y = vector.y;
    }

    public AVector2f add(AVector2f vector) {
        return new AVector2f(this.x + vector.getX(), this.y + vector.getY());
    }

    public AVector2f sub(AVector2f vector) {
        return new AVector2f(this.x - vector.getX(), this.y - vector.getY());
    }

    public AVector2f mul(AVector2f vector) {
        return new AVector2f(this.x * vector.getX(), this.y * vector.getY());
    }

    public AVector2f div(AVector2f vector) {
        return new AVector2f(this.x / vector.getX(), this.y / vector.getY());
    }

    public AVector2f add(float x1, float y1) {
        return new AVector2f(this.x + x1, this.y + y1);
    }

    public AVector2f sub(float x1, float y1) {
        return new AVector2f(this.x - x1, this.y - y1);
    }

    public AVector2f mul(float x1, float y1) {
        return new AVector2f(this.x * x1, this.y * y1);
    }

    public AVector2f div(float x1, float y1) {
        return new AVector2f(this.x / x1, this.y / y1);
    }

    public AVector2f add(float t) {
        return new AVector2f(this.x + t, this.y + t);
    }

    public AVector2f sub(float t) {
        return new AVector2f(this.x - t, this.y - t);
    }

    public AVector2f mul(float t) {
        return new AVector2f(this.x * t, this.y * t);
    }

    public AVector2f div(float t) {
        return new AVector2f(this.x / t, this.y / t);
    }

    public float magnitude() {
        return MathUtils.sqrt(this.x * this.x + this.y * this.y);
    }

    public AVector2f direction(AVector2f vector) {
        return vector.sub(this).normalize();
    }

    public AVector2f directionWithoutNormalize(AVector2f vector) {
        return vector.sub(this);
    }

    public float distanceTo(AVector2f vector) {
        return MathUtils.sqrt(this.distanceToSquared(vector));
    }

    public AVector2f interpolate(AVector2f vector, InterpolationType interpolationType, float t) {
        return new AVector2f(interpolationType.interpolate(this, vector, (double)t));
    }

    public AVector2f interpolateRot(AVector2f vector, InterpolationType interpolationType, float t) {
        return new AVector2f(interpolationType.interpolateRot(this, vector, (double)t));
    }

    public AVector2f clamp(AVector2f min, AVector2f max) {
        return new AVector2f(MathUtils.clamp(this.x, min.x, max.x), MathUtils.clamp(this.y, min.y, max.y));
    }

    public AVector2f catmullrom(AVector2f previous, AVector2f next, AVector2f nextNext, float f) {
        float t2 = f * f;
        float f1 = (float)(-0.5 * (double)(f * f * f) + (double)t2 - 0.5 * (double)f);
        float f2 = (float)(1.5 * (double)(f * f * f) - 2.5 * (double)t2 + 1.0);
        float f3 = (float)(-1.5 * (double)(f * f * f) + 2.0 * (double)t2 + 0.5 * (double)f);
        float f4 = (float)(0.5 * (double)(f * f * f) - 0.5 * (double)t2);
        float x = previous.x * f1 + this.x * f2 + next.x * f3 + nextNext.x * f4;
        float y = previous.y * f1 + this.y * f2 + next.y * f3 + nextNext.y * f4;
        return new AVector2f(x, y);
    }

    public AVector2f wrapDegrees() {
        return new AVector2f(MathUtils.wrapDegrees(this.x), MathUtils.wrapDegrees(this.y));
    }

    public AVector2f wrapRadians() {
        return new AVector2f(MathUtils.wrapRadians(this.x), MathUtils.wrapRadians(this.y));
    }

    public AVector2f rotation() {
        AVector2f dir = this.normalize();
        return new AVector2f(MathUtils.cos(dir.x), MathUtils.sin(dir.y));
    }

    public AVector2f rotationDegrees() {
        AVector2f dir = this.normalize();
        return new AVector2f(MathUtils.deg(MathUtils.cos(dir.x)), MathUtils.deg(MathUtils.sin(dir.y)));
    }

    public float distanceToSquared(AVector2f vector) {
        float resX = (this.x - vector.x) * (this.x - vector.x);
        float resY = (this.y - vector.y) * (this.y - vector.y);
        return resX + resY;
    }

    public AVector2f normalize() {
        float magnitude = this.magnitude();
        if (magnitude > 0.0f) {
            return this.div(magnitude);
        }
        return new AVector2f(this.x, this.y);
    }

    public AVector2f rotate(double angle) {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        double x = angleCos * (double)this.getX() - angleSin * (double)this.getY();
        double y = angleSin * (double)this.getX() + angleCos * (double)this.getY();
        return new AVector2f(x, y);
    }

    public static AVector2f create(float x, float y) {
        return new AVector2f(x, y);
    }

    public static AVector2f rad(float x, float y) {
        return new AVector2f(MathUtils.rad(x), MathUtils.rad(y));
    }

    public static AVector2f deg(float x, float y) {
        return new AVector2f(MathUtils.deg(x), MathUtils.deg(y));
    }

    public boolean equalsApprox(AVector2f vector, float t) {
        return MathUtils.equalsApprox(this.x, vector.x, t) && MathUtils.equalsApprox(this.y, vector.y, t);
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("x", this.x);
        tag.m_128350_("y", this.y);
        return tag;
    }

    public static AVector2f fromNbt(CompoundTag tag) {
        return new AVector2f(tag.m_128457_("x"), tag.m_128457_("y"));
    }

    public float[] toFloatArray(AVector2f vector2) {
        return new float[]{vector2.x, vector2.y};
    }

    public static AVector2f fromFloatArray(float[] array) {
        return new AVector2f(array[0], array[1]);
    }

    public static AVector2f zero() {
        return new AVector2f(0.0f, 0.0f);
    }

    public static AVector2f one() {
        return new AVector2f(1.0f, 1.0f);
    }

    public AVector2f copy() {
        return new AVector2f(this.x, this.y);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public String toString() {
        return "[x=" + this.x + ";y=" + this.y + "]";
    }
}

