/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.StringUtils;
import ru.astemir.astemirlib.common.action.ActionController;
import ru.astemir.astemirlib.common.action.ActionListener;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.command.build.CommandArgument;
import ru.astemir.astemirlib.common.command.build.CommandBuilder;
import ru.astemir.astemirlib.common.command.build.CommandPart;
import ru.astemir.astemirlib.common.command.build.CommandVariant;

public class PlayActionCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        CommandArgument targets = CommandArgument.entities("targets");
        CommandArgument pos = CommandArgument.blockPos("pos");
        CommandArgument controller = CommandArgument.word("controller");
        CommandArgument action = CommandArgument.word("action");
        CommandArgument delay = CommandArgument.integer("delay", 0);
        CommandBuilder builder = new CommandBuilder("action").variants(new CommandVariant(CommandPart.create("play"), targets, controller, action, delay).execute((Command<CommandSourceStack>)((Command)p -> {
            PlayActionCommand.playAction((CommandSourceStack)p.getSource(), targets.getEntities((CommandContext<CommandSourceStack>)p), controller.getString((CommandContext<CommandSourceStack>)p), action.getString((CommandContext<CommandSourceStack>)p), delay.getInt((CommandContext<CommandSourceStack>)p));
            return 1;
        })), new CommandVariant(CommandPart.create("play"), pos, controller, action, delay).execute((Command<CommandSourceStack>)((Command)p -> {
            PlayActionCommand.playAction((CommandSourceStack)p.getSource(), pos.getBlockPos((CommandContext<CommandSourceStack>)p), controller.getString((CommandContext<CommandSourceStack>)p), action.getString((CommandContext<CommandSourceStack>)p), delay.getInt((CommandContext<CommandSourceStack>)p));
            return 1;
        })), new CommandVariant(CommandPart.create("play"), targets, controller, action).execute((Command<CommandSourceStack>)((Command)p -> {
            PlayActionCommand.playAction((CommandSourceStack)p.getSource(), targets.getEntities((CommandContext<CommandSourceStack>)p), controller.getString((CommandContext<CommandSourceStack>)p), action.getString((CommandContext<CommandSourceStack>)p), 0);
            return 1;
        })), new CommandVariant(CommandPart.create("play"), pos, controller, action).execute((Command<CommandSourceStack>)((Command)p -> {
            PlayActionCommand.playAction((CommandSourceStack)p.getSource(), pos.getBlockPos((CommandContext<CommandSourceStack>)p), controller.getString((CommandContext<CommandSourceStack>)p), action.getString((CommandContext<CommandSourceStack>)p), 0);
            return 1;
        })), new CommandVariant(CommandPart.create("stop"), targets, controller).execute((Command<CommandSourceStack>)((Command)p -> {
            PlayActionCommand.stopAction((CommandSourceStack)p.getSource(), targets.getEntities((CommandContext<CommandSourceStack>)p), controller.getString((CommandContext<CommandSourceStack>)p));
            return 1;
        })), new CommandVariant(CommandPart.create("stop"), pos, controller).execute((Command<CommandSourceStack>)((Command)p -> {
            PlayActionCommand.stopAction((CommandSourceStack)p.getSource(), pos.getBlockPos((CommandContext<CommandSourceStack>)p), controller.getString((CommandContext<CommandSourceStack>)p));
            return 1;
        })), new CommandVariant(CommandPart.create("info"), targets).execute((Command<CommandSourceStack>)((Command)p -> {
            for (Entity entity : targets.getEntities((CommandContext<CommandSourceStack>)p)) {
                if (!(entity instanceof ActionListener)) continue;
                ActionListener actionListener = (ActionListener)entity;
                ((CommandSourceStack)p.getSource()).m_288197_(() -> PlayActionCommand.formComponent(actionListener), true);
            }
            return 1;
        })), new CommandVariant(CommandPart.create("info"), pos).execute((Command<CommandSourceStack>)((Command)p -> {
            BlockEntity blockEntity = ((CommandSourceStack)p.getSource()).m_81372_().m_7702_(pos.getBlockPos((CommandContext<CommandSourceStack>)p));
            if (blockEntity instanceof ActionListener) {
                ActionListener actionListener = (ActionListener)blockEntity;
                ((CommandSourceStack)p.getSource()).m_288197_(() -> PlayActionCommand.formComponent(actionListener), true);
            }
            return 1;
        })));
        dispatcher.register(builder.permission(p -> p.m_6761_(2)).build());
    }

    private static Component formComponent(ActionListener actionListener) {
        int controllerCount = actionListener.getActionStateMachine().getControllers().size();
        MutableComponent result = Component.m_237113_((String)"\u00a7lControllers\u00a7r: \n");
        for (int i = 0; i < controllerCount; ++i) {
            Object object;
            if (actionListener instanceof Entity) {
                Entity entity = (Entity)actionListener;
                object = String.valueOf(entity.m_20148_());
            } else if (actionListener instanceof BlockEntity) {
                BlockEntity blockEntity = (BlockEntity)actionListener;
                object = blockEntity.m_58899_().m_123341_() + " " + blockEntity.m_58899_().m_123342_() + " " + blockEntity.m_58899_().m_123343_();
            } else {
                object = "null";
            }
            String id = object;
            ActionController controller = actionListener.getActionStateMachine().getControllers().get(i);
            String controllerName = StringUtils.capitalize((String)controller.getName());
            result.m_130946_(controllerName + ": ");
            for (int j = 0; j < controller.getActions().length; ++j) {
                ActionState action = controller.getActions()[j];
                String actionName = StringUtils.capitalize((String)action.getName());
                MutableComponent mutableComponent = Component.m_237113_((String)String.format("Name: %s\nLength: %s", action.getName(), action.getLength()));
                MutableComponent mutableComponent2 = Component.m_237113_((String)String.format("%s", actionName)).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)mutableComponent)).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/action play %s %s %s".formatted(id, controller.getName(), action.getName()))));
                if (j != controller.getActions().length - 1) {
                    mutableComponent2.m_130946_(", ");
                }
                result.m_7220_((Component)mutableComponent2);
            }
            if (i == controllerCount - 1) continue;
            result.m_130946_("\n");
        }
        return result;
    }

    public static int stopAction(CommandSourceStack source, BlockPos pos, String controllerName) {
        BlockEntity blockEntity = source.m_81372_().m_7702_(pos);
        if (blockEntity instanceof ActionListener) {
            PlayActionCommand.stopAction((ActionListener)blockEntity, controllerName);
        }
        return 1;
    }

    public static int stopAction(CommandSourceStack source, Collection<? extends Entity> entities, String controllerName) {
        for (Entity entity : entities) {
            if (!(entity instanceof ActionListener)) continue;
            PlayActionCommand.stopAction((ActionListener)entity, controllerName);
        }
        return 1;
    }

    public static int playAction(CommandSourceStack source, BlockPos pos, String controllerName, String actionName, int delay) {
        BlockEntity blockEntity = source.m_81372_().m_7702_(pos);
        if (blockEntity instanceof ActionListener) {
            PlayActionCommand.playAction((ActionListener)blockEntity, controllerName, actionName, delay);
        }
        return 1;
    }

    public static int playAction(CommandSourceStack source, Collection<? extends Entity> entities, String controllerName, String actionName, int delay) {
        for (Entity entity : entities) {
            if (!(entity instanceof ActionListener)) continue;
            PlayActionCommand.playAction((ActionListener)entity, controllerName, actionName, delay);
        }
        return 1;
    }

    public static void playAction(ActionListener listener, String controllerName, String actionName, int delay) {
        for (ActionController controller : listener.getActionStateMachine().getControllers()) {
            if (!controller.getName().equals(controllerName)) continue;
            for (ActionState action : controller.getActions()) {
                if (actionName.equals("noAction")) {
                    controller.setNoState();
                }
                if (!action.getName().equals(actionName)) continue;
                controller.playAction(action, delay);
            }
        }
    }

    public static void stopAction(ActionListener listener, String controllerName) {
        for (ActionController controller : listener.getActionStateMachine().getControllers()) {
            if (!controller.getName().equals(controllerName)) continue;
            controller.setNoState();
        }
    }
}

