/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import ru.astemir.astemirlib.client.RenderUtils;

@Cancelable
public class EntityRenderEvent
extends Event {
    private Entity entity;
    private double cameraX;
    private double cameraY;
    private double cameraZ;
    private float partialTick;
    private PoseStack poseStack;
    private MultiBufferSource bufferSource;

    public EntityRenderEvent(Entity entity, double x, double y, double z, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource) {
        this.entity = entity;
        this.cameraX = x;
        this.cameraY = y;
        this.cameraZ = z;
        this.partialTick = partialTick;
        this.poseStack = RenderUtils.copyPoseStack(poseStack);
        this.bufferSource = bufferSource;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public double getCameraX() {
        return this.cameraX;
    }

    public double getCameraY() {
        return this.cameraY;
    }

    public double getCameraZ() {
        return this.cameraZ;
    }

    public float getPartialTick() {
        return this.partialTick;
    }

    public PoseStack getPoseStack() {
        return this.poseStack;
    }

    public MultiBufferSource getBufferSource() {
        return this.bufferSource;
    }
}

