/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.model.render;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import ru.astemir.astemirlib.client.bedrock.model.render.BedrockCubeRender;
import ru.astemir.astemirlib.client.bedrock.model.render.BedrockModelCube;
import ru.astemir.astemirlib.client.bedrock.model.render.BedrockModelPart;
import ru.astemir.astemirlib.common.math.AVector3f;

public class BedrockModelBone {
    private final List<BedrockModelCube> cubes;
    private final List<BedrockModelBone> children = new ArrayList<BedrockModelBone>();
    private final AVector3f pivot;
    private final AVector3f rotationDegrees;
    private final String name;
    private final String parentName;
    private final boolean disabled;

    public BedrockModelBone(List<BedrockModelCube> cubes, AVector3f pivot, AVector3f rotationDegrees, boolean disabled, String name, String parentName) {
        this.cubes = cubes;
        this.pivot = pivot;
        this.rotationDegrees = rotationDegrees;
        this.disabled = disabled;
        this.name = name;
        this.parentName = parentName;
    }

    public static BedrockModelBone makeRoot() {
        return new BedrockModelBone((List<BedrockModelCube>)ImmutableList.of(), new AVector3f(0.0f, 0.0f, 0.0f), new AVector3f(0.0f, 0.0f, 0.0f), false, "root", null);
    }

    public void addChild(BedrockModelBone child) {
        this.children.add(child);
    }

    public void addChildren(List<BedrockModelBone> children) {
        this.children.addAll(children);
    }

    public BedrockModelPart bake(@Nullable BedrockModelBone parent, int textureWidth, int textureHeight) {
        ImmutableList.Builder bakedCubes = ImmutableList.builder();
        for (BedrockModelCube cube : this.cubes) {
            bakedCubes.add((Object)cube.bake(this, textureWidth, textureHeight));
        }
        AVector3f rotationRads = new AVector3f((float)Math.toRadians(this.rotationDegrees.x), (float)Math.toRadians(this.rotationDegrees.y), (float)Math.toRadians(this.rotationDegrees.z));
        rotationRads = rotationRads.mul(-1.0f, -1.0f, 1.0f);
        Object2ObjectArrayMap bakedChildren = new Object2ObjectArrayMap();
        for (BedrockModelBone child : this.children) {
            bakedChildren.put((Object)child.name, (Object)child.bake(this, textureWidth, textureHeight));
        }
        BedrockModelPart part = new BedrockModelPart(rotationRads, (List<BedrockCubeRender>)bakedCubes.build(), (Map<String, BedrockModelPart>)bakedChildren, this.disabled);
        if (parent != null) {
            part.m_104227_(-(this.pivot.x - parent.pivot.x), this.pivot.y - parent.pivot.y, this.pivot.z - parent.pivot.z);
        } else {
            part.m_104227_(-this.pivot.x, this.pivot.y, this.pivot.z);
        }
        return part;
    }

    public AVector3f getPivot() {
        return this.pivot;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getName() {
        return this.name;
    }
}

