/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import ru.astemir.astemirlib.client.bedrock.animation.Animated;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationData;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModelLayer;
import ru.astemir.astemirlib.client.bedrock.model.render.BedrockModelPart;
import ru.astemir.astemirlib.common.math.Color;

public interface BedrockModel<T extends Animated> {
    public BedrockModelPart getRoot();

    public Map<String, Animation> getAnimations();

    public ResourceLocation getTexture(T var1);

    public LinkedList<BedrockModelLayer<T>> getLayers();

    default public Color getColor(T object) {
        return Color.WHITE;
    }

    default public void addLayer(BedrockModelLayer<T> layer) {
        this.getLayers().add(layer);
    }

    default public void resetAll() {
        this.getRoot().resetAll();
    }

    default public void renderFinal(BedrockModel model, T object, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Color color) {
        VertexConsumer bufferIn = bufferSource.m_6299_(this.getRenderType(object, this.getTexture(object)));
        this.getRoot().renderFinal(model, object, poseStack, bufferIn, bufferSource, packedLight, packedOverlay, color);
        for (BedrockModelLayer bedrockModelLayer : this.getLayers()) {
            bedrockModelLayer.render(object, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    default public LinkedList<BedrockModelPart> getAffectedParts(LinkedList<BedrockModelPart> list, BedrockModelPart part) {
        if (part.parent != null) {
            this.getAffectedParts(list, part.parent);
        }
        list.add(part);
        return list;
    }

    default public AnimationData getDefaultAnimation(Animator animator, Animation previousAnimation) {
        return AnimationData.EMPTY;
    }

    default public BedrockModelPart getPart(String name) {
        return this.getRoot().getChild(name);
    }

    default public String getPartName(BedrockModelPart part) {
        return this.getRoot().getChildName(part);
    }

    default public RenderType getRenderType(T object, ResourceLocation texture) {
        return RenderType.m_110458_((ResourceLocation)texture);
    }
}

