/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.json;

import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.misc.KeyedTimeline;

public class AnimationTrack {
    private KeyedTimeline<AVector3f> position;
    private KeyedTimeline<AVector3f> rotation;
    private KeyedTimeline<AVector3f> scale;

    public AnimationTrack(KeyedTimeline position, KeyedTimeline rotation, KeyedTimeline scale) {
        this.position = position;
        this.rotation = rotation;
        this.scale = scale;
    }

    public Result getResult(float time) {
        AVector3f interpolatedPos = null;
        AVector3f interpolatedRot = null;
        AVector3f interpolatedScale = null;
        if (this.hasPosition()) {
            interpolatedPos = this.position.getInterpolated(time, false);
        }
        if (this.hasRotation()) {
            interpolatedRot = this.rotation.getInterpolated(time, true);
        }
        if (this.hasScale()) {
            interpolatedScale = this.scale.getInterpolated(time, false);
        }
        return new Result(interpolatedPos, interpolatedRot, interpolatedScale);
    }

    public boolean hasPosition() {
        return !this.position.isEmpty();
    }

    public boolean hasRotation() {
        return !this.rotation.isEmpty();
    }

    public boolean hasScale() {
        return !this.scale.isEmpty();
    }

    public KeyedTimeline<AVector3f> getPosition() {
        return this.position;
    }

    public KeyedTimeline<AVector3f> getRotation() {
        return this.rotation;
    }

    public KeyedTimeline<AVector3f> getScale() {
        return this.scale;
    }

    public void setPosition(KeyedTimeline<AVector3f> position) {
        this.position = position;
    }

    public void setRotation(KeyedTimeline<AVector3f> rotation) {
        this.rotation = rotation;
    }

    public void setScale(KeyedTimeline<AVector3f> scale) {
        this.scale = scale;
    }

    public static class Result {
        private AVector3f position;
        private AVector3f rotation;
        private AVector3f scale;

        public Result(AVector3f position, AVector3f rotation, AVector3f scale) {
            this.position = position;
            this.rotation = rotation;
            this.scale = scale;
        }

        public AVector3f getPosition() {
            return this.position;
        }

        public AVector3f getRotation() {
            return this.rotation;
        }

        public AVector3f getScale() {
            return this.scale;
        }

        public boolean hasPosition() {
            return this.position != null;
        }

        public boolean hasRotation() {
            return this.rotation != null;
        }

        public boolean hasScale() {
            return this.scale != null;
        }
    }
}

