/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="astemirlib", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class TESRModelsRegistry {
    public static Map<ResourceLocation, ResourceLocation> MODELS = new HashMap<ResourceLocation, ResourceLocation>();

    @SubscribeEvent
    public static void onModelRegistryInit(ModelEvent.RegisterAdditional modelRegistryEvent) {
        MODELS.forEach((path, modelPath) -> modelRegistryEvent.register((ResourceLocation)new ModelResourceLocation(modelPath, "inventory")));
    }

    @SubscribeEvent
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        MODELS.forEach((path, modelPath) -> TESRModelsRegistry.bakeModelReplacement(event.getModels(), path, modelPath));
    }

    public static void addReplacement(ResourceLocation item, ResourceLocation model) {
        MODELS.put(item, model);
    }

    private static void bakeModelReplacement(Map<ResourceLocation, BakedModel> modelsMap, ResourceLocation inventoryPath, ResourceLocation inHandPath) {
        ModelResourceLocation modelInventory = new ModelResourceLocation(inventoryPath, "inventory");
        ModelResourceLocation modelHand = new ModelResourceLocation(inHandPath, "inventory");
        BakedModel bakedModelDefault = modelsMap.get(modelInventory);
        BakedModel bakedModelHand = modelsMap.get(modelHand);
        modelsMap.put((ResourceLocation)modelInventory, new TESRModel(bakedModelDefault, bakedModelHand));
    }

    public static class TESRModel
    implements BakedModel {
        private BakedModel bakedModelDefault;
        private BakedModel bakedModelHand;

        public TESRModel(BakedModel bakedModelDefault, BakedModel bakedModelHand) {
            this.bakedModelDefault = bakedModelDefault;
            this.bakedModelHand = bakedModelHand;
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
            return this.bakedModelDefault.getQuads(state, side, rand, data, renderType);
        }

        public boolean useAmbientOcclusion(BlockState state) {
            return this.bakedModelDefault.m_7541_();
        }

        public boolean useAmbientOcclusion(BlockState state, RenderType renderType) {
            return this.bakedModelDefault.m_7541_();
        }

        public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
            return this.bakedModelDefault.getParticleIcon(data);
        }

        public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
            return this.bakedModelDefault.getRenderTypes(state, rand, data);
        }

        public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
            return this.bakedModelDefault.getRenderTypes(itemStack, fabulous);
        }

        public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
            return this.bakedModelDefault.getRenderPasses(itemStack, fabulous);
        }

        @NotNull
        public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
            return this.bakedModelDefault.getModelData(level, pos, state, modelData);
        }

        public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
            BakedModel modelToUse = this.bakedModelDefault;
            if (transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
                modelToUse = this.bakedModelHand;
            }
            modelToUse.m_7442_().m_269404_(transformType).m_111763_(applyLeftHandTransform, poseStack);
            return modelToUse;
        }

        public List<BakedQuad> m_213637_(@Nullable BlockState p_235039_, @Nullable Direction p_235040_, RandomSource p_235041_) {
            return this.bakedModelDefault.m_213637_(p_235039_, p_235040_, p_235041_);
        }

        public boolean m_7541_() {
            return this.bakedModelDefault.m_7541_();
        }

        public boolean m_7539_() {
            return this.bakedModelDefault.m_7539_();
        }

        public boolean m_7547_() {
            return this.bakedModelDefault.m_7547_();
        }

        public boolean m_7521_() {
            return this.bakedModelDefault.m_7521_();
        }

        public TextureAtlasSprite m_6160_() {
            return this.bakedModelDefault.m_6160_();
        }

        public ItemOverrides m_7343_() {
            return this.bakedModelDefault.m_7343_();
        }
    }
}

