/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.Arrays;
import net.mehvahdjukaar.amendments.common.CakeRegistry;
import net.mehvahdjukaar.amendments.common.block.DirectionalCakeBlock;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DoubleCakeBlock
extends DirectionalCakeBlock {
    protected static final VoxelShape[] SHAPES_NORTH = new VoxelShape[]{Shapes.m_83110_((VoxelShape)DoubleCakeBlock.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)DoubleCakeBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.m_83110_((VoxelShape)DoubleCakeBlock.m_49796_((double)2.0, (double)8.0, (double)3.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)DoubleCakeBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.m_83110_((VoxelShape)DoubleCakeBlock.m_49796_((double)2.0, (double)8.0, (double)5.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)DoubleCakeBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.m_83110_((VoxelShape)DoubleCakeBlock.m_49796_((double)2.0, (double)8.0, (double)7.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)DoubleCakeBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.m_83110_((VoxelShape)DoubleCakeBlock.m_49796_((double)2.0, (double)8.0, (double)9.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)DoubleCakeBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.m_83110_((VoxelShape)DoubleCakeBlock.m_49796_((double)2.0, (double)8.0, (double)11.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)DoubleCakeBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.m_83110_((VoxelShape)DoubleCakeBlock.m_49796_((double)2.0, (double)8.0, (double)13.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)DoubleCakeBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0))};
    protected static final VoxelShape[] SHAPES_WEST = (VoxelShape[])Arrays.stream(SHAPES_NORTH).map(s -> MthUtils.rotateVoxelShape((VoxelShape)s, (Direction)Direction.WEST)).toArray(VoxelShape[]::new);
    protected static final VoxelShape[] SHAPES_SOUTH = (VoxelShape[])Arrays.stream(SHAPES_NORTH).map(s -> MthUtils.rotateVoxelShape((VoxelShape)s, (Direction)Direction.SOUTH)).toArray(VoxelShape[]::new);
    protected static final VoxelShape[] SHAPES_EAST = (VoxelShape[])Arrays.stream(SHAPES_NORTH).map(s -> MthUtils.rotateVoxelShape((VoxelShape)s, (Direction)Direction.EAST)).toArray(VoxelShape[]::new);
    private final BlockState mimic;

    public DoubleCakeBlock(CakeRegistry.CakeType type) {
        super(type);
        this.mimic = type.cake.m_49966_();
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> SHAPES_WEST[(Integer)state.m_61143_((Property)f_51180_)];
            case Direction.EAST -> SHAPES_EAST[(Integer)state.m_61143_((Property)f_51180_)];
            case Direction.SOUTH -> SHAPES_SOUTH[(Integer)state.m_61143_((Property)f_51180_)];
            case Direction.NORTH -> SHAPES_NORTH[(Integer)state.m_61143_((Property)f_51180_)];
        };
    }

    @Override
    public void removeSlice(BlockState state, BlockPos pos, LevelAccessor level, Direction dir) {
        int i = (Integer)state.m_61143_((Property)f_51180_);
        if (i < 6) {
            if (i == 0 && CommonConfigs.DIRECTIONAL_CAKE.get().booleanValue()) {
                state = (BlockState)state.m_61124_((Property)FACING, (Comparable)dir);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_51180_, (Comparable)Integer.valueOf(i + 1)), 3);
        } else if (this.type == CakeRegistry.VANILLA && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && CommonConfigs.DIRECTIONAL_CAKE.get().booleanValue()) {
            level.m_7731_(pos, (BlockState)((BlockState)ModRegistry.DIRECTIONAL_CAKE.get().m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED))), 3);
        } else {
            level.m_7731_(pos, this.type.cake.m_49966_(), 3);
        }
    }

    @Override
    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (CompatHandler.SUPPLEMENTARIES) {
            SuppCompat.spawnCakeParticles(level, pos, rand);
        }
        super.m_214162_(stateIn, level, pos, rand);
        this.mimic.m_60734_().m_214162_(this.mimic, level, pos, rand);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        return Math.min(super.m_5880_(state, player, worldIn, pos), this.mimic.m_60625_(player, worldIn, pos));
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        return this.mimic.m_60827_();
    }

    public SoundType m_49962_(BlockState state) {
        return this.mimic.m_60827_();
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        float f;
        if (level instanceof Level) {
            Level l = (Level)level;
            f = Math.max(ForgeHelper.getExplosionResistance((BlockState)this.mimic, (Level)l, (BlockPos)pos, (Explosion)explosion), state.m_60734_().m_7325_());
        } else {
            f = super.m_7325_();
        }
        return f;
    }

    @Override
    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return this.mimic.m_60734_().m_7397_(level, pos, state);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!player.m_21120_(handIn).m_204117_(ItemTags.f_144319_)) {
            BlockState newState = this.type.cake.m_152465_(state);
            level.m_7731_(pos, newState, 4);
            InteractionResult res = newState.m_60664_(level, player, handIn, hit);
            level.m_46597_(pos, state);
            if (res.m_19077_()) {
                if (!level.m_5776_()) {
                    this.removeSlice(state, pos, (LevelAccessor)level, DoubleCakeBlock.getHitDir(player, hit));
                }
                return res;
            }
        }
        return super.m_6227_(state, level, pos, player, handIn, hit);
    }
}

