/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.ambientadditions.common.items;

import codyhuh.ambientadditions.AmbientAdditions;
import codyhuh.ambientadditions.data.SedationData;
import codyhuh.ambientadditions.data.SedationProvider;
import codyhuh.ambientadditions.registry.AAItems;
import codyhuh.ambientadditions.registry.AATags;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.LazyOptional;

public class CrateItem
extends Item {
    public static final String DATA_CREATURE = "CreatureData";

    public CrateItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        LazyOptional cap;
        int sedationLevel;
        Level level = player.m_9236_();
        if (CrateItem.containsEntity(stack)) {
            return InteractionResult.PASS;
        }
        if (!target.m_20197_().isEmpty()) {
            target.m_20153_();
        }
        int n = sedationLevel = (cap = target.getCapability(SedationProvider.SEDATION_CAP)).resolve().isPresent() ? ((SedationData)cap.resolve().get()).getLevel() : 0;
        if (this.canBeCrated(target) && target.getPersistentData().m_128471_("IsSedated") && sedationLevel >= AmbientAdditions.sedationLvlRequiredToCapture(target.m_21233_())) {
            if (target instanceof TamableAnimal) {
                TamableAnimal tame = (TamableAnimal)target;
                if (tame.m_21824_() && tame.m_21830_((LivingEntity)player)) {
                    return this.successfulCrate((LivingEntity)tame, player, hand, stack, level);
                }
                return this.unsuccessfulCrate((LivingEntity)tame, level);
            }
            return this.successfulCrate(target, player, hand, stack, level);
        }
        return InteractionResult.m_19078_((boolean)true);
    }

    public InteractionResult successfulCrate(LivingEntity target, Player player, InteractionHand hand, ItemStack stack, Level level) {
        boolean more;
        ItemStack stack1 = player.m_21120_(hand);
        boolean bl = more = stack.m_41613_() > 1;
        if (more) {
            stack1 = new ItemStack((ItemLike)AAItems.CRATE.get());
            stack.m_41774_(1);
        }
        CompoundTag targetTag = target.serializeNBT();
        targetTag.m_128359_("OwnerName", player.m_7755_().getString());
        CompoundTag tag = stack1.m_41784_();
        tag.m_128365_(DATA_CREATURE, (Tag)targetTag);
        stack1.m_41751_(tag);
        if (more) {
            if (!player.m_150109_().m_36054_(stack1)) {
                player.m_36176_(stack1, true);
            } else {
                player.m_36356_(stack1);
            }
        }
        target.m_146870_();
        level.m_5594_(null, player.m_20183_(), SoundEvents.f_11724_, SoundSource.AMBIENT, 1.0f, 1.0f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double width = target.m_20205_();
            int i = 0;
            while ((double)i <= Math.floor(width) * 25.0) {
                for (int j = 0; j < 8; ++j) {
                    double x = target.m_20208_(1.0);
                    double y = target.m_20187_();
                    double z = target.m_20262_(1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                }
                ++i;
            }
        }
        return InteractionResult.PASS;
    }

    private InteractionResult unsuccessfulCrate(LivingEntity target, Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double width = target.m_20205_();
            int i = 0;
            while ((double)i <= Math.floor(width) * 25.0) {
                for (int j = 0; j < 12; ++j) {
                    double x = target.m_20208_(1.0);
                    double y = target.m_20187_();
                    double z = target.m_20262_(1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 1, 0.0, 0.0, 0.0, 0.05);
                }
                ++i;
            }
        }
        return InteractionResult.PASS;
    }

    private boolean canBeCrated(LivingEntity entity) {
        return !(entity instanceof WitherBoss) && !(entity instanceof EnderDragon) && !(entity instanceof Warden) && !entity.m_6095_().m_204039_(AATags.UNCRATEABLE);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        BlockHitResult rt = CrateItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        ItemStack stack = player.m_21120_(hand);
        if (rt.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos pos = rt.m_82425_();
        if (!(level.m_8055_(pos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return new InteractionResultHolder(CrateItem.releaseEntity(level, player, stack, pos, rt.m_82434_()), (Object)stack);
    }

    public Component m_7626_(ItemStack stack) {
        MutableComponent name = (MutableComponent)super.m_7626_(stack);
        MutableComponent creatureName = CrateItem.containsEntity(stack) ? ((EntityType)EntityType.m_20632_((String)stack.m_41783_().m_128469_(DATA_CREATURE).m_128461_("id")).orElse(null)).m_20676_().m_6881_() : Component.m_237119_();
        return CrateItem.containsEntity(stack) ? name.m_6881_().m_130946_(" of ").m_7220_((Component)creatureName) : name;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (CrateItem.containsEntity(stack)) {
            CompoundTag tag = stack.m_41783_().m_128469_(DATA_CREATURE);
            MutableComponent name = tag.m_128441_("CustomName") ? Component.Serializer.m_130701_((String)tag.m_128461_("CustomName")) : ((EntityType)EntityType.m_20632_((String)tag.m_128461_("id")).orElse(null)).m_20676_().m_6881_().m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)name);
            String entity = EntityType.m_20613_((EntityType)EntityType.m_20632_((String)tag.m_128461_("id")).orElse(null)).m_135815_();
            MutableComponent extraInfo = Component.m_237115_((String)("tooltip.ambientadditions.fun_fact." + entity)).m_130944_(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC});
            if (Screen.m_96638_() && !extraInfo.getString().equals("tooltip.ambientadditions.fun_fact." + entity)) {
                tooltip.add((Component)extraInfo);
            }
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return CrateItem.containsEntity(stack);
    }

    public static boolean containsEntity(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(DATA_CREATURE);
    }

    private static InteractionResult releaseEntity(Level level, Player player, ItemStack stack, BlockPos pos, Direction direction) {
        LivingEntity entity;
        if (!CrateItem.containsEntity(stack)) {
            return InteractionResult.PASS;
        }
        CompoundTag tag = stack.m_41783_().m_128469_(DATA_CREATURE);
        EntityType type = EntityType.m_20632_((String)tag.m_128461_("id")).orElse(null);
        if (type == null || (entity = (LivingEntity)type.m_20615_(level)) == null) {
            AmbientAdditions.LOGGER.error("Something went wrong releasing an animal from a Crate!");
            return InteractionResult.FAIL;
        }
        EntityDimensions size = entity.m_6972_(entity.m_20089_());
        if (!level.m_8055_(pos).m_60812_((BlockGetter)level, pos).m_83281_()) {
            pos = pos.m_5484_(direction, (int)(direction.m_122434_().m_122479_() ? size.f_20377_ : 1.0f));
        }
        entity.m_20248_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        AABB aabb = entity.m_20191_();
        if (!level.m_45756_((Entity)entity, new AABB(aabb.f_82288_, entity.m_20188_() - 0.35, aabb.f_82290_, aabb.f_82291_, entity.m_20188_() + 1.0, aabb.f_82293_))) {
            return InteractionResult.FAIL;
        }
        if (!level.f_46443_) {
            UUID id = entity.m_20148_();
            entity.deserializeNBT(tag);
            entity.m_20084_(id);
            entity.m_7678_((double)pos.m_123341_(), (double)(pos.m_123342_() + direction.m_122430_()) + 1.0, (double)pos.m_123343_(), player.m_146908_(), 0.0f);
            if (stack.m_41788_()) {
                entity.m_6593_(stack.m_41786_());
            }
            stack.m_41749_(DATA_CREATURE);
            level.m_7967_((Entity)entity);
            level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11725_, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        if (context.m_43722_().m_41782_()) {
            ItemStack itemstack = context.m_43722_();
            BlockPos blockpos = context.m_8083_();
            Direction direction = context.m_43719_();
            BlockState blockstate = world.m_8055_(blockpos);
            BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)world, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
            ItemStack stack = context.m_43722_();
            CompoundTag tag = stack.m_41783_().m_128469_(DATA_CREATURE);
            EntityType type = EntityType.m_20632_((String)tag.m_128461_("id")).orElse(null);
            LivingEntity entity = (LivingEntity)type.m_20615_(context.m_43725_());
            if (entity == null) {
                return InteractionResult.FAIL;
            }
            UUID id = entity.m_20148_();
            entity.deserializeNBT(tag);
            entity.m_20084_(id);
            entity.m_7678_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_(), (double)blockpos1.m_123343_() + 0.5, context.m_43723_().m_146908_(), 0.0f);
            if (stack.m_41788_()) {
                entity.m_6593_(stack.m_41786_());
            }
            stack.m_41749_(DATA_CREATURE);
            if (context.m_43725_().m_7967_((Entity)entity)) {
                itemstack.m_41774_(1);
            }
            context.m_43725_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11725_, SoundSource.AMBIENT, 1.0f, 1.0f);
            context.m_43723_().m_21008_(context.m_43724_(), new ItemStack((ItemLike)AAItems.CRATE.get()));
            return InteractionResult.CONSUME;
        }
        return super.m_6225_(context);
    }
}

