/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.ambientadditions.common.entities;

import codyhuh.ambientadditions.common.entities.ai.movement.GroundAndSwimmerNavigator;
import codyhuh.ambientadditions.common.entities.ai.movement.SemiAquaticMoveControl;
import codyhuh.ambientadditions.common.entities.util.AAAnimations;
import codyhuh.ambientadditions.registry.AAEntities;
import codyhuh.ambientadditions.registry.AAItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MataMata
extends Animal
implements GeoEntity,
Bucketable {
    private static final EntityDataAccessor<ItemStack> EATING_ITEM = SynchedEntityData.m_135353_(MataMata.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(MataMata.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack eatingItem = ItemStack.f_41583_;
    private int eatingTicks = 0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public MataMata(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
        this.f_21342_ = new SemiAquaticMoveControl((Mob)this);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 45);
        this.m_21409_(EquipmentSlot.MAINHAND, 1.0f);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob p_146744_) {
        return (AgeableMob)((EntityType)AAEntities.MATA_MATA.get()).m_20615_((Level)level);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_((Item)AAItems.WORM.get()) || stack.m_204117_(ItemTags.f_13156_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EATING_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.1));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(1, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.15, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AAItems.WORM.get()}), true));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 10){

            public boolean m_8036_() {
                return !this.f_25725_.m_20069_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 1){

            public boolean m_8036_() {
                return super.m_8036_() && MataMata.this.m_20069_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractFish.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.eatingItem.m_41619_() && (stack.m_150930_((Item)AAItems.WORM.get()) || stack.m_204117_(ItemTags.f_13156_))) {
            player.m_6674_(hand);
            stack.m_41774_(1);
            this.eatingItem = stack.m_41777_();
            return InteractionResult.SUCCESS;
        }
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("eatingItem", (Tag)this.eatingItem.m_41739_(new CompoundTag()));
        pCompound.m_128405_("eatingTicks", this.eatingTicks);
        pCompound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.eatingItem = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("eatingItem"));
        this.eatingTicks = pCompound.m_128451_("eatingTicks");
        this.m_27497_(pCompound.m_128471_("FromBucket"));
    }

    public ItemStack getEatingItem() {
        return this.eatingItem;
    }

    public boolean m_7066_(ItemStack pItemstack) {
        return this.eatingItem.m_41619_();
    }

    public ItemStack m_255207_(ItemStack stack) {
        if (this.m_7252_(stack)) {
            if (!this.eatingItem.m_41619_()) {
                this.m_19983_(this.eatingItem);
            }
            this.eatingItem = stack.m_41777_();
            this.m_255207_(stack);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    protected void m_181122_(ItemStack p_181123_) {
        super.m_181122_(p_181123_);
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        if (pSlot == EquipmentSlot.MAINHAND) {
            return this.getEatingItem();
        }
        return super.m_6844_(pSlot);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.eatingItem.m_41619_() && this.m_6898_(this.eatingItem)) {
            ++this.eatingTicks;
            if (this.eatingTicks % 5 == 0 && this.m_9236_().f_46443_) {
                Vec3 look = this.m_20171_(this.m_5686_(1.0f), this.f_20883_);
                Vec3 pos = this.m_20318_(1.0f);
                Vec3 vec = pos.m_82520_(look.f_82479_, look.f_82480_, look.f_82481_);
                ItemParticleOption type = new ItemParticleOption(ParticleTypes.f_123752_, this.eatingItem);
                for (int i = 0; i < 6; ++i) {
                    this.m_9236_().m_6493_((ParticleOptions)type, true, vec.f_82479_, vec.f_82480_ + (double)0.2f, vec.f_82481_, ((double)-0.2f + (double)this.f_19796_.m_188501_() / 2.5) * (double)0.4f, (double)(this.f_19796_.m_188501_() / 5.0f), ((double)-0.2f + (double)this.f_19796_.m_188501_() / 2.5) * (double)0.4f);
                }
            }
            if (this.eatingTicks % 5 == 0) {
                this.m_5496_(SoundEvents.f_11912_, 8.0f, 1.0f);
            }
            if (this.eatingTicks >= 60) {
                this.eatingItem = ItemStack.f_41583_;
                this.eatingTicks = 0;
                this.m_9236_().m_7605_((Entity)this, (byte)18);
                this.m_5634_(4.0f);
            }
        }
        if (this.m_9236_().f_46443_) {
            this.eatingItem = (ItemStack)this.f_19804_.m_135370_(EATING_ITEM);
        } else {
            this.f_19804_.m_135381_(EATING_ITEM, (Object)this.eatingItem);
        }
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new GroundAndSwimmerNavigator((Mob)this, this.m_9236_());
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public float getStepHeight() {
        return 1.1f;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(0.1f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public static boolean canSpawn(EntityType<? extends Animal> p_186238_, LevelAccessor p_186239_, MobSpawnType p_186240_, BlockPos p_186241_, RandomSource p_186242_) {
        return p_186239_.m_6425_(p_186241_.m_7495_()).m_205070_(FluidTags.f_13131_) && p_186239_.m_8055_(p_186241_.m_7494_()).m_60713_(Blocks.f_49990_) || p_186239_.m_8055_(p_186241_.m_7495_()).m_60713_(Blocks.f_220864_);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)AAItems.MATA_MATA_SPAWN_EGG.get());
    }

    protected SoundEvent m_7515_() {
        return !this.m_20069_() ? SoundEvents.f_12530_ : super.m_7515_();
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12531_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12536_;
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public void m_6872_(ItemStack tag) {
        Bucketable.m_148822_((Mob)this, (ItemStack)tag);
        CompoundTag compoundtag = tag.m_41784_();
        compoundtag.m_128405_("Age", this.m_146764_());
    }

    public void m_142278_(CompoundTag tag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)tag);
        if (tag.m_128441_("Age")) {
            this.m_146762_(tag.m_128451_("Age"));
        }
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)AAItems.MATA_MATA_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_144077_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoEntity> PlayState predicate(AnimationState<T> event) {
        if (this.m_20069_() && event.isMoving()) {
            event.setAnimation(AAAnimations.SWIM);
        } else if (event.isMoving()) {
            event.setAnimation(AAAnimations.WALK);
        } else {
            event.setAnimation(AAAnimations.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

