/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.ambientadditions.common.entities;

import codyhuh.ambientadditions.common.entities.HarlequinShrimp;
import codyhuh.ambientadditions.common.entities.util.AAAnimations;
import codyhuh.ambientadditions.registry.AAItems;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ChocolateChipStarfish
extends WaterAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(ChocolateChipStarfish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ChocolateChipStarfish(EntityType<? extends WaterAnimal> p_i48568_1_, Level p_i48568_2_) {
        super(p_i48568_1_, p_i48568_2_);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)AAItems.CHOCOLATE_CHIP_STARFISH_SPAWN_EGG.get());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 0.0);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12529_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12527_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21223_() < this.m_21233_() && this.m_9236_().m_46468_() % 24000L == 0L) {
            this.m_21153_(this.m_21223_() + 1.0f);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (source.m_7639_() instanceof HarlequinShrimp) {
            ItemEntity item = (ItemEntity)EntityType.f_20461_.m_20615_(this.m_9236_());
            item.m_32045_(new ItemStack((ItemLike)AAItems.STARFISH_ARM.get()));
            item.m_20219_(this.m_20182_());
            this.m_9236_().m_7967_((Entity)item);
        }
        return super.m_6469_(source, damage);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    protected ItemStack getFishBucket() {
        return new ItemStack((ItemLike)AAItems.CHOCOLATE_CHIP_STARFISH_BUCKET.get());
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("Variant", this.getVariant());
        compoundnbt.m_128350_("Health", this.m_21223_());
    }

    protected InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        if (itemstack.m_41720_() == Items.f_42447_ && this.m_6084_()) {
            this.m_5496_(SoundEvents.f_11782_, 1.0f, 1.0f);
            itemstack.m_41774_(1);
            ItemStack itemstack1 = this.getFishBucket();
            this.setBucketData(itemstack1);
            if (!this.m_9236_().f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)p_230254_1_, itemstack1);
            }
            if (itemstack.m_41619_()) {
                p_230254_1_.m_21008_(p_230254_2_, itemstack1);
            } else if (!p_230254_1_.m_150109_().m_36054_(itemstack1)) {
                p_230254_1_.m_36176_(itemstack1, false);
            }
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(p_230254_1_, p_230254_2_);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    public static boolean checkStarfishSpawnRules(EntityType<? extends WaterAnimal> p_223316_0_, LevelAccessor p_223316_1_, MobSpawnType p_223316_2_, BlockPos p_223316_3_, RandomSource p_223316_4_) {
        return p_223316_1_.m_8055_(p_223316_3_).m_60713_(Blocks.f_49990_) && p_223316_4_.m_188501_() > 0.85f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (spawnDataIn == null) {
            this.setVariant(this.f_19796_.m_188503_(5));
        }
        return spawnDataIn;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (event.isMoving()) {
            event.setAnimation(AAAnimations.WALK);
        } else {
            event.setAnimation(AAAnimations.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

