/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.ambientadditions.common;

import codyhuh.ambientadditions.AmbientAdditions;
import codyhuh.ambientadditions.common.entities.RubberDuckyIsopod;
import codyhuh.ambientadditions.common.entities.util.AbstractFrog;
import codyhuh.ambientadditions.data.SedationData;
import codyhuh.ambientadditions.data.SedationProvider;
import codyhuh.ambientadditions.registry.AAEntities;
import codyhuh.ambientadditions.registry.AAItems;
import codyhuh.ambientadditions.registry.AAParticles;
import codyhuh.ambientadditions.registry.AATags;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ambientadditions", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void attachCapabilitiesAnimal(AttachCapabilitiesEvent<Entity> e) {
        PathfinderMob living;
        Object object = e.getObject();
        if (object instanceof PathfinderMob && !(living = (PathfinderMob)object).getCapability(SedationProvider.SEDATION_CAP).isPresent()) {
            e.addCapability(new ResourceLocation("ambientadditions", "sedation"), (ICapabilityProvider)new SedationProvider());
        }
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent e) {
        e.register(SedationData.class);
    }

    @SubscribeEvent
    public static void entityJoinWorld(EntityJoinLevelEvent e) {
        PathfinderMob living;
        Entity entity = e.getEntity();
        if (entity instanceof PathfinderMob && (living = (PathfinderMob)entity).getPersistentData().m_128423_("IsSedated") == null) {
            living.getPersistentData().m_128379_("IsSedated", false);
        }
    }

    @SubscribeEvent
    public static void entityTick(LivingEvent.LivingTickEvent e) {
        LivingEntity living = e.getEntity();
        CompoundTag tag = living.getPersistentData();
        LazyOptional cap = living.getCapability(SedationProvider.SEDATION_CAP);
        Level level = living.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (living instanceof PathfinderMob) {
                PathfinderMob mob = (PathfinderMob)living;
                if (cap.isPresent()) {
                    SedationData provider;
                    SedationData sedationData = provider = cap.resolve().isPresent() ? (SedationData)cap.resolve().get() : null;
                    if (provider != null) {
                        int i = provider.getTimer();
                        if (i == 0) {
                            provider.setLevel(0);
                            tag.m_128379_("IsSedated", false);
                            mob.f_21345_.m_25374_(Goal.Flag.LOOK);
                            mob.f_21345_.m_25374_(Goal.Flag.MOVE);
                            mob.f_21345_.m_25374_(Goal.Flag.JUMP);
                        } else if (i > 0) {
                            provider.setTimer(i - 1);
                        }
                        if (provider.getLevel() >= AmbientAdditions.sedationLvlRequiredToCapture(living.m_21233_())) {
                            ForgeEvents.zzzParticles(living, 30, serverLevel);
                            mob.m_21573_().m_26573_();
                            mob.f_21345_.m_25355_(Goal.Flag.LOOK);
                            mob.f_21345_.m_25355_(Goal.Flag.MOVE);
                            mob.f_21345_.m_25355_(Goal.Flag.JUMP);
                        }
                    }
                }
            }
        }
    }

    private static void zzzParticles(LivingEntity entity, int amount, ServerLevel level) {
        if (entity.f_19797_ % amount == 0) {
            level.m_8767_((ParticleOptions)((SimpleParticleType)AAParticles.ZZZ.get()), ForgeEvents.getHeadOffset(entity).m_7096_(), ForgeEvents.getHeadOffset(entity).m_7098_(), ForgeEvents.getHeadOffset(entity).m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static Vec3 getHeadOffset(LivingEntity entity) {
        return ForgeEvents.getYawVec(entity.m_146908_(), 0.0, entity.m_20192_() + entity.m_20206_() * 0.3f, entity.m_20205_() * 0.5f).m_82549_(entity.m_20182_());
    }

    public static Vec3 getYawVec(float yaw, double xOffset, double yOffset, double zOffset) {
        return new Vec3(xOffset, yOffset, zOffset).m_82524_(-yaw * ((float)Math.PI / 180));
    }

    @SubscribeEvent
    public static void frogBreed(BabyEntitySpawnEvent e) {
        Mob mob = e.getParentA();
        if (mob instanceof AbstractFrog) {
            AbstractFrog parentA = (AbstractFrog)mob;
            mob = e.getParentB();
            if (mob instanceof AbstractFrog) {
                AbstractFrog parentB = (AbstractFrog)mob;
                parentA.setGravid(true);
                parentB.m_21573_().m_26573_();
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLogStripped(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().m_41720_() instanceof AxeItem) {
            BlockPos pos;
            Level world = event.getLevel();
            BlockState state = world.m_8055_(pos = event.getPos());
            if (state.m_60713_(Blocks.f_50002_) && world.f_46441_.m_188503_(40) == 0) {
                RubberDuckyIsopod entity = (RubberDuckyIsopod)((EntityType)AAEntities.RUBBER_DUCKY_ISOPOD.get()).m_20615_(world);
                if (world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50016_)) {
                    pos = pos.m_7494_();
                } else if (world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50016_)) {
                    pos = pos.m_7495_();
                } else if (world.m_8055_(pos.m_122012_()).m_60713_(Blocks.f_50016_)) {
                    pos = pos.m_122012_();
                } else if (world.m_8055_(pos.m_122019_()).m_60713_(Blocks.f_50016_)) {
                    pos = pos.m_122019_();
                } else if (world.m_8055_(pos.m_122029_()).m_60713_(Blocks.f_50016_)) {
                    pos = pos.m_122029_();
                } else if (world.m_8055_(pos.m_122024_()).m_60713_(Blocks.f_50016_)) {
                    pos = pos.m_122024_();
                }
                entity.m_6027_((float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f);
                world.m_7967_((Entity)entity);
            }
            if (state.m_60734_().m_49966_().m_204336_(AATags.STRIPPABLE_LOGS) && world.f_46441_.m_188499_()) {
                ItemStack stack = new ItemStack((ItemLike)AAItems.BARK.get());
                ItemEntity entity = (ItemEntity)EntityType.f_20461_.m_20615_(world);
                entity.m_32045_(stack);
                entity.m_6027_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                world.m_7967_((Entity)entity);
            }
        }
    }

    @SubscribeEvent
    public static void addWanderingTrades(WandererTradesEvent event) {
        List trades = event.getGenericTrades();
        trades.add(new ItemsForItemsTrade(new ItemStack((ItemLike)Items.f_42616_, 6), new ItemStack((ItemLike)AAItems.HARLEQUIN_SHRIMP_BUCKET.get()), 3, 4, 1.5f));
        trades.add(new ItemsForItemsTrade(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)AAItems.MOLE_BUCKET.get()), 3, 4, 1.5f));
        trades.add(new ItemsForItemsTrade(new ItemStack((ItemLike)Items.f_42616_, 3), new ItemStack((ItemLike)AAItems.CHOCOLATE_CHIP_STARFISH_BUCKET.get()), 3, 4, 1.5f));
        trades.add(new ItemsForItemsTrade(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)AAItems.SHAME_FACED_CRAB_BUCKET.get()), 3, 4, 1.5f));
        trades.add(new ItemsForItemsTrade(new ItemStack((ItemLike)Items.f_42616_, 7), new ItemStack((ItemLike)AAItems.LONGHORN_COWFISH_BUCKET.get()), 3, 4, 1.5f));
        trades.add(new ItemsForItemsTrade(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)AAItems.LEAF_FROG_BOWL.get()), 3, 4, 1.5f));
    }

    private static class ItemsForItemsTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack buying1;
        private final ItemStack buying2;
        private final ItemStack selling;
        private final int maxUses;
        private final int xp;
        private final float priceMultiplier;

        public ItemsForItemsTrade(ItemStack buying1, ItemStack buying2, ItemStack selling, int maxUses, int xp, float priceMultiplier) {
            this.buying1 = buying1;
            this.buying2 = buying2;
            this.selling = selling;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMultiplier = priceMultiplier;
        }

        public ItemsForItemsTrade(ItemStack buying1, ItemStack selling, int maxUses, int xp, float priceMultiplier) {
            this(buying1, ItemStack.f_41583_, selling, maxUses, xp, priceMultiplier);
        }

        @Nullable
        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            return new MerchantOffer(this.buying1, this.buying2, this.selling, this.maxUses, this.xp, this.priceMultiplier);
        }
    }
}

