/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.display;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.torocraft.torohealth.ToroHealth;
import net.torocraft.torohealth.config.Config;
import net.torocraft.torohealth.display.BarDisplay;
import net.torocraft.torohealth.display.EntityDisplay;

public class Hud
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("torohealth:textures/gui/default_skin_basic.png");
    private final EntityDisplay entityDisplay = new EntityDisplay();
    private LivingEntity entity;
    private final BarDisplay barDisplay;
    private Config config = new Config();
    private int age;

    public Hud() {
        super((Component)Component.m_237113_((String)"ToroHealth HUD"));
        this.f_96541_ = Minecraft.m_91087_();
        this.barDisplay = new BarDisplay(Minecraft.m_91087_());
    }

    public void draw(ForgeGui gui, GuiGraphics poseStack, float partialTick, int width, int height) {
        if (this.f_96541_ == null || this.f_96541_.f_91066_.f_92063_) {
            return;
        }
        this.config = ToroHealth.CONFIG;
        if (this.config == null) {
            this.config = new Config();
        }
        float x = this.determineX();
        float y = this.determineY();
        this.draw(poseStack, x, y, this.config.hud.scale);
    }

    private float determineX() {
        Objects.requireNonNull(this.config.hud);
        float x = 4.0f;
        Config.AnchorPoint anchor = this.config.hud.anchorPoint;
        float wScreen = this.f_96541_.m_91268_().m_85446_();
        return switch (anchor) {
            case Config.AnchorPoint.BOTTOM_CENTER, Config.AnchorPoint.TOP_CENTER -> wScreen / 2.0f + x;
            case Config.AnchorPoint.BOTTOM_RIGHT, Config.AnchorPoint.TOP_RIGHT -> wScreen + x;
            default -> x;
        };
    }

    private float determineY() {
        Objects.requireNonNull(this.config.hud);
        float y = 4.0f;
        Config.AnchorPoint anchor = this.config.hud.anchorPoint;
        if (this.f_96541_ == null) {
            return y;
        }
        float hScreen = this.f_96541_.m_91268_().m_85446_();
        return switch (anchor) {
            case Config.AnchorPoint.BOTTOM_CENTER, Config.AnchorPoint.BOTTOM_RIGHT, Config.AnchorPoint.BOTTOM_LEFT -> y + hScreen;
            default -> y;
        };
    }

    public void m_86600_() {
        ++this.age;
    }

    public void setEntity(LivingEntity entity) {
        if (entity != null) {
            this.age = 0;
        }
        if (entity == null && this.age > this.config.hud.hideDelay) {
            this.setEntityWork(null);
        }
        if (entity != null && entity != this.entity) {
            this.setEntityWork(entity);
        }
    }

    private void setEntityWork(LivingEntity entity) {
        this.entity = entity;
        this.entityDisplay.setEntity(entity);
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    private void draw(GuiGraphics graphics, float x, float y, float scale) {
        if (this.entity == null) {
            return;
        }
        Objects.requireNonNull(this.config.hud);
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        matrix.m_85841_(scale, scale, scale);
        matrix.m_252880_(x - 10.0f, y - 10.0f, 0.0f);
        Objects.requireNonNull(this.config.hud);
        this.drawSkin(graphics);
        matrix.m_252880_(10.0f, 10.0f, 0.0f);
        Objects.requireNonNull(this.config.hud);
        this.entityDisplay.draw(graphics.m_280168_(), scale);
        matrix.m_252880_(44.0f, 0.0f, 0.0f);
        Objects.requireNonNull(this.config.hud);
        this.barDisplay.draw(graphics, this.entity);
        matrix.m_85849_();
    }

    private void drawSkin(GuiGraphics graphics) {
        int w = 160;
        int h = 60;
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280163_(BACKGROUND_TEXTURE, 0, 0, 0.0f, 0.0f, w, h, w, h);
    }
}

