/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.config;

import com.google.gson.annotations.JsonAdapter;
import net.torocraft.torohealth.config.loader.ColorJsonAdapter;
import net.torocraft.torohealth.config.loader.IConfig;

public class Config
implements IConfig {
    public final boolean watchForChanges = true;
    public final Hud hud = new Hud();
    public final Bar bar = new Bar();
    public final InWorld inWorld = new InWorld();
    public final Particle particle = new Particle();

    @Override
    public void update() {
        this.particle.distanceSquared = this.particle.distance * this.particle.distance;
    }

    @Override
    public boolean shouldWatch() {
        return true;
    }

    public static class Hud {
        public final int distance = 60;
        public final float x = 4.0f;
        public final float y = 4.0f;
        public final float scale = 1.0f;
        public final int hideDelay = 20;
        public final AnchorPoint anchorPoint = AnchorPoint.TOP_LEFT;
        public final boolean showEntity = true;
        public final boolean showBar = true;
        public final boolean showSkin = true;
        public final boolean onlyWhenHurt = false;
    }

    public static class Bar {
        public final NumberType damageNumberType = NumberType.LAST;
        @JsonAdapter(value=ColorJsonAdapter.class)
        public final int friendColor = 65280;
        @JsonAdapter(value=ColorJsonAdapter.class)
        public final int friendColorSecondary = 32768;
        @JsonAdapter(value=ColorJsonAdapter.class)
        public final int foeColor = 0xFF0000;
        @JsonAdapter(value=ColorJsonAdapter.class)
        public final int foeColorSecondary = 0x800000;
    }

    public static class InWorld {
        public final Mode mode = Mode.NONE;
        public final float distance = 60.0f;
        public final boolean onlyWhenLookingAt = false;
        public final boolean onlyWhenHurt = false;
    }

    public static class Particle {
        public final boolean show = true;
        @JsonAdapter(value=ColorJsonAdapter.class)
        public final int damageColor = 0xFF0000;
        @JsonAdapter(value=ColorJsonAdapter.class)
        public final int healColor = 65280;
        public final int distance = 60;
        public transient int distanceSquared = 0;
    }

    public static enum AnchorPoint {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }

    public static enum NumberType {
        NONE,
        LAST,
        CUMULATIVE;

    }

    public static enum Mode {
        NONE,
        WHEN_HOLDING_WEAPON,
        ALWAYS;

    }
}

