/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.toolswap;

import com.google.common.collect.Lists;
import de.melanx.toolswap.ClientConfig;
import de.melanx.toolswap.DiggerLike;
import de.melanx.toolswap.SortType;
import de.melanx.toolswap.ToolEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ToggleKeyMapping;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientToolSwap {
    public static final Logger LOGGER = LogManager.getLogger(ClientToolSwap.class);
    public static final ToggleKeyMapping TOGGLE = new ToggleKeyMapping("toolswap.key.toggle_toolswap_mode", 71, "Automatic Tool Swap", () -> false);
    private static final File CONFIG_FILE = FMLPaths.CONFIGDIR.get().resolve(".toolswap").toFile();
    private static int PREV_SLOT = -1;
    private static boolean TOGGLE_STATE = false;
    public static MutableComponent WARNING = Component.m_237115_((String)"toolswap.warning");

    public ClientToolSwap() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_CONFIG);
        ClientConfig.loadConfig(ClientConfig.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("toolswap-client.toml"));
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onKeyRegistration);
        try {
            TOGGLE_STATE = !ClientToolSwap.getContent().equals("0");
            FileWriter writer = new FileWriter(CONFIG_FILE);
            writer.write(TOGGLE_STATE ? "1" : "0");
            writer.close();
        }
        catch (IOException e) {
            LOGGER.warn((Object)e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onKeyRegistration(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)TOGGLE);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void keyInput(InputEvent.Key event) {
        if (event.getKey() == TOGGLE.getKey().m_84873_() && event.getAction() == 1 && Minecraft.m_91087_().f_91080_ == null) {
            ClientToolSwap.handleInput();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void mouseInput(InputEvent.MouseButton.Post event) {
        if (event.getButton() == TOGGLE.getKey().m_84873_() && event.getAction() == 1 && Minecraft.m_91087_().f_91080_ == null) {
            ClientToolSwap.handleInput();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof LocalPlayer) {
            LocalPlayer player2 = (LocalPlayer)player;
            if (PREV_SLOT != -1 && event.side.isClient() && !Minecraft.m_91087_().f_91066_.f_92096_.m_90857_()) {
                this.resetCurrentSlot(player2);
            }
        }
    }

    private static void handleInput() {
        MutableComponent on_off;
        ClientToolSwap.toggleMode();
        if (TOGGLE_STATE) {
            MutableComponent on = Component.m_237115_((String)"toolswap.key.toggle_toolswap_notification.state_on");
            on.m_130948_(Style.f_131099_.m_131157_(ChatFormatting.GREEN));
            on_off = on;
        } else {
            MutableComponent off = Component.m_237115_((String)"toolswap.key.toggle_toolswap_notification.state_off");
            off.m_130948_(Style.f_131099_.m_131157_(ChatFormatting.DARK_RED));
            on_off = off;
        }
        MutableComponent statusMessage = Component.m_237110_((String)"toolswap.key.toggle_toolswap_notification", (Object[])new Object[]{TOGGLE_STATE});
        statusMessage.m_130946_(": ").m_7220_((Component)on_off);
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)statusMessage, true);
        }
        LOGGER.debug("Set tool swap mode to {}", (Object)TOGGLE_STATE);
    }

    public static void searchForSwitching(MultiPlayerGameMode multiPlayerGameMode, BlockPos pos) {
        ClientLevel level = multiPlayerGameMode.f_105189_.f_91073_;
        LocalPlayer player = multiPlayerGameMode.f_105189_.f_91074_;
        if (level == null || player == null) {
            return;
        }
        if (!Objects.equals(player.m_36316_().getId(), Minecraft.m_91087_().f_91074_.m_36316_().getId())) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        if (ClientToolSwap.toolAboutBreaking(heldItem)) {
            ClientToolSwap.saveItem((Player)player);
        }
        if (TOGGLE_STATE && !ClientToolSwap.shouldIgnore(heldItem)) {
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (!((Boolean)ClientConfig.sneakToPrevent.get()).booleanValue() || !player.m_6144_()) {
                float blockHardness;
                ArrayList tools = Lists.newArrayList();
                List<ItemStack> swords = Lists.newArrayList();
                List<ItemStack> shears = Lists.newArrayList();
                Set toolTypes = state.m_204343_().filter(tag -> tag.f_203868_().m_135815_().startsWith("mineable/")).collect(Collectors.toSet());
                for (int i = 0; i < 9; ++i) {
                    ItemStack stack = player.m_150109_().m_8020_(i);
                    if (ClientConfig.swapMode.get() == ClientConfig.SwapMode.TAG && !stack.m_204117_(ItemTags.f_271540_) || ClientToolSwap.toolAboutBreaking(stack)) continue;
                    for (Object type : toolTypes) {
                        Predicate<ItemStack> stackPredicate = ClientToolSwap.predicateFor((TagKey<Block>)type);
                        if (stackPredicate == null) {
                            LOGGER.warn("Unhandled block tag: {}", type);
                            continue;
                        }
                        if (stackPredicate.test(stack)) continue;
                        if (heldItem == stack && ((Boolean)ClientConfig.ignoreHarvestLevel.get()).booleanValue() && !state.m_60713_(Blocks.f_50033_)) {
                            return;
                        }
                        tools.add(new ToolEntry((TagKey<Block>)type, stack));
                    }
                    if (stack.m_41720_() instanceof SwordItem) {
                        swords.add(stack);
                    }
                    if (!stack.m_204117_(Tags.Items.SHEARS)) continue;
                    shears.add(stack);
                }
                List finalToolList = Lists.newArrayList();
                switch ((SortType)((Object)ClientConfig.sortType.get())) {
                    case LEVEL: {
                        tools.sort(Comparator.comparingInt(ToolEntry::getHarvestLevel));
                        finalToolList = tools;
                        break;
                    }
                    case LEVEL_INVERTED: {
                        tools.sort(Comparator.comparingInt(ToolEntry::getHarvestLevel));
                        finalToolList = Lists.reverse((List)tools);
                        break;
                    }
                    case RIGHT_TO_LEFT: {
                        finalToolList = Lists.reverse((List)tools);
                        swords = Lists.reverse((List)swords);
                        shears = Lists.reverse((List)shears);
                        break;
                    }
                    case LEFT_TO_RIGHT: {
                        finalToolList = tools;
                        break;
                    }
                    case ENCHANTED_FIRST: {
                        ArrayList enchanted = Lists.newArrayList();
                        ArrayList unenchanted = Lists.newArrayList();
                        tools.forEach(toolEntry -> {
                            if (toolEntry.getStack().m_41793_()) {
                                enchanted.add(toolEntry);
                            } else {
                                unenchanted.add(toolEntry);
                            }
                        });
                        enchanted.sort(Comparator.comparingInt(ToolEntry::getHarvestLevel));
                        finalToolList.addAll(Lists.reverse((List)enchanted));
                        unenchanted.sort(Comparator.comparingInt(ToolEntry::getHarvestLevel));
                        finalToolList.addAll(Lists.reverse((List)unenchanted));
                        break;
                    }
                    case ENCHANTED_LAST: {
                        ArrayList enchanted = Lists.newArrayList();
                        ArrayList unenchanted = Lists.newArrayList();
                        tools.forEach(toolEntry -> {
                            if (toolEntry.getStack().m_41793_()) {
                                enchanted.add(toolEntry);
                            } else {
                                unenchanted.add(toolEntry);
                            }
                        });
                        unenchanted.sort(Comparator.comparingInt(ToolEntry::getHarvestLevel));
                        finalToolList.addAll(Lists.reverse((List)unenchanted));
                        enchanted.sort(Comparator.comparingInt(ToolEntry::getHarvestLevel));
                        finalToolList.addAll(Lists.reverse((List)enchanted));
                    }
                }
                if (state.m_60713_(Blocks.f_50033_)) {
                    if (swords.isEmpty()) {
                        return;
                    }
                    if (PREV_SLOT == -1) {
                        PREV_SLOT = player.m_150109_().f_35977_;
                    }
                    ClientToolSwap.switchTo(player, (ItemStack)swords.get(0));
                    return;
                }
                if (state.m_204336_(BlockTags.f_13089_) || state.m_204336_(BlockTags.f_13035_)) {
                    if (shears.isEmpty()) {
                        return;
                    }
                    if (PREV_SLOT == -1) {
                        PREV_SLOT = player.m_150109_().f_35977_;
                    }
                    ClientToolSwap.switchTo(player, (ItemStack)shears.get(0));
                    return;
                }
                if (finalToolList.isEmpty()) {
                    return;
                }
                Set mineables = BuiltInRegistries.f_256975_.m_246971_(block.m_204297_().m_205785_()).m_203616_().map(TagKey::f_203868_).filter(location -> location.m_135815_().startsWith("mineable/")).collect(Collectors.toSet());
                if (PREV_SLOT == -1) {
                    PREV_SLOT = player.m_150109_().f_35977_;
                }
                if (mineables.isEmpty() && (blockHardness = state.m_60800_((BlockGetter)player.m_9236_(), pos)) > 0.0f) {
                    for (ToolEntry entry : finalToolList) {
                        if (!(entry.getStack().m_41691_(state) >= entry.getEfficiency())) continue;
                        ResourceLocation id = entry.getType().f_203868_();
                        mineables.add(id);
                    }
                }
                if (!mineables.isEmpty()) {
                    for (ToolEntry entry : finalToolList) {
                        for (ResourceLocation id : mineables) {
                            DiggerLike diggerItem = entry.getToolItem();
                            if (diggerItem == null || !Objects.equals(entry.getType().f_203868_(), id) || !TierSortingRegistry.isCorrectTierForDrops((Tier)diggerItem.getTier(), (BlockState)state)) continue;
                            ClientToolSwap.switchTo(player, entry.getStack());
                            return;
                        }
                    }
                }
                if (heldItem.m_41720_().m_41465_()) {
                    for (int i = 0; i < 9; ++i) {
                        ItemStack stack = player.m_150109_().m_8020_(i);
                        if (stack.m_41720_().m_41465_()) continue;
                        ClientToolSwap.switchTo(player, i);
                        return;
                    }
                }
            }
        }
    }

    private static void switchTo(LocalPlayer player, ItemStack stack) {
        ClientToolSwap.switchTo(player, player.m_150109_().m_36030_(stack));
    }

    private static void switchTo(LocalPlayer player, int slotId) {
        if (player.m_150109_().f_35977_ == slotId) {
            return;
        }
        player.m_150109_().f_35977_ = slotId;
    }

    private static boolean toolAboutBreaking(ItemStack stack) {
        return (Boolean)ClientConfig.saveBreakingTools.get() != false && stack.m_41763_() && stack.m_41773_() == stack.m_41776_() - (Integer)ClientConfig.minDurability.get();
    }

    private static void saveItem(Player player) {
        ItemStack equalTool;
        MultiPlayerGameMode controller = Minecraft.m_91087_().f_91072_;
        AbstractContainerMenu container = player.f_36096_;
        int emptySlot = -1;
        ItemStack currentTool = player.m_150109_().m_8020_(player.m_150109_().f_35977_);
        if (currentTool != (equalTool = ClientToolSwap.findEqualTool(player.m_150109_(), currentTool))) {
            emptySlot = player.m_150109_().m_36030_(equalTool);
        }
        if (emptySlot == -1) {
            for (Slot slot : container.f_38839_) {
                if (slot.f_40219_ <= 9 || !slot.m_7993_().m_41619_()) continue;
                emptySlot = slot.f_40219_;
                break;
            }
        }
        if (emptySlot != -1) {
            controller.m_171799_(container.f_38840_, player.m_150109_().f_35977_ + 36, 0, ClickType.PICKUP, player);
            controller.m_171799_(container.f_38840_, emptySlot, 0, ClickType.PICKUP, player);
            controller.m_171799_(container.f_38840_, player.m_150109_().f_35977_ + 36, 0, ClickType.PICKUP, player);
        } else {
            player.m_5661_((Component)WARNING, true);
        }
    }

    private static boolean shouldIgnore(ItemStack heldItem) {
        boolean bl;
        block7: {
            block6: {
                switch ((ClientConfig.IgnoreMode)((Object)ClientConfig.ignoreEmptyHand.get())) {
                    case EMPTY_HAND: {
                        if (!heldItem.m_41619_()) break;
                        break block6;
                    }
                    case ITEMS: {
                        if (heldItem.m_41619_()) break;
                        break block6;
                    }
                    case TOOLS: {
                        if (!heldItem.m_204117_(ItemTags.f_271540_)) break;
                        break block6;
                    }
                    case NO_TOOLS: {
                        if (heldItem.m_204117_(ItemTags.f_271540_)) break;
                        break block6;
                    }
                    default: {
                        break block6;
                    }
                }
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    private static ItemStack findEqualTool(Inventory inventory, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof DiggerItem) {
            DiggerItem item2 = (DiggerItem)item;
            Iterable tagOrEmpty = BuiltInRegistries.f_256975_.m_206058_(item2.f_40979_);
            if (!tagOrEmpty.iterator().hasNext()) {
                return stack;
            }
            for (ItemStack tool : inventory.f_35974_) {
                if (tool.m_41720_() != stack.m_41720_() || ClientToolSwap.toolAboutBreaking(tool)) continue;
                return tool;
            }
        }
        return stack;
    }

    private void resetCurrentSlot(LocalPlayer player) {
        if (PREV_SLOT >= 0) {
            ClientToolSwap.switchTo(player, PREV_SLOT);
            PREV_SLOT = -1;
        }
    }

    private static Predicate<ItemStack> predicateFor(TagKey<Block> blockTag) {
        if (ClientConfig.swapMode.get() == ClientConfig.SwapMode.TAG) {
            if (blockTag == BlockTags.f_144280_) {
                return stack -> !stack.m_204117_(ItemTags.f_271207_);
            }
            if (blockTag == BlockTags.f_144281_) {
                return stack -> !stack.m_204117_(ItemTags.f_271298_);
            }
            if (blockTag == BlockTags.f_144282_) {
                return stack -> !stack.m_204117_(ItemTags.f_271360_);
            }
            if (blockTag == BlockTags.f_144283_) {
                return stack -> !stack.m_204117_(ItemTags.f_271138_);
            }
            return null;
        }
        if (blockTag == BlockTags.f_144280_) {
            return stack -> !stack.m_150930_(Items.f_42423_) && !stack.m_150930_(Items.f_42428_) && !stack.m_150930_(Items.f_42386_) && !stack.m_150930_(Items.f_42433_) && !stack.m_150930_(Items.f_42391_) && !stack.m_150930_(Items.f_42396_);
        }
        if (blockTag == BlockTags.f_144281_) {
            return stack -> !stack.m_150930_(Items.f_42424_) && !stack.m_150930_(Items.f_42429_) && !stack.m_150930_(Items.f_42387_) && !stack.m_150930_(Items.f_42434_) && !stack.m_150930_(Items.f_42392_) && !stack.m_150930_(Items.f_42397_);
        }
        if (blockTag == BlockTags.f_144282_) {
            return stack -> !stack.m_150930_(Items.f_42422_) && !stack.m_150930_(Items.f_42427_) && !stack.m_150930_(Items.f_42385_) && !stack.m_150930_(Items.f_42432_) && !stack.m_150930_(Items.f_42390_) && !stack.m_150930_(Items.f_42395_);
        }
        if (blockTag == BlockTags.f_144283_) {
            return stack -> !stack.m_150930_(Items.f_42421_) && !stack.m_150930_(Items.f_42426_) && !stack.m_150930_(Items.f_42384_) && !stack.m_150930_(Items.f_42431_) && !stack.m_150930_(Items.f_42389_) && !stack.m_150930_(Items.f_42394_);
        }
        return null;
    }

    private static void toggleMode() {
        try {
            FileInputStream stream = new FileInputStream(CONFIG_FILE);
            String setting = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
            FileWriter writer = new FileWriter(CONFIG_FILE);
            if (setting.equals("1")) {
                writer.write("0");
                TOGGLE_STATE = false;
            } else {
                writer.write("1");
                TOGGLE_STATE = true;
            }
            writer.close();
        }
        catch (IOException e) {
            LOGGER.warn((Object)e);
        }
    }

    private static String getContent() {
        try {
            FileInputStream stream = new FileInputStream(CONFIG_FILE);
            String setting = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            return setting.trim();
        }
        catch (IOException e) {
            LOGGER.warn((Object)e);
            return "";
        }
    }

    static {
        WARNING.m_130940_(ChatFormatting.DARK_RED);
    }
}

