/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.apache.commons.lang3.function.ToBooleanBiFunction;

public class InvalidateAttackTarget<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.f_26326_, (Object)MemoryStatus.REGISTERED)});
    protected ToBooleanBiFunction<E, LivingEntity> customPredicate = (entity, target) -> {
        Player pl;
        return target instanceof Player && ((pl = (Player)target).m_7500_() || pl.m_5833_());
    };
    protected long pathfindingAttentionSpan = 200L;

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public InvalidateAttackTarget<E> invalidateIf(ToBooleanBiFunction<E, LivingEntity> predicate) {
        this.customPredicate = predicate;
        return this;
    }

    public InvalidateAttackTarget<E> ignoreFailedPathfinding() {
        return this.stopTryingToPathAfter(0L);
    }

    public InvalidateAttackTarget<E> stopTryingToPathAfter(long ticks) {
        this.pathfindingAttentionSpan = ticks;
        return this;
    }

    @Override
    protected void start(E entity) {
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        if (target == null) {
            return;
        }
        if (this.isTargetInvalid(entity, target) || !this.canAttack(entity, target) || this.isTiredOfPathing(entity) || this.customPredicate.applyAsBoolean(entity, (Object)target)) {
            BrainUtils.clearMemory(entity, MemoryModuleType.f_26372_);
        }
    }

    protected boolean isTargetInvalid(E entity, LivingEntity target) {
        if (entity.m_9236_() != target.m_9236_()) {
            return true;
        }
        return target.m_21224_() || target.m_213877_();
    }

    protected boolean canAttack(E entity, LivingEntity target) {
        return entity.m_6779_(target);
    }

    protected boolean isTiredOfPathing(E entity) {
        if (this.pathfindingAttentionSpan <= 0L) {
            return false;
        }
        Long time = (Long)BrainUtils.getMemory(entity, MemoryModuleType.f_26326_);
        return time != null && entity.m_9236_().m_46467_() - time > this.pathfindingAttentionSpan;
    }
}

