/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.misc;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.animal.Animal;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class BreedWithPartner<E extends Animal>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26375_, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT)});
    protected BiFunction<E, Animal, Float> speedMod = (entity, partner) -> Float.valueOf(1.0f);
    protected BiFunction<E, Animal, Integer> breedTime = (entity, partner) -> entity.m_217043_().m_216339_(60, 110);
    protected BiPredicate<E, Animal> partnerPredicate = (entity, partner) -> entity.m_6095_() == partner.m_6095_() && entity.m_7848_(partner);
    protected int childBreedTick = -1;
    protected Animal partner = null;

    public BreedWithPartner() {
        this.runFor(entity -> Integer.MAX_VALUE);
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public BreedWithPartner<E> speedMod(BiFunction<E, Animal, Float> speedModifier) {
        this.speedMod = speedModifier;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        if (!entity.m_27593_()) {
            return false;
        }
        this.partner = this.findPartner(entity);
        return this.partner != null;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return this.partner != null && this.partner.m_6084_() && ((Animal)entity).f_19797_ <= this.childBreedTick && BehaviorUtils.m_22636_((Brain)entity.m_6274_(), (LivingEntity)this.partner) && this.partnerPredicate.test(entity, this.partner);
    }

    @Override
    protected void start(E entity) {
        this.childBreedTick = ((Animal)entity).f_19797_ + this.breedTime.apply(entity, this.partner);
        BrainUtils.setMemory(entity, MemoryModuleType.f_26375_, this.partner);
        BrainUtils.setMemory((LivingEntity)this.partner, MemoryModuleType.f_26375_, entity);
        BehaviorUtils.m_22602_(entity, (LivingEntity)this.partner, (float)this.speedMod.apply(entity, this.partner).floatValue());
    }

    @Override
    protected void tick(E entity) {
        BehaviorUtils.m_22602_(entity, (LivingEntity)this.partner, (float)this.speedMod.apply(entity, this.partner).floatValue());
        if (entity.m_19950_((Entity)this.partner, 3.0) && ((Animal)entity).f_19797_ == this.childBreedTick) {
            entity.m_27563_((ServerLevel)entity.m_9236_(), this.partner);
            BrainUtils.clearMemory(entity, MemoryModuleType.f_26375_);
            BrainUtils.clearMemory((LivingEntity)this.partner, MemoryModuleType.f_26375_);
        }
    }

    @Override
    protected void stop(E entity) {
        BrainUtils.clearMemories(entity, new MemoryModuleType[]{MemoryModuleType.f_26375_, MemoryModuleType.f_26371_, MemoryModuleType.f_26370_});
        if (this.partner != null) {
            BrainUtils.clearMemories((LivingEntity)this.partner, MemoryModuleType.f_26375_, MemoryModuleType.f_26371_, MemoryModuleType.f_26370_);
        }
        this.childBreedTick = -1;
        this.partner = null;
    }

    @Nullable
    protected Animal findPartner(E entity) {
        return ((NearestVisibleLivingEntities)BrainUtils.getMemory(entity, MemoryModuleType.f_148205_)).m_186116_(entity2 -> {
            Animal partner;
            return entity2 instanceof Animal && this.partnerPredicate.test(entity, partner = (Animal)entity2);
        }).map(Animal.class::cast).orElse(null);
    }
}

