/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.plugin;

import com.github.exopandora.shouldersurfing.api.callback.IAdaptiveItemCallback;
import com.github.exopandora.shouldersurfing.api.callback.ICameraCouplingCallback;
import com.github.exopandora.shouldersurfing.api.callback.ITargetCameraOffsetCallback;
import com.github.exopandora.shouldersurfing.api.client.IShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingRegistrar;
import com.github.exopandora.shouldersurfing.plugin.PluginContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ShoulderSurfingRegistrar
implements IShoulderSurfingRegistrar {
    private static final ShoulderSurfingRegistrar INSTANCE = new ShoulderSurfingRegistrar();
    private final List<IAdaptiveItemCallback> adaptiveItemCallbacks = new ArrayList<IAdaptiveItemCallback>();
    private final List<ICameraCouplingCallback> cameraCouplingCallbacks = new ArrayList<ICameraCouplingCallback>();
    private final List<ITargetCameraOffsetCallback> targetCameraOffsetCallbacks = new ArrayList<ITargetCameraOffsetCallback>();
    private boolean isFrozen;
    private PluginContext activePluginContext;

    private ShoulderSurfingRegistrar() {
    }

    @Override
    public IShoulderSurfingRegistrar registerAdaptiveItemCallback(IAdaptiveItemCallback adaptiveItemCallback) {
        this.checkState();
        AdaptiveItemCallbackWrapper wrapper = new AdaptiveItemCallbackWrapper(this.activePluginContext, adaptiveItemCallback);
        this.adaptiveItemCallbacks.add(wrapper);
        return this;
    }

    @Override
    public IShoulderSurfingRegistrar registerCameraCouplingCallback(ICameraCouplingCallback cameraCouplingCallback) {
        this.checkState();
        CameraCouplingCallbackWrapper wrapper = new CameraCouplingCallbackWrapper(this.activePluginContext, cameraCouplingCallback);
        this.cameraCouplingCallbacks.add(wrapper);
        return this;
    }

    @Override
    public IShoulderSurfingRegistrar registerTargetCameraOffsetCallback(ITargetCameraOffsetCallback targetCameraOffsetCallback) {
        this.checkState();
        TargetCameraOffsetCallbackWrapper wrapper = new TargetCameraOffsetCallbackWrapper(this.activePluginContext, targetCameraOffsetCallback);
        this.targetCameraOffsetCallbacks.add(wrapper);
        return this;
    }

    private void checkState() {
        if (this.isFrozen) {
            throw new IllegalStateException("Unable to register plugins outside plugin loading stage");
        }
        if (this.activePluginContext == null) {
            throw new IllegalStateException("No active plugin context");
        }
    }

    void setPluginContext(PluginContext context) {
        this.activePluginContext = context;
    }

    protected void freeze() {
        this.isFrozen = true;
        this.activePluginContext = null;
    }

    public List<IAdaptiveItemCallback> getAdaptiveItemCallbacks() {
        return Collections.unmodifiableList(this.adaptiveItemCallbacks);
    }

    public List<ICameraCouplingCallback> getCameraCouplingCallbacks() {
        return Collections.unmodifiableList(this.cameraCouplingCallbacks);
    }

    public List<ITargetCameraOffsetCallback> getTargetCameraOffsetCallbacks() {
        return Collections.unmodifiableList(this.targetCameraOffsetCallbacks);
    }

    private static <T> T wrapCallback(PluginContext context, Callable<T> callback) {
        try {
            return callback.call();
        }
        catch (Throwable t) {
            throw ShoulderSurfingRegistrar.createExceptionWithContext(context, t);
        }
    }

    private static RuntimeException createExceptionWithContext(PluginContext context, Throwable t) {
        return new RuntimeException("Shoulder Surfing Reloaded encountered an unexpected error while trying to execute a callback for the plugin provided by " + context.formattedModName() + ". Please report this crash to " + context.formattedModName() + ".", t);
    }

    public static ShoulderSurfingRegistrar getInstance() {
        return INSTANCE;
    }

    private record AdaptiveItemCallbackWrapper(PluginContext context, IAdaptiveItemCallback delegate) implements IAdaptiveItemCallback
    {
        @Override
        public boolean isHoldingAdaptiveItem(Minecraft minecraft, LivingEntity entity) {
            return ShoulderSurfingRegistrar.wrapCallback(this.context, () -> this.delegate.isHoldingAdaptiveItem(minecraft, entity));
        }
    }

    private record CameraCouplingCallbackWrapper(PluginContext context, ICameraCouplingCallback delegate) implements ICameraCouplingCallback
    {
        @Override
        public boolean isForcingCameraCoupling(Minecraft minecraft) {
            return ShoulderSurfingRegistrar.wrapCallback(this.context, () -> this.delegate.isForcingCameraCoupling(minecraft));
        }
    }

    private record TargetCameraOffsetCallbackWrapper(PluginContext context, ITargetCameraOffsetCallback delegate) implements ITargetCameraOffsetCallback
    {
        @Override
        public Vec3 pre(IShoulderSurfing instance, Vec3 targetOffset, Vec3 defaultOffset) {
            return ShoulderSurfingRegistrar.wrapCallback(this.context, () -> this.delegate.pre(instance, targetOffset, defaultOffset));
        }

        @Override
        public Vec3 post(IShoulderSurfing instance, Vec3 targetOffset, Vec3 defaultOffset) {
            return ShoulderSurfingRegistrar.wrapCallback(this.context, () -> this.delegate.post(instance, targetOffset, defaultOffset));
        }
    }
}

