/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.selectable_painting.elements.items.selectable_painting;

import de.geheimagentnr1.selectable_painting.elements.items.ModItemsRegisterFactory;
import de.geheimagentnr1.selectable_painting.elements.items.selectable_painting.SelectablePaintingItemStackHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.decoration.PaintingVariants;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SelectablePaintingEntity
extends HangingEntity {
    @NotNull
    private static final EntityDataAccessor<Holder<PaintingVariant>> DATA_MOTIVE_ID = SynchedEntityData.m_135353_(Painting.class, (EntityDataSerializer)EntityDataSerializers.f_238116_);
    @NotNull
    private static final ResourceKey<PaintingVariant> DEFAULT_VARIANT = PaintingVariants.f_218914_;
    private int size_index;
    private int motive_index;
    private boolean randomMotive;

    public SelectablePaintingEntity(@NotNull Level _level) {
        this(ModItemsRegisterFactory.SELECTABLE_PAINTING_ENTITY, _level);
    }

    private SelectablePaintingEntity(@NotNull EntityType<SelectablePaintingEntity> entityType, @NotNull Level _level) {
        super(entityType, _level);
        this.size_index = 0;
        this.motive_index = 0;
    }

    public SelectablePaintingEntity(@NotNull Level _level, @NotNull BlockPos _pos, @NotNull Direction _direction, @NotNull Holder<PaintingVariant> paintingType, int _size_index, int _painting_index, boolean _random) {
        super(ModItemsRegisterFactory.SELECTABLE_PAINTING_ENTITY, _level, _pos);
        this.setMotiveHolder(paintingType);
        this.init(_direction);
        this.size_index = _size_index;
        this.motive_index = _painting_index;
        this.randomMotive = _random;
    }

    private void init(@NotNull Direction _direction) {
        this.m_6022_(_direction);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_MOTIVE_ID, SelectablePaintingEntity.getDefaultMotive());
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> data) {
        if (data.equals(DATA_MOTIVE_ID)) {
            this.m_7087_();
        }
    }

    @NotNull
    private static Holder<PaintingVariant> getDefaultMotive() {
        return BuiltInRegistries.f_257051_.m_246971_(DEFAULT_VARIANT);
    }

    private void setMotiveHolder(@NotNull Holder<PaintingVariant> holder) {
        this.f_19804_.m_135381_(DATA_MOTIVE_ID, holder);
    }

    @NotNull
    private Holder<PaintingVariant> getMotiveHolder() {
        return (Holder)this.f_19804_.m_135370_(DATA_MOTIVE_ID);
    }

    @NotNull
    public ItemStack getPickedResult(@NotNull HitResult target) {
        return this.getItemStackOfEntity();
    }

    @NotNull
    private ItemStack getItemStackOfEntity() {
        return SelectablePaintingItemStackHelper.writeDataToStack(new ItemStack((ItemLike)ModItemsRegisterFactory.SELECTABLE_PAINTING), this.size_index, this.motive_index, this.randomMotive);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        compound.m_128359_("Motive", this.getMotiveHolder().m_203543_().orElse(DEFAULT_VARIANT).m_135782_().toString());
        compound.m_128344_("Facing", (byte)this.f_31699_.m_122416_());
        compound.m_128405_("size_index", this.size_index);
        compound.m_128405_("painting_index", this.motive_index);
        compound.m_128379_("random", this.randomMotive);
        super.m_7380_(compound);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        this.setMotiveHolder((Holder<PaintingVariant>)BuiltInRegistries.f_257051_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256836_, (ResourceLocation)Optional.ofNullable(ResourceLocation.m_135820_((String)compound.m_128461_("Motive"))).orElse(DEFAULT_VARIANT.m_135782_()))).map(paintingVariantReference -> paintingVariantReference).orElseGet(SelectablePaintingEntity::getDefaultMotive));
        this.size_index = compound.m_128451_("size_index");
        this.motive_index = compound.m_128451_("painting_index");
        this.randomMotive = compound.m_128471_("random");
        super.m_7378_(compound);
        this.m_6022_(Direction.m_122407_((int)compound.m_128445_("Facing")));
    }

    public int m_7076_() {
        return ((PaintingVariant)this.getMotiveHolder().m_203334_()).m_218908_();
    }

    public int m_7068_() {
        return ((PaintingVariant)this.getMotiveHolder().m_203334_()).m_218909_();
    }

    public void m_5553_(@Nullable Entity brakingEntity) {
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
            if (brakingEntity instanceof Player && ((Player)brakingEntity).m_7500_()) {
                return;
            }
            this.m_19983_(this.getItemStackOfEntity());
        }
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12176_, 1.0f, 1.0f);
    }

    public void m_7678_(double x, double y, double z, float yaw, float pitch) {
        this.m_6034_(x, y, z);
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.m_6034_(x, y, z);
    }

    @NotNull
    public Vec3 m_213870_() {
        return Vec3.m_82528_((Vec3i)this.f_31698_);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.f_31699_.m_122411_(), this.m_31748_());
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.m_6022_(Direction.m_122376_((int)packet.m_131509_()));
    }

    @NotNull
    public static EntityType<SelectablePaintingEntity> buildEntityType() {
        return EntityType.Builder.m_20704_(SelectablePaintingEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20712_("selectable_painting");
    }

    @NotNull
    public PaintingVariant getMotive() {
        return (PaintingVariant)this.getMotiveHolder().m_203334_();
    }

    public int getSizeIndex() {
        return this.size_index;
    }

    public int getPaintingIndex() {
        return this.motive_index;
    }

    public boolean isRandomMotive() {
        return this.randomMotive;
    }
}

