/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.selectable_painting.elements.items.selectable_painting;

import de.geheimagentnr1.selectable_painting.elements.items.selectable_painting.SelectablePaintingItemStackHelper;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PaintingSelectionHelper {
    private static String[] painting_sizes;
    private static List<List<Holder<PaintingVariant>>> motives;

    static void init() {
        long current_painting_count = BuiltInRegistries.f_257051_.m_13562_();
        if ((long)PaintingSelectionHelper.motivesCount() != current_painting_count) {
            TreeSet sizes = new TreeSet();
            TreeMap motivesMap = new TreeMap();
            BuiltInRegistries.f_257051_.m_214010_().forEach(paintingVariantResourceKey -> BuiltInRegistries.f_257051_.m_203636_(paintingVariantResourceKey).ifPresent(motiveHolder -> {
                int heightSize;
                PaintingVariant motive = (PaintingVariant)motiveHolder.m_203334_();
                int widthSize = motive.m_218908_() / 16;
                String paintingSize = widthSize + "x" + (heightSize = motive.m_218909_() / 16);
                if (sizes.add(paintingSize)) {
                    motivesMap.put(paintingSize, new TreeSet<Holder>(Comparator.comparing(motiveComparing -> ((ResourceKey)motiveComparing.m_203543_().orElseThrow()).m_135782_().toString())));
                }
                ((TreeSet)motivesMap.get(paintingSize)).add(motiveHolder);
            }));
            painting_sizes = sizes.toArray(new String[0]);
            motives = motivesMap.values().stream().map(holders -> holders.stream().toList()).toList();
            if (painting_sizes.length != motives.size() || (long)PaintingSelectionHelper.motivesCount() != current_painting_count) {
                throw new IllegalStateException("Invalid build of motives list, please create a bug report on GitHub");
            }
        }
    }

    private static int motivesCount() {
        return motives == null ? 0 : motives.stream().mapToInt(List::size).sum();
    }

    public static void previousSize(@NotNull ItemStack stack) {
        PaintingSelectionHelper.init();
        int size_index = SelectablePaintingItemStackHelper.getSizeIndex(stack) - 1;
        size_index = size_index < 0 ? painting_sizes.length - 1 : size_index;
        SelectablePaintingItemStackHelper.setSizeIndex(stack, size_index);
        SelectablePaintingItemStackHelper.setPaintingIndex(stack, 0);
    }

    public static void nextSize(@NotNull ItemStack stack) {
        PaintingSelectionHelper.init();
        int size_index = SelectablePaintingItemStackHelper.getSizeIndex(stack) + 1;
        size_index = size_index >= painting_sizes.length ? 0 : size_index;
        SelectablePaintingItemStackHelper.setSizeIndex(stack, size_index);
        SelectablePaintingItemStackHelper.setPaintingIndex(stack, 0);
    }

    public static void previousPainting(@NotNull ItemStack stack) {
        PaintingSelectionHelper.init();
        int size_index = SelectablePaintingItemStackHelper.getSizeIndex(stack);
        int painting_index = SelectablePaintingItemStackHelper.getPaintingIndex(stack) - 1;
        painting_index = painting_index < 0 ? motives.get(size_index).size() - 1 : painting_index;
        SelectablePaintingItemStackHelper.setPaintingIndex(stack, painting_index);
    }

    public static void nextPainting(@NotNull ItemStack stack) {
        PaintingSelectionHelper.init();
        int size_index = SelectablePaintingItemStackHelper.getSizeIndex(stack);
        int painting_index = SelectablePaintingItemStackHelper.getPaintingIndex(stack) + 1;
        painting_index = painting_index >= motives.get(size_index).size() ? 0 : painting_index;
        SelectablePaintingItemStackHelper.setPaintingIndex(stack, painting_index);
    }

    public static String getSizeName(@NotNull ItemStack stack) {
        PaintingSelectionHelper.init();
        return painting_sizes[SelectablePaintingItemStackHelper.getSizeIndex(stack)];
    }

    public static Component getPaintingName(@NotNull ItemStack stack) {
        PaintingSelectionHelper.init();
        return PaintingSelectionHelper.getPaintingName(SelectablePaintingItemStackHelper.getSizeIndex(stack), SelectablePaintingItemStackHelper.getPaintingIndex(stack));
    }

    @NotNull
    private static Component getPaintingName(int size_index, int painting_index) {
        PaintingSelectionHelper.init();
        return Component.m_237115_((String)Util.m_137492_((String)"painting", (ResourceLocation)BuiltInRegistries.f_257051_.m_7981_((Object)((PaintingVariant)motives.get(size_index >= motives.size() ? 0 : size_index).get(painting_index >= motives.get(size_index).size() ? 0 : painting_index).m_203334_()))));
    }

    @NotNull
    public static PaintingVariant getCurrentMotive(@NotNull ItemStack stack) {
        PaintingSelectionHelper.init();
        int size_index = SelectablePaintingItemStackHelper.getSizeIndex(stack);
        int painting_index = SelectablePaintingItemStackHelper.getPaintingIndex(stack);
        return (PaintingVariant)motives.get(size_index >= motives.size() ? 0 : size_index).get(painting_index >= motives.get(size_index).size() ? 0 : painting_index).m_203334_();
    }

    @NotNull
    static Holder<PaintingVariant> getMotive(@NotNull ItemStack stack, @NotNull Level level) {
        PaintingSelectionHelper.init();
        int size_index = SelectablePaintingItemStackHelper.getSizeIndex(stack);
        int painting_index = SelectablePaintingItemStackHelper.getRandom(stack) ? level.m_213780_().m_188503_(motives.get(size_index).size()) : SelectablePaintingItemStackHelper.getPaintingIndex(stack);
        return motives.get(size_index >= motives.size() ? 0 : size_index).get(painting_index >= motives.get(size_index).size() ? 0 : painting_index);
    }
}

