/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader;

import java.nio.file.Path;
import net.darkhax.openloader.Constants;
import net.darkhax.openloader.config.ConfigSchema;
import net.darkhax.openloader.packs.OpenLoaderRepositorySource;
import net.darkhax.openloader.packs.RepoType;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="openloader")
public class OpenLoaderForge {
    public static ConfigSchema config;
    public static Path configDir;

    public OpenLoaderForge() {
        configDir = FMLPaths.CONFIGDIR.get().resolve("openloader");
        config = ConfigSchema.load(configDir);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::injectPackRepositories);
    }

    private void injectPackRepositories(AddPackFindersEvent event) {
        switch (event.getPackType()) {
            case CLIENT_RESOURCES: {
                event.addRepositorySource((RepositorySource)new OpenLoaderRepositorySource(RepoType.RESOURCES, config, OpenLoaderForge.config.resourcePacks, configDir));
                break;
            }
            case SERVER_DATA: {
                event.addRepositorySource((RepositorySource)new OpenLoaderRepositorySource(RepoType.DATA, config, OpenLoaderForge.config.dataPacks, configDir));
                break;
            }
            default: {
                Constants.LOG.warn("Encountered unknown pack type {}. Nothing will be loaded for this type.", (Object)event.getPackType().name());
            }
        }
    }
}

