/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.network;

import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.network.IClientPacketChannelHandler;
import fi.dy.masa.malilib.network.IPluginChannelHandler;
import fi.dy.masa.malilib.network.PacketSplitter;
import fi.dy.masa.malilib.util.PacketUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;

public class ClientPacketChannelHandler
implements IClientPacketChannelHandler {
    public static final ResourceLocation REGISTER = new ResourceLocation("minecraft:register");
    public static final ResourceLocation UNREGISTER = new ResourceLocation("minecraft:unregister");
    private static final ClientPacketChannelHandler INSTANCE = new ClientPacketChannelHandler();
    private final ArrayListMultimap<ResourceLocation, IPluginChannelHandler> handlers = ArrayListMultimap.create();

    public static IClientPacketChannelHandler getInstance() {
        return INSTANCE;
    }

    private ClientPacketChannelHandler() {
    }

    @Override
    public void registerClientChannelHandler(IPluginChannelHandler handler) {
        HashSet<ResourceLocation> toRegister = new HashSet<ResourceLocation>();
        for (ResourceLocation channel : handler.getChannels()) {
            if (this.handlers.containsEntry((Object)channel, (Object)handler)) continue;
            this.handlers.put((Object)channel, (Object)handler);
            if (!handler.registerToServer()) continue;
            toRegister.add(channel);
        }
        if (!toRegister.isEmpty()) {
            this.sendRegisterPacket(REGISTER, toRegister);
        }
    }

    @Override
    public void unregisterClientChannelHandler(IPluginChannelHandler handler) {
        HashSet<ResourceLocation> toUnRegister = new HashSet<ResourceLocation>();
        for (ResourceLocation channel : handler.getChannels()) {
            if (!this.handlers.remove((Object)channel, (Object)handler) || !handler.registerToServer()) continue;
            toUnRegister.add(channel);
        }
        if (!toUnRegister.isEmpty()) {
            this.sendRegisterPacket(UNREGISTER, toUnRegister);
        }
    }

    public boolean processPacketFromServer(ClientboundCustomPayloadPacket packet, ClientPacketListener netHandler) {
        ResourceLocation channel = packet.m_132042_();
        List handlers = this.handlers.get((Object)channel);
        if (!handlers.isEmpty()) {
            for (IPluginChannelHandler handler : handlers) {
                FriendlyByteBuf buf = handler.usePacketSplitter() ? PacketSplitter.receive((ClientGamePacketListener)netHandler, packet) : PacketUtils.retainedSlice((ByteBuf)packet.m_132045_());
                if (buf == null) continue;
                handler.onPacketReceived(buf);
            }
            return true;
        }
        return false;
    }

    private void sendRegisterPacket(ResourceLocation type, Collection<ResourceLocation> channels) {
        String joinedChannels = channels.stream().map(ResourceLocation::toString).collect(Collectors.joining("\u0000"));
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])joinedChannels.getBytes(Charsets.UTF_8));
        ServerboundCustomPayloadPacket packet = new ServerboundCustomPayloadPacket(type, new FriendlyByteBuf(payload));
        ClientPacketListener netHandler = Minecraft.m_91087_().m_91403_();
        if (netHandler != null) {
            netHandler.m_104955_((Packet)packet);
        } else {
            MaLiLib.logger.warn("Failed to send register channel packet - network handler was null");
        }
    }
}

