/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin;

import io.github.reserveword.imblocker.common.IMManager;
import io.github.reserveword.imblocker.common.MinecraftClientAccessor;
import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.MinecraftFocusableWidget;
import io.github.reserveword.imblocker.common.gui.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.TextFieldWidget;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(targets={"me.shedaniel.rei.impl.client.gui.widget.basewidgets.TextFieldWidget", "me.shedaniel.rei.gui.widget.TextFieldWidget"}, remap=false)
public abstract class ReiTextFieldMixin
implements MinecraftFocusableWidget {
    @Shadow
    protected boolean editable;
    @Shadow
    private Rectangle bounds;
    @Shadow
    protected TextFieldWidget.TextFormatter formatter;
    @Shadow
    private boolean hasBorder;
    @Shadow
    protected int firstCharacterIndex;
    @Shadow
    protected int cursorPos;
    @Shadow
    private String text;

    @Override
    public boolean isWidgetEditable() {
        return this.editable;
    }

    @Inject(method={"setFocused", "method_25365", "m_93692_"}, at={@At(value="TAIL")})
    public void focusChanged(boolean isFocused, CallbackInfo ci) {
        this.onMinecraftWidgetFocusChanged(isFocused);
    }

    @Inject(method={"setText"}, at={@At(value="INVOKE", target="Lme/shedaniel/rei/impl/client/gui/widget/basewidgets/TextFieldWidget;onChanged(Ljava/lang/String;)V")})
    public void moveCursorBeforeNotifyChanged(String text, CallbackInfo ci) {
        this.moveCursorToEnd();
    }

    @Inject(method={"onChanged"}, at={@At(value="TAIL")})
    public void onTextChanged(String newText, CallbackInfo ci) {
        IMManager.updateCompositionWindowPos();
    }

    @Inject(method={"moveCursorTo"}, at={@At(value="TAIL")})
    public void onMoveCursor(int cursor, CallbackInfo ci) {
        IMManager.updateCompositionWindowPos();
    }

    @Shadow
    public abstract void moveCursorToEnd();

    @Overwrite(aliases={"setEditable"})
    public void setIsEditable(boolean editable) {
        if (this.editable != editable) {
            this.editable = editable;
            if (this.isTrulyFocused()) {
                this.updateIMState();
            }
        }
    }

    @Override
    public io.github.reserveword.imblocker.common.gui.Rectangle getBoundsAbs() {
        return new io.github.reserveword.imblocker.common.gui.Rectangle(FocusContainer.getMCGuiScaleFactor(), this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    @Override
    public Point getCaretPos() {
        String clippedText = this.text.substring(this.firstCharacterIndex, this.cursorPos);
        int caretX = (this.hasBorder ? 4 : 0) + MinecraftClientAccessor.instance.getStringWidth(clippedText);
        return new Point(FocusContainer.getMCGuiScaleFactor(), caretX, (this.bounds.height - 8) / 2);
    }
}

