/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin;

import com.mojang.blaze3d.platform.Window;
import io.github.reserveword.imblocker.common.Config;
import io.github.reserveword.imblocker.common.IMManager;
import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import io.github.reserveword.imblocker.common.gui.GenericWhitelistScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Shadow
    private Window f_90990_;

    @Inject(method={"setWindowActive"}, at={@At(value="HEAD")})
    public void onWindowFocusChanged(boolean isFocused, CallbackInfo ci) {
        FocusManager.setWindowFocused(isFocused);
    }

    @Inject(method={"resizeDisplay"}, at={@At(value="TAIL")})
    public void onResolutionChanged(CallbackInfo ci) {
        FocusContainer.MINECRAFT.setGuiScaleFactor(this.f_90990_.m_85449_());
        IMManager.updateCompositionWindowPos();
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")})
    public void onScreenChanged(Screen screen, CallbackInfo ci) {
        if (this.isScreenInWhiteList(screen)) {
            FocusContainer.MINECRAFT.requestFocus(GenericWhitelistScreen.getInstance());
        } else {
            FocusContainer.MINECRAFT.cancelFocus();
        }
    }

    private boolean isScreenInWhiteList(Screen screen) {
        return screen != null && Config.INSTANCE.inScreenWhitelist(screen.getClass());
    }
}

