/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin;

import dev.ftb.mods.ftblibrary.ui.TextBox;
import io.github.reserveword.imblocker.common.IMManager;
import io.github.reserveword.imblocker.common.MinecraftClientAccessor;
import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.Point;
import io.github.reserveword.imblocker.mixin.FtbWidgetMixin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TextBox.class}, remap=false)
public abstract class FtbTextFieldMixin
extends FtbWidgetMixin {
    @Shadow
    private String text;
    @Shadow
    private int displayPos;
    @Shadow
    private int cursorPos;

    @Override
    public boolean isWidgetEditable() {
        return true;
    }

    @Inject(method={"setFocused"}, at={@At(value="TAIL")})
    public void focusChanged(boolean isFocused, CallbackInfo ci) {
        this.onMinecraftWidgetFocusChanged(isFocused);
    }

    @Inject(method={"scrollTo"}, at={@At(value="TAIL")})
    public void onCursorPosChanged(int pos, CallbackInfo ci) {
        IMManager.updateCompositionWindowPos();
    }

    @Override
    public Point getCaretPos() {
        int caretX = 4;
        try {
            caretX += MinecraftClientAccessor.instance.getStringWidth(this.text.substring(this.displayPos, this.cursorPos));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Point(FocusContainer.getMCGuiScaleFactor(), caretX, (this.height - 8) / 2);
    }
}

