/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.common.gui;

import io.github.reserveword.imblocker.common.IMManager;
import io.github.reserveword.imblocker.common.MinecraftClientAccessor;
import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import io.github.reserveword.imblocker.common.gui.Point;
import io.github.reserveword.imblocker.common.gui.Rectangle;

public interface FocusableWidget {
    public FocusContainer getFocusContainer();

    default public void deliverFocus() {
        FocusManager.setFocusOwner(this);
        this.updateIMState();
    }

    default public void lostFocus() {
        FocusManager.setFocusOwner(null);
    }

    default public boolean isTrulyFocused() {
        return FocusManager.getFocusOwner() == this;
    }

    default public void updateIMState() {
        IMManager.setState(this.getPreferredState());
        if (this.getPreferredState()) {
            IMManager.setEnglishState(this.getPreferredEnglishState());
            IMManager.updateCompositionWindowPos();
        }
    }

    default public void updateEnglishState() {
        if (this.getPreferredState()) {
            IMManager.setEnglishState(this.getPreferredEnglishState());
        }
    }

    public boolean isWidgetEditable();

    default public boolean getPreferredState() {
        return this.isWidgetEditable();
    }

    default public boolean getPreferredEnglishState() {
        return false;
    }

    default public Rectangle getBoundsAbs() {
        Rectangle bounds = MinecraftClientAccessor.instance.getWindowBounds();
        return new Rectangle(bounds.width() / 3, bounds.height() / 2, 0, 0);
    }

    default public Point getCaretPos() {
        return Point.TOP_LEFT;
    }
}

