/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.common.gui;

import io.github.reserveword.imblocker.common.IMManager;
import io.github.reserveword.imblocker.common.gui.FocusableWidget;

public enum FocusContainer {
    MINECRAFT(true),
    IMGUI(false);

    private double guiScaleFactor = 1.0;
    private boolean isFocused;
    private FocusableWidget focusedWidget;

    private FocusContainer(boolean defaultFocusState) {
        this.isFocused = defaultFocusState;
    }

    public FocusableWidget getFocusedWidget() {
        return this.focusedWidget;
    }

    public void requestFocus(FocusableWidget toFocus) {
        if (this.focusedWidget != toFocus) {
            if (this.isFocused) {
                if (this.focusedWidget != null) {
                    this.focusedWidget.lostFocus();
                }
                toFocus.deliverFocus();
            }
            this.focusedWidget = toFocus;
        }
    }

    public void removeFocus(FocusableWidget toRemove) {
        if (this.focusedWidget == toRemove) {
            toRemove.lostFocus();
            this.focusedWidget = null;
            if (this.isFocused) {
                IMManager.setState(false);
            }
        }
    }

    public void cancelFocus() {
        if (this.focusedWidget != null) {
            this.removeFocus(this.focusedWidget);
        }
    }

    public void deliverFocus() {
        this.isFocused = true;
        if (this.focusedWidget != null) {
            this.focusedWidget.deliverFocus();
        } else {
            IMManager.setState(false);
        }
    }

    public void lostFocus() {
        this.isFocused = false;
        if (this.focusedWidget != null) {
            this.focusedWidget.lostFocus();
        }
    }

    public void setGuiScaleFactor(double factor) {
        this.guiScaleFactor = factor;
    }

    public static double getMCGuiScaleFactor() {
        return FocusContainer.MINECRAFT.guiScaleFactor;
    }
}

