/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.common;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import io.github.reserveword.imblocker.common.IMManager;
import io.github.reserveword.imblocker.common.MinecraftClientAccessor;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import io.github.reserveword.imblocker.common.gui.FocusableWidget;
import io.github.reserveword.imblocker.common.gui.Point;
import io.github.reserveword.imblocker.common.gui.Rectangle;
import io.github.reserveword.imblocker.common.jnastructs.CANDIDATEFORM;
import io.github.reserveword.imblocker.common.jnastructs.COMPOSITIONFORM;

final class IMManagerWindows
implements IMManager.PlatformIMManager {
    public static long lastIMStateOnTimestamp = System.currentTimeMillis();
    private final SetConversionStateThread setConversionStateThread = new SetConversionStateThread();
    private boolean preferredEnglishState = false;
    private static final User32 u;

    private static native WinNT.HANDLE ImmGetContext(WinDef.HWND var0);

    private static native WinNT.HANDLE ImmAssociateContext(WinDef.HWND var0, WinNT.HANDLE var1);

    private static native boolean ImmReleaseContext(WinDef.HWND var0, WinNT.HANDLE var1);

    private static native WinNT.HANDLE ImmCreateContext();

    private static native boolean ImmDestroyContext(WinNT.HANDLE var0);

    private static native boolean ImmSetConversionStatus(WinNT.HANDLE var0, int var1, int var2);

    private static native boolean ImmGetCandidateWindow(WinNT.HANDLE var0, int var1, CANDIDATEFORM var2);

    private static native boolean ImmSetCandidateWindow(WinNT.HANDLE var0, CANDIDATEFORM var1);

    private static native boolean ImmGetCompositionWindow(WinNT.HANDLE var0, COMPOSITIONFORM var1);

    private static native boolean ImmSetCompositionWindow(WinNT.HANDLE var0, COMPOSITIONFORM var1);

    public IMManagerWindows() {
        this.setConversionStateThread.start();
    }

    @Override
    public void setState(boolean on) {
        WinDef.HWND hwnd = u.GetActiveWindow();
        WinNT.HANDLE himc = IMManagerWindows.ImmGetContext(hwnd);
        if (himc != null != on) {
            if (on) {
                himc = IMManagerWindows.ImmCreateContext();
                IMManagerWindows.ImmAssociateContext(hwnd, himc);
                lastIMStateOnTimestamp = System.currentTimeMillis();
            } else {
                himc = IMManagerWindows.ImmAssociateContext(hwnd, null);
                IMManagerWindows.ImmDestroyContext(himc);
            }
            IMManagerWindows.ImmReleaseContext(hwnd, himc);
        }
    }

    @Override
    public void setEnglishState(boolean englishState) {
        this.preferredEnglishState = englishState;
        if (!this.setConversionStateThread.isScheduled) {
            if (this.getConversionStatusCooldown() <= 0L) {
                this.syncEnglishState();
            } else {
                this.setConversionStateThread.awake();
                this.setConversionStateThread.isScheduled = true;
            }
        }
    }

    private void syncEnglishState() {
        WinDef.HWND hwnd = u.GetActiveWindow();
        WinNT.HANDLE himc = IMManagerWindows.ImmGetContext(hwnd);
        if (himc != null) {
            IMManagerWindows.ImmSetConversionStatus(himc, this.preferredEnglishState ? 0 : 1, 0);
        }
        IMManagerWindows.ImmReleaseContext(hwnd, himc);
        this.setConversionStateThread.isScheduled = false;
    }

    private long getConversionStatusCooldown() {
        return 60L - (System.currentTimeMillis() - lastIMStateOnTimestamp);
    }

    public void updateCompositionWindowPos() {
        WinDef.HWND hwnd = u.GetActiveWindow();
        WinNT.HANDLE himc = IMManagerWindows.ImmGetContext(hwnd);
        if (himc != null) {
            this.updateCompositionWindowPos(himc);
        }
        IMManagerWindows.ImmReleaseContext(hwnd, himc);
    }

    private void updateCompositionWindowPos(WinNT.HANDLE himc) {
        FocusableWidget focusedWidget = FocusManager.getFocusOwner();
        if (focusedWidget != null) {
            Point compositionWindowPos = this.calculateProperCompositionWindowPos(focusedWidget.getBoundsAbs(), focusedWidget.getCaretPos());
            COMPOSITIONFORM cfr = new COMPOSITIONFORM();
            IMManagerWindows.ImmGetCompositionWindow(himc, cfr);
            cfr.dwStyle = 2;
            cfr.ptCurrentPos.x = compositionWindowPos.x();
            cfr.ptCurrentPos.y = compositionWindowPos.y();
            IMManagerWindows.ImmSetCompositionWindow(himc, cfr);
        }
    }

    private Point calculateProperCompositionWindowPos(Rectangle inputWidgetBounds, Point caretPos) {
        return new Point(inputWidgetBounds.x() + caretPos.x(), inputWidgetBounds.y() + caretPos.y());
    }

    static {
        Native.register((String)"imm32");
        u = User32.INSTANCE;
    }

    private class SetConversionStateThread
    extends Thread {
        private boolean isScheduled = false;

        private SetConversionStateThread() {
        }

        @Override
        public synchronized void run() {
            block0: while (true) {
                this.await(0L);
                while (true) {
                    long cooldown;
                    if ((cooldown = IMManagerWindows.this.getConversionStatusCooldown()) <= 0L) {
                        MinecraftClientAccessor.instance.execute(() -> IMManagerWindows.this.syncEnglishState());
                        continue block0;
                    }
                    this.await(cooldown);
                }
                break;
            }
        }

        private synchronized void awake() {
            this.notifyAll();
        }

        private void await(long milis) {
            try {
                this.wait(milis);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

