/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker;

import io.github.reserveword.imblocker.common.ChatCommandInputType;
import io.github.reserveword.imblocker.common.Common;
import io.github.reserveword.imblocker.common.Config;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.HangingSignEditScreen;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class ForgeConfig
extends Config {
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    private static final Set<Class<?>> recoveredScreens;
    private static Set<Class<?>> screenWhitelist;

    private ForgeConfig() {
    }

    public static void reload() {
        screenWhitelist = ForgeConfig.bakeList(ForgeConfig.CLIENT.screenWhitelist, "screenWhitelist");
    }

    private static Set<Class<?>> bakeList(ForgeConfigSpec.ConfigValue<List<? extends String>> cfg, String name) {
        HashSet clsSet = new HashSet();
        for (String s : (List)cfg.get()) {
            try {
                if (s.contains(":")) {
                    String[] ss = s.split(":");
                    s = ss[ss.length - 1];
                }
                clsSet.add(Class.forName(s));
            }
            catch (ClassNotFoundException e) {
                Common.LOGGER.warn("Class {} not found, ignored.", (Object)s);
            }
            catch (Throwable e) {
                Common.LOGGER.warn((Object)e);
            }
        }
        Common.LOGGER.info("imblocker bakelist {} result {}", (Object)name, clsSet);
        return clsSet;
    }

    @Override
    public boolean inScreenWhitelist(Class<?> cls) {
        return screenWhitelist != null && screenWhitelist.contains(cls);
    }

    @Override
    public ChatCommandInputType getChatCommandInputType() {
        return (ChatCommandInputType)((Object)ForgeConfig.CLIENT.chatCommandInputType.get());
    }

    public String getClassName(Class<?> cls) {
        CodeSource source = cls.getProtectionDomain().getCodeSource();
        if (source == null || cls.getName().startsWith("net.minecraft.")) {
            return "minecraft:" + cls.getName();
        }
        URL loc = source.getLocation();
        AtomicReference<String> name = new AtomicReference<String>("UNKNOWN_SCREEN");
        ModList.get().forEachModContainer((modid, mod) -> {
            try {
                if (!"minecraft".equals(modid) && !"imblocker".equals(modid) && loc == mod.getMod().getClass().getProtectionDomain().getCodeSource().getLocation()) {
                    name.set(modid + ":" + cls.getName());
                }
            }
            catch (NullPointerException npe) {
                Common.LOGGER.error("something is null when grabbing mod jar:");
                Object modobj = mod.getMod();
                Class<?> modcls = modobj != null ? modobj.getClass() : null;
                ProtectionDomain pd = modcls != null ? modcls.getProtectionDomain() : null;
                CodeSource cs = pd != null ? pd.getCodeSource() : null;
                Common.LOGGER.warn("modid {}, mod {}, class {}, domain {}, source {}", modid, modobj, modcls, (Object)pd, (Object)cs);
                Common.LOGGER.error("enableScreenRecovering disabled.");
                ForgeConfig.CLIENT.enableScreenRecovering.set((Object)false);
            }
        });
        return name.get();
    }

    static {
        recoveredScreens = new HashSet();
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        Config.INSTANCE = new ForgeConfig();
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> screenWhitelist;
        private final ForgeConfigSpec.ConfigValue<Boolean> enableScreenRecovering;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> recoveredScreens;
        private final ForgeConfigSpec.EnumValue<ChatCommandInputType> chatCommandInputType;

        Client(ForgeConfigSpec.Builder builder) {
            this.screenWhitelist = builder.comment("Matched screens would enable your IME").translation("key.imblocker.screenWhitelist").defineList("screenWhitelist", Arrays.asList(BookEditScreen.class.getName(), SignEditScreen.class.getName(), HangingSignEditScreen.class.getName(), "journeymap.client.ui.waypoint.WaypointEditor", "com.ldtteam.blockout.BOScreen"), Config.checkClassForName);
            this.enableScreenRecovering = builder.comment("Do we output recoveredScreens? because it may cause lag").translation("key.imblocker.enableScreenRecovering").define("enableScreenRecovering", false);
            this.recoveredScreens = builder.comment(new String[]{"Here lists all Screens that is not in whitelist nor blacklist, ", "so you may easily add those to whitelist/blacklist."}).translation("key.imblocker.recoveredScreens").defineList("recoveredScreens", Collections.emptyList(), s -> true);
            this.chatCommandInputType = builder.comment("If your input method can't auto-switch to English state when using command syntax in chat field, set this option to DISABLE_IM may help, but note that you can only type English when typing command in this mode.").translation("key.imblocker.chatCommandInputType").defineEnum("chatCommandInputType", (Enum)ChatCommandInputType.IM_ENG_STATE);
        }
    }
}

