/*
 * Decompiled with CFR 0.152.
 */
package i18nupdatemod.util;

import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Log {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Writer fileWriter;

    public static void setMinecraftLogFile(Path minecraftDir) {
        Log.setLogFile(minecraftDir.resolve("logs/I18nUpdateMod.log"));
    }

    public static void setLogFile(Path path) {
        try {
            fileWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e) {
            System.err.printf("Error setting log file: %s%n\r\n", e);
        }
    }

    private static void log(Level level, String message) {
        String out = String.format("[%s] [%s]: %s\r\n", DATE_FORMAT.format(new Date()), level.name(), message);
        if (fileWriter != null) {
            try {
                fileWriter.write(out);
                fileWriter.flush();
            }
            catch (Exception e) {
                System.err.printf("Error writing log: %s%n\r\n", e);
            }
        }
        switch (level.out.ordinal()) {
            case 1: {
                System.out.print(out);
                return;
            }
            case 2: {
                System.err.print(out);
            }
        }
    }

    public static void debug(String message) {
        Log.log(Level.DEBUG, message);
    }

    public static void debug(String format, Object ... args) {
        Log.debug(String.format(format, args));
    }

    public static void info(String message) {
        Log.log(Level.INFO, message);
    }

    public static void info(String format, Object ... args) {
        Log.info(String.format(format, args));
    }

    public static void warning(String message) {
        Log.log(Level.WARNING, message);
    }

    public static void warning(String format, Object ... args) {
        Log.warning(String.format(format, args));
    }

    static enum Level {
        DEBUG(Out.FILE_ONLY),
        INFO(Out.STD_OUT),
        WARNING(Out.STD_ERR);

        final Out out;

        private Level(Out out) {
            this.out = out;
        }
    }

    static enum Out {
        FILE_ONLY,
        STD_OUT,
        STD_ERR;

    }
}

