/*
 * Decompiled with CFR 0.152.
 */
package i18nupdatemod.launchwrapper;

import i18nupdatemod.I18nUpdateMod;
import i18nupdatemod.util.Log;
import i18nupdatemod.util.Reflection;
import java.io.File;
import java.util.List;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class LaunchWrapperTweaker
implements ITweaker {
    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        Log.setMinecraftLogFile(gameDir.toPath());
        String mcVersion = this.getMcVersion();
        if (mcVersion == null) {
            Log.warning("Failed to get minecraft version.");
            return;
        }
        I18nUpdateMod.init(gameDir.toPath(), mcVersion, "Forge");
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
    }

    public String getLaunchTarget() {
        return "";
    }

    public String[] getLaunchArguments() {
        return new String[0];
    }

    private String getMcVersion() {
        try {
            return (String)Reflection.clazz("cpw.mods.fml.relauncher.FMLInjectionData").get("mccversion").get();
        }
        catch (Exception exception) {
            try {
                return (String)Reflection.clazz("net.minecraftforge.fml.relauncher.FMLInjectionData").get("mccversion").get();
            }
            catch (Exception exception2) {
                try {
                    return (String)Reflection.clazz("net.minecraftforge.common.ForgeVersion").get("mcVersion").get();
                }
                catch (Exception exception3) {
                    return null;
                }
            }
        }
    }
}

