/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gamestages;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.darkhax.gamestages.GameStages;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.event.GameStageEvent;
import net.darkhax.gamestages.packet.MessageStages;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public class GameStageHelper {
    private static final Predicate<String> STAGE_PATTERN = Pattern.compile("^[a-z0-9_:]*$").asPredicate();

    public static boolean isValidStageName(String stageName) {
        return STAGE_PATTERN.test(stageName);
    }

    public static Set<String> getKnownStages() {
        return GameStageSaveHandler.getKnownStages();
    }

    public static boolean isStageKnown(String stage) {
        return GameStageSaveHandler.isStageKnown(stage);
    }

    public static boolean hasStage(Player player, String stage) {
        return GameStageHelper.hasStage(player, GameStageHelper.getPlayerData(player), stage);
    }

    public static boolean hasStage(Player player, @Nullable IStageData data, String stage) {
        if (data != null) {
            GameStageEvent.Check event = new GameStageEvent.Check(player, stage, data.hasStage(stage));
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.hasStage();
        }
        return false;
    }

    public static boolean hasAnyOf(Player player, String ... stages) {
        return GameStageHelper.hasAnyOf(player, GameStageHelper.getPlayerData(player), stages);
    }

    public static boolean hasAnyOf(Player player, Collection<String> stages) {
        return GameStageHelper.hasAnyOf(player, GameStageHelper.getPlayerData(player), stages);
    }

    public static boolean hasAnyOf(Player player, @Nullable IStageData data, Collection<String> stages) {
        return stages.stream().anyMatch(stage -> GameStageHelper.hasStage(player, data, stage));
    }

    public static boolean hasAnyOf(Player player, @Nullable IStageData data, String ... stages) {
        return Arrays.stream(stages).anyMatch(stage -> GameStageHelper.hasStage(player, data, stage));
    }

    public static boolean hasAllOf(Player player, String ... stages) {
        return GameStageHelper.hasAllOf(player, GameStageHelper.getPlayerData(player), stages);
    }

    public static boolean hasAllOf(Player player, Collection<String> stages) {
        return GameStageHelper.hasAllOf(player, GameStageHelper.getPlayerData(player), stages);
    }

    public static boolean hasAllOf(Player player, @Nullable IStageData data, Collection<String> stages) {
        return stages.stream().allMatch(stage -> GameStageHelper.hasStage(player, data, stage));
    }

    public static boolean hasAllOf(Player player, @Nullable IStageData data, String ... stages) {
        return Arrays.stream(stages).allMatch(stage -> GameStageHelper.hasStage(player, data, stage));
    }

    public static void addStage(ServerPlayer player, String ... stages) {
        for (String stage : stages) {
            IStageData data;
            if (MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Add((Player)player, stage)) || (data = GameStageHelper.getPlayerData((Player)player)) == null) continue;
            data.addStage(stage);
            GameStageHelper.syncPlayer(player);
            MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Added((Player)player, stage));
        }
    }

    public static void removeStage(ServerPlayer player, String ... stages) {
        for (String stage : stages) {
            IStageData data;
            if (MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Remove((Player)player, stage)) || (data = GameStageHelper.getPlayerData((Player)player)) == null) continue;
            data.removeStage(stage);
            GameStageHelper.syncPlayer(player);
            MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Removed((Player)player, stage));
        }
    }

    public static int clearStages(ServerPlayer player) {
        IStageData stageInfo = GameStageHelper.getPlayerData((Player)player);
        if (stageInfo != null) {
            int stageCount = stageInfo.getStages().size();
            stageInfo.clear();
            GameStageHelper.syncPlayer(player);
            MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Cleared((Player)player, stageInfo));
            return stageCount;
        }
        return 0;
    }

    @Nullable
    public static IStageData getPlayerData(Player player) {
        if (player != null) {
            if (player instanceof ServerPlayer) {
                if (player instanceof FakePlayer) {
                    return GameStageSaveHandler.getFakeData(player.m_7755_().getString());
                }
                return GameStageSaveHandler.getPlayerData(player.m_20148_());
            }
            if (EffectiveSide.get().isClient()) {
                return GameStageSaveHandler.getClientData();
            }
        }
        return null;
    }

    public static void syncPlayer(ServerPlayer player) {
        IStageData info = GameStageHelper.getPlayerData((Player)player);
        if (info != null) {
            GameStages.LOG.debug("Syncing {} stages for {}.", (Object)info.getStages().size(), (Object)player.m_7755_());
            GameStages.NETWORK.syncPlayerStages(player, new MessageStages(info.getStages()));
        }
    }
}

