/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.forgematica.incompatibility;

import java.util.Iterator;
import java.util.Optional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.thinkingstudio.forgematica.Forgematica;

public class ModVersionCheckHelper {
    private static Optional<IModFileInfo> getLoadingModFileInfo(String modId) {
        try {
            return Optional.ofNullable(LoadingModList.get()).map(ml -> ml.getModFileById(modId));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static Optional<IModFileInfo> getModFileInfo(String modId) {
        Optional<IModFileInfo> mod = ModVersionCheckHelper.getLoadingModFileInfo(modId);
        if (!mod.isPresent()) {
            mod = Optional.ofNullable(ModList.get()).map(ml -> ml.getModFileById(modId));
        }
        return mod;
    }

    private static Optional<ArtifactVersion> getModVersion(IModFileInfo modFileInfo) {
        Iterator iterator = modFileInfo.getMods().iterator();
        if (iterator.hasNext()) {
            IModInfo mod = (IModInfo)iterator.next();
            return Optional.of(mod.getVersion());
        }
        return Optional.empty();
    }

    public static boolean doesModVersionSatisfyPredicate(String modId, String versionPredicate) {
        Optional versionOpt = ModVersionCheckHelper.getModFileInfo(modId).filter(modFileInfo -> !modFileInfo.getMods().isEmpty()).flatMap(ModVersionCheckHelper::getModVersion);
        if (!versionOpt.isPresent()) {
            return false;
        }
        ArtifactVersion version = (ArtifactVersion)versionOpt.get();
        try {
            return VersionRange.createFromVersionSpec((String)versionPredicate).containsVersion(version);
        }
        catch (Exception e) {
            Forgematica.LOGGER.error("Failed to parse version or version predicate {} {}: {}", new Object[]{version, versionPredicate, e});
            return false;
        }
    }
}

