/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic;

import fi.dy.masa.malilib.util.NBTUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class SchematicMetadata {
    private String name = "?";
    private String author = "Unknown";
    private String description = "";
    private Vec3i enclosingSize = Vec3i.f_123288_;
    private long timeCreated;
    private long timeModified;
    private int regionCount;
    private int totalVolume;
    private int totalBlocks;
    private int[] thumbnailPixelData;
    private boolean modifiedSinceSaved;

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    public int[] getPreviewImagePixelData() {
        return this.thumbnailPixelData;
    }

    public int getRegionCount() {
        return this.regionCount;
    }

    public int getTotalVolume() {
        return this.totalVolume;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public Vec3i getEnclosingSize() {
        return this.enclosingSize;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public long getTimeModified() {
        return this.timeModified;
    }

    public boolean hasBeenModified() {
        return this.timeCreated != this.timeModified;
    }

    public boolean wasModifiedSinceSaved() {
        return this.modifiedSinceSaved;
    }

    public void setModifiedSinceSaved() {
        this.modifiedSinceSaved = true;
    }

    public void clearModifiedSinceSaved() {
        this.modifiedSinceSaved = false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPreviewImagePixelData(int[] pixelData) {
        this.thumbnailPixelData = pixelData;
    }

    public void setRegionCount(int regionCount) {
        this.regionCount = regionCount;
    }

    public void setTotalVolume(int totalVolume) {
        this.totalVolume = totalVolume;
    }

    public void setTotalBlocks(int totalBlocks) {
        this.totalBlocks = totalBlocks;
    }

    public void setEnclosingSize(Vec3i enclosingSize) {
        this.enclosingSize = enclosingSize;
    }

    public void setTimeCreated(long timeCreated) {
        this.timeCreated = timeCreated;
    }

    public void setTimeModified(long timeModified) {
        this.timeModified = timeModified;
    }

    public void setTimeModifiedToNow() {
        this.timeModified = System.currentTimeMillis();
    }

    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Name", this.name);
        nbt.m_128359_("Author", this.author);
        nbt.m_128359_("Description", this.description);
        nbt.m_128405_("RegionCount", this.regionCount);
        nbt.m_128405_("TotalVolume", this.totalVolume);
        nbt.m_128405_("TotalBlocks", this.totalBlocks);
        nbt.m_128356_("TimeCreated", this.timeCreated);
        nbt.m_128356_("TimeModified", this.timeModified);
        nbt.m_128365_("EnclosingSize", (Tag)NBTUtils.createBlockPosTag((Vec3i)this.enclosingSize));
        if (this.thumbnailPixelData != null) {
            nbt.m_128385_("PreviewImageData", this.thumbnailPixelData);
        }
        return nbt;
    }

    public void readFromNBT(CompoundTag nbt) {
        this.name = nbt.m_128461_("Name");
        this.author = nbt.m_128461_("Author");
        this.description = nbt.m_128461_("Description");
        this.regionCount = nbt.m_128451_("RegionCount");
        this.totalVolume = nbt.m_128451_("TotalVolume");
        this.totalBlocks = nbt.m_128451_("TotalBlocks");
        this.timeCreated = nbt.m_128454_("TimeCreated");
        this.timeModified = nbt.m_128454_("TimeModified");
        BlockPos size = NBTUtils.readBlockPos((CompoundTag)nbt.m_128469_("EnclosingSize"));
        this.enclosingSize = size != null ? size : BlockPos.f_121853_;
        this.thumbnailPixelData = (int[])(nbt.m_128425_("PreviewImageData", 11) ? nbt.m_128465_("PreviewImageData") : null);
    }
}

