/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.RenderUtils;
import fi.dy.masa.litematica.render.schematic.BufferBuilderCache;
import fi.dy.masa.litematica.render.schematic.ChunkCacheSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderTaskSchematic;
import fi.dy.masa.litematica.render.schematic.OmegaHackfixForCrashJustTemporarilyForNowISwearBecauseOfShittyBrokenCodeBufferBuilder;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.util.OverlayType;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChunkRendererSchematicVbo {
    public static int schematicRenderChunksUpdated;
    protected volatile WorldSchematic world;
    protected final WorldRendererSchematic worldRenderer;
    protected final ReentrantLock chunkRenderLock;
    protected final ReentrantLock chunkRenderDataLock;
    protected final Set<BlockEntity> setBlockEntities = new HashSet<BlockEntity>();
    protected final BlockPos.MutableBlockPos position;
    protected final BlockPos.MutableBlockPos chunkRelativePos;
    protected final Map<RenderType, VertexBuffer> vertexBufferBlocks;
    protected final Map<OverlayRenderType, VertexBuffer> vertexBufferOverlay;
    protected final List<IntBoundingBox> boxes = new ArrayList<IntBoundingBox>();
    protected final EnumSet<OverlayRenderType> existingOverlays = EnumSet.noneOf(OverlayRenderType.class);
    private AABB boundingBox;
    protected Color4f overlayColor;
    protected boolean hasOverlay = false;
    private boolean ignoreClientWorldFluids;
    protected ChunkCacheSchematic schematicWorldView;
    protected ChunkCacheSchematic clientWorldView;
    protected ChunkRenderTaskSchematic compileTask;
    protected ChunkRenderDataSchematic chunkRenderData;
    private boolean needsUpdate;
    private boolean needsImmediateUpdate;

    public ChunkRendererSchematicVbo(WorldSchematic world, WorldRendererSchematic worldRenderer) {
        this.world = world;
        this.worldRenderer = worldRenderer;
        this.chunkRenderData = ChunkRenderDataSchematic.EMPTY;
        this.chunkRenderLock = new ReentrantLock();
        this.chunkRenderDataLock = new ReentrantLock();
        this.vertexBufferBlocks = new IdentityHashMap<RenderType, VertexBuffer>();
        this.vertexBufferOverlay = new IdentityHashMap<OverlayRenderType, VertexBuffer>();
        this.position = new BlockPos.MutableBlockPos();
        this.chunkRelativePos = new BlockPos.MutableBlockPos();
    }

    public boolean hasOverlay() {
        return this.hasOverlay;
    }

    public EnumSet<OverlayRenderType> getOverlayTypes() {
        return this.existingOverlays;
    }

    public VertexBuffer getBlocksVertexBufferByLayer(RenderType layer) {
        return this.vertexBufferBlocks.computeIfAbsent(layer, l -> new VertexBuffer(VertexBuffer.Usage.STATIC));
    }

    public VertexBuffer getOverlayVertexBuffer(OverlayRenderType type) {
        return this.vertexBufferOverlay.computeIfAbsent(type, l -> new VertexBuffer(VertexBuffer.Usage.STATIC));
    }

    public ChunkRenderDataSchematic getChunkRenderData() {
        return this.chunkRenderData;
    }

    public void setChunkRenderData(ChunkRenderDataSchematic data) {
        this.chunkRenderDataLock.lock();
        try {
            this.chunkRenderData = data;
        }
        finally {
            this.chunkRenderDataLock.unlock();
        }
    }

    public BlockPos getOrigin() {
        return this.position;
    }

    public AABB getBoundingBox() {
        if (this.boundingBox == null) {
            int x = this.position.m_123341_();
            int y = this.position.m_123342_();
            int z = this.position.m_123343_();
            this.boundingBox = new AABB((double)x, (double)y, (double)z, (double)(x + 16), (double)(y + this.world.m_141928_()), (double)(z + 16));
        }
        return this.boundingBox;
    }

    public void setPosition(int x, int y, int z) {
        if (x != this.position.m_123341_() || y != this.position.m_123342_() || z != this.position.m_123343_()) {
            this.clear();
            this.boundingBox = null;
            this.position.m_122178_(x, y, z);
        }
    }

    protected double getDistanceSq() {
        Entity entity = EntityUtils.getCameraEntity();
        double x = (double)this.position.m_123341_() + 8.0 - entity.m_20185_();
        double z = (double)this.position.m_123343_() + 8.0 - entity.m_20189_();
        return x * x + z * z;
    }

    public void deleteGlResources() {
        this.clear();
        this.world = null;
        this.vertexBufferBlocks.values().forEach(VertexBuffer::close);
        this.vertexBufferOverlay.values().forEach(VertexBuffer::close);
    }

    public void resortTransparency(ChunkRenderTaskSchematic task) {
        OverlayRenderType type;
        RenderType layerTranslucent = RenderType.m_110466_();
        ChunkRenderDataSchematic data = task.getChunkRenderData();
        BufferBuilderCache buffers = task.getBufferCache();
        BufferBuilder.SortState bufferState = data.getBlockBufferState(layerTranslucent);
        Vec3 cameraPos = task.getCameraPosSupplier().get();
        float x = (float)cameraPos.f_82479_ - (float)this.position.m_123341_();
        float y = (float)cameraPos.f_82480_ - (float)this.position.m_123342_();
        float z = (float)cameraPos.f_82481_ - (float)this.position.m_123343_();
        if (bufferState != null && !data.isBlockLayerEmpty(layerTranslucent)) {
            OmegaHackfixForCrashJustTemporarilyForNowISwearBecauseOfShittyBrokenCodeBufferBuilder buffer = buffers.getBlockBufferByLayer(layerTranslucent);
            RenderSystem.setShader(GameRenderer::m_172649_);
            this.preRenderBlocks(buffer, layerTranslucent);
            buffer.m_166775_(bufferState);
            this.postRenderBlocks(layerTranslucent, x, y, z, buffer, data);
        }
        if ((bufferState = data.getOverlayBufferState(type = OverlayRenderType.QUAD)) != null && !data.isOverlayTypeEmpty(type)) {
            OmegaHackfixForCrashJustTemporarilyForNowISwearBecauseOfShittyBrokenCodeBufferBuilder buffer = buffers.getOverlayBuffer(type);
            this.preRenderOverlay((BufferBuilder)buffer, type.getDrawMode());
            buffer.m_166775_(bufferState);
            this.postRenderOverlay(type, x, y, z, buffer, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildChunk(ChunkRenderTaskSchematic task) {
        ChunkRenderDataSchematic data = new ChunkRenderDataSchematic();
        task.getLock().lock();
        try {
            if (task.getStatus() != ChunkRenderTaskSchematic.Status.COMPILING) {
                return;
            }
            task.setChunkRenderData(data);
        }
        finally {
            task.getLock().unlock();
        }
        HashSet<BlockEntity> tileEntities = new HashSet<BlockEntity>();
        BlockPos.MutableBlockPos posChunk = this.position;
        LayerRange range = DataManager.getRenderLayerRange();
        this.existingOverlays.clear();
        this.hasOverlay = false;
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            int minX = posChunk.m_123341_();
            int minY = posChunk.m_123342_();
            int minZ = posChunk.m_123343_();
            int maxX = minX + 15;
            int maxY = minY + this.world.m_141928_();
            int maxZ = minZ + 15;
            if (!(this.boxes.isEmpty() || this.schematicWorldView.isEmpty() && this.clientWorldView.isEmpty() || !range.intersectsBox(minX, minY, minZ, maxX, maxY, maxZ))) {
                ++schematicRenderChunksUpdated;
                Vec3 cameraPos = task.getCameraPosSupplier().get();
                float x = (float)cameraPos.f_82479_ - (float)this.position.m_123341_();
                float y = (float)cameraPos.f_82480_ - (float)this.position.m_123342_();
                float z = (float)cameraPos.f_82481_ - (float)this.position.m_123343_();
                HashSet<RenderType> usedLayers = new HashSet<RenderType>();
                BufferBuilderCache buffers = task.getBufferCache();
                PoseStack matrices = new PoseStack();
                int bottomY = this.position.m_123342_();
                for (IntBoundingBox box : this.boxes) {
                    if ((box = range.getClampedRenderBoundingBox(box)) == null) continue;
                    BlockPos posFrom = new BlockPos(box.minX, box.minY, box.minZ);
                    BlockPos posTo = new BlockPos(box.maxX, box.maxY, box.maxZ);
                    for (BlockPos posMutable : BlockPos.MutableBlockPos.m_121940_((BlockPos)posFrom, (BlockPos)posTo)) {
                        matrices.m_85836_();
                        matrices.m_252880_((float)(posMutable.m_123341_() & 0xF), (float)(posMutable.m_123342_() - bottomY), (float)(posMutable.m_123343_() & 0xF));
                        this.renderBlocksAndOverlay(posMutable, data, tileEntities, usedLayers, matrices, buffers);
                        matrices.m_85849_();
                    }
                }
                for (RenderType layerTmp : RenderType.m_110506_()) {
                    if (usedLayers.contains(layerTmp)) {
                        data.setBlockLayerUsed(layerTmp);
                    }
                    if (!data.isBlockLayerStarted(layerTmp)) continue;
                    this.postRenderBlocks(layerTmp, x, y, z, buffers.getBlockBufferByLayer(layerTmp), data);
                }
                if (this.hasOverlay) {
                    for (OverlayRenderType type : this.existingOverlays) {
                        if (!data.isOverlayTypeStarted(type)) continue;
                        data.setOverlayTypeUsed(type);
                        this.postRenderOverlay(type, x, y, z, buffers.getOverlayBuffer(type), data);
                    }
                }
            }
        }
        this.chunkRenderLock.lock();
        try {
            HashSet set = Sets.newHashSet(tileEntities);
            HashSet set1 = Sets.newHashSet(this.setBlockEntities);
            set.removeAll(this.setBlockEntities);
            set1.removeAll(tileEntities);
            this.setBlockEntities.clear();
            this.setBlockEntities.addAll(tileEntities);
            this.worldRenderer.updateBlockEntities(set1, set);
        }
        finally {
            this.chunkRenderLock.unlock();
        }
        data.setTimeBuilt(this.world.m_46467_());
    }

    protected void renderBlocksAndOverlay(BlockPos pos, ChunkRenderDataSchematic data, Set<BlockEntity> tileEntities, Set<RenderType> usedLayers, PoseStack matrices, BufferBuilderCache buffers) {
        BlockState stateSchematic = this.schematicWorldView.m_8055_(pos);
        BlockState stateClient = this.clientWorldView.m_8055_(pos);
        boolean clientHasAir = stateClient.m_60795_();
        boolean schematicHasAir = stateSchematic.m_60795_();
        boolean missing = false;
        if (clientHasAir && schematicHasAir) {
            return;
        }
        this.overlayColor = null;
        if (clientHasAir || stateSchematic != stateClient && Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
            RenderType layer;
            if (stateSchematic.m_155947_()) {
                this.addBlockEntity(pos, data, tileEntities);
            }
            boolean translucent = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue();
            FluidState fluidState = stateSchematic.m_60819_();
            if (!fluidState.m_76178_()) {
                layer = ItemBlockRenderTypes.m_109287_((FluidState)fluidState);
                int offsetY = (pos.m_123342_() >> 4 << 4) - this.position.m_123342_();
                OmegaHackfixForCrashJustTemporarilyForNowISwearBecauseOfShittyBrokenCodeBufferBuilder bufferSchematic = buffers.getBlockBufferByLayer(layer);
                bufferSchematic.setYOffset(offsetY);
                if (!data.isBlockLayerStarted(layer)) {
                    data.setBlockLayerStarted(layer);
                    this.preRenderBlocks(bufferSchematic, layer);
                }
                this.worldRenderer.renderFluid(this.schematicWorldView, fluidState, pos, bufferSchematic);
                usedLayers.add(layer);
                bufferSchematic.setYOffset(0.0);
            }
            if (stateSchematic.m_60799_() != RenderShape.INVISIBLE) {
                layer = translucent ? RenderType.m_110466_() : ItemBlockRenderTypes.m_109282_((BlockState)stateSchematic);
                OmegaHackfixForCrashJustTemporarilyForNowISwearBecauseOfShittyBrokenCodeBufferBuilder bufferSchematic = buffers.getBlockBufferByLayer(layer);
                if (!data.isBlockLayerStarted(layer)) {
                    data.setBlockLayerStarted(layer);
                    this.preRenderBlocks(bufferSchematic, layer);
                }
                if (this.worldRenderer.renderBlock(this.schematicWorldView, stateSchematic, pos, matrices, bufferSchematic)) {
                    usedLayers.add(layer);
                }
                if (clientHasAir) {
                    missing = true;
                }
            }
        }
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue()) {
            OverlayType type = this.getOverlayType(stateSchematic, stateClient);
            this.overlayColor = this.getOverlayColor(type);
            if (this.overlayColor != null) {
                this.renderOverlay(type, pos, stateSchematic, missing, data, buffers);
            }
        }
    }

    protected void renderOverlay(OverlayType type, BlockPos pos, BlockState stateSchematic, boolean missing, ChunkRenderDataSchematic data, BufferBuilderCache buffers) {
        BakedModel bakedModel;
        RenderSystem.setShader(GameRenderer::m_172811_);
        BlockPos.MutableBlockPos relPos = this.getChunkRelativePosition(pos);
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_SIDES.getBooleanValue()) {
            OmegaHackfixForCrashJustTemporarilyForNowISwearBecauseOfShittyBrokenCodeBufferBuilder bufferOverlayQuads = buffers.getOverlayBuffer(OverlayRenderType.QUAD);
            if (!data.isOverlayTypeStarted(OverlayRenderType.QUAD)) {
                data.setOverlayTypeStarted(OverlayRenderType.QUAD);
                this.preRenderOverlay((BufferBuilder)bufferOverlayQuads, OverlayRenderType.QUAD);
            }
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
                for (int i = 0; i < 6; ++i) {
                    Direction side = PositionUtils.ALL_DIRECTIONS[i];
                    posMutable.m_122178_(pos.m_123341_() + side.m_122429_(), pos.m_123342_() + side.m_122430_(), pos.m_123343_() + side.m_122431_());
                    BlockState adjStateSchematic = this.schematicWorldView.m_8055_((BlockPos)posMutable);
                    BlockState adjStateClient = this.clientWorldView.m_8055_((BlockPos)posMutable);
                    OverlayType typeAdj = this.getOverlayType(adjStateSchematic, adjStateClient);
                    if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                        BakedModel bakedModel2 = this.worldRenderer.getModelForState(stateSchematic);
                        if (type.getRenderPriority() <= typeAdj.getRenderPriority() && Block.m_49918_((VoxelShape)stateSchematic.m_60812_((BlockGetter)this.schematicWorldView, pos), (Direction)side)) continue;
                        RenderUtils.drawBlockModelQuadOverlayBatched(bakedModel2, stateSchematic, (BlockPos)relPos, side, this.overlayColor, 0.0, bufferOverlayQuads);
                        continue;
                    }
                    if (type.getRenderPriority() <= typeAdj.getRenderPriority()) continue;
                    RenderUtils.drawBlockBoxSideBatchedQuads((BlockPos)relPos, side, this.overlayColor, 0.0, bufferOverlayQuads);
                }
            } else if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                bakedModel = this.worldRenderer.getModelForState(stateSchematic);
                RenderUtils.drawBlockModelQuadOverlayBatched(bakedModel, stateSchematic, (BlockPos)relPos, this.overlayColor, 0.0, bufferOverlayQuads);
            } else {
                fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxSidesBatchedQuads((BlockPos)relPos, (Color4f)this.overlayColor, (double)0.0, (BufferBuilder)bufferOverlayQuads);
            }
        }
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_OUTLINES.getBooleanValue()) {
            OmegaHackfixForCrashJustTemporarilyForNowISwearBecauseOfShittyBrokenCodeBufferBuilder bufferOverlayOutlines = buffers.getOverlayBuffer(OverlayRenderType.OUTLINE);
            if (!data.isOverlayTypeStarted(OverlayRenderType.OUTLINE)) {
                data.setOverlayTypeStarted(OverlayRenderType.OUTLINE);
                this.preRenderOverlay((BufferBuilder)bufferOverlayOutlines, OverlayRenderType.OUTLINE);
            }
            this.overlayColor = new Color4f(this.overlayColor.r, this.overlayColor.g, this.overlayColor.b, 1.0f);
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                OverlayType[][][] adjTypes = new OverlayType[3][3][3];
                BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
                for (int y = 0; y <= 2; ++y) {
                    for (int z = 0; z <= 2; ++z) {
                        for (int x = 0; x <= 2; ++x) {
                            if (x != 1 || y != 1 || z != 1) {
                                posMutable.m_122178_(pos.m_123341_() + x - 1, pos.m_123342_() + y - 1, pos.m_123343_() + z - 1);
                                BlockState adjStateSchematic = this.schematicWorldView.m_8055_((BlockPos)posMutable);
                                BlockState adjStateClient = this.clientWorldView.m_8055_((BlockPos)posMutable);
                                adjTypes[x][y][z] = this.getOverlayType(adjStateSchematic, adjStateClient);
                                continue;
                            }
                            adjTypes[x][y][z] = type;
                        }
                    }
                }
                if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                    BakedModel bakedModel3 = this.worldRenderer.getModelForState(stateSchematic);
                    if (stateSchematic.m_60815_()) {
                        this.renderOverlayReducedEdges(pos, adjTypes, type, bufferOverlayOutlines);
                    } else {
                        RenderUtils.drawBlockModelOutlinesBatched(bakedModel3, stateSchematic, (BlockPos)relPos, this.overlayColor, 0.0, bufferOverlayOutlines);
                    }
                } else {
                    this.renderOverlayReducedEdges(pos, adjTypes, type, bufferOverlayOutlines);
                }
            } else if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                bakedModel = this.worldRenderer.getModelForState(stateSchematic);
                RenderUtils.drawBlockModelOutlinesBatched(bakedModel, stateSchematic, (BlockPos)relPos, this.overlayColor, 0.0, bufferOverlayOutlines);
            } else {
                fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((BlockPos)relPos, (Color4f)this.overlayColor, (double)0.0, (BufferBuilder)bufferOverlayOutlines);
            }
        }
    }

    protected BlockPos.MutableBlockPos getChunkRelativePosition(BlockPos pos) {
        return this.chunkRelativePos.m_122178_(pos.m_123341_() & 0xF, pos.m_123342_() - this.position.m_123342_(), pos.m_123343_() & 0xF);
    }

    protected void renderOverlayReducedEdges(BlockPos pos, OverlayType[][][] adjTypes, OverlayType typeSelf, BufferBuilder bufferOverlayOutlines) {
        OverlayType[] neighborTypes = new OverlayType[4];
        Vec3i[] neighborPositions = new Vec3i[4];
        int lines = 0;
        for (Direction.Axis axis : fi.dy.masa.litematica.util.PositionUtils.AXES_ALL) {
            for (int corner = 0; corner < 4; ++corner) {
                Vec3i[] offsets = fi.dy.masa.litematica.util.PositionUtils.getEdgeNeighborOffsets(axis, corner);
                int index = -1;
                boolean hasCurrent = false;
                for (int i = 0; i < 4; ++i) {
                    Vec3i offset = offsets[i];
                    OverlayType type = adjTypes[offset.m_123341_() + 1][offset.m_123342_() + 1][offset.m_123343_() + 1];
                    if (type == OverlayType.NONE || index != -1 && type.getRenderPriority() < neighborTypes[index - 1].getRenderPriority()) continue;
                    if (index < 0 || type.getRenderPriority() > neighborTypes[index - 1].getRenderPriority()) {
                        index = 0;
                    }
                    neighborPositions[index] = new Vec3i(pos.m_123341_() + offset.m_123341_(), pos.m_123342_() + offset.m_123342_(), pos.m_123343_() + offset.m_123343_());
                    neighborTypes[index] = type;
                    hasCurrent |= i == 0;
                    ++index;
                }
                if (index <= 0 || !hasCurrent) continue;
                Vec3i posTmp = new Vec3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                int ind = -1;
                for (int i = 0; i < index; ++i) {
                    Vec3i tmp = neighborPositions[i];
                    if (tmp.m_123341_() > posTmp.m_123341_() || tmp.m_123342_() > posTmp.m_123342_() || tmp.m_123343_() > posTmp.m_123343_()) continue;
                    posTmp = tmp;
                    ind = i;
                }
                if (posTmp.m_123341_() != pos.m_123341_() || posTmp.m_123342_() != pos.m_123342_() || posTmp.m_123343_() != pos.m_123343_()) continue;
                RenderUtils.drawBlockBoxEdgeBatchedLines((BlockPos)this.getChunkRelativePosition(pos), axis, corner, this.overlayColor, bufferOverlayOutlines);
                ++lines;
            }
        }
    }

    protected OverlayType getOverlayType(BlockState stateSchematic, BlockState stateClient) {
        if (stateSchematic == stateClient) {
            return OverlayType.NONE;
        }
        boolean clientHasAir = stateClient.m_60795_();
        boolean schematicHasAir = stateSchematic.m_60795_();
        if (schematicHasAir) {
            return clientHasAir || this.ignoreClientWorldFluids && stateClient.m_278721_() ? OverlayType.NONE : OverlayType.EXTRA;
        }
        if (clientHasAir || this.ignoreClientWorldFluids && stateClient.m_278721_()) {
            return OverlayType.MISSING;
        }
        if (stateSchematic.m_60734_() != stateClient.m_60734_()) {
            return OverlayType.WRONG_BLOCK;
        }
        return OverlayType.WRONG_STATE;
    }

    @Nullable
    protected Color4f getOverlayColor(OverlayType overlayType) {
        Color4f overlayColor = null;
        switch (overlayType) {
            case MISSING: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_MISSING.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_MISSING.getColor();
                break;
            }
            case EXTRA: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_EXTRA.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_EXTRA.getColor();
                break;
            }
            case WRONG_BLOCK: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_BLOCK.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_BLOCK.getColor();
                break;
            }
            case WRONG_STATE: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_STATE.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_STATE.getColor();
                break;
            }
        }
        return overlayColor;
    }

    private void addBlockEntity(BlockPos pos, ChunkRenderDataSchematic chunkRenderData, Set<BlockEntity> blockEntities) {
        BlockEntityRenderer tesr;
        BlockEntity te = this.schematicWorldView.getBlockEntity(pos, LevelChunk.EntityCreationType.CHECK);
        if (te != null && (tesr = Minecraft.m_91087_().m_167982_().m_112265_(te)) != null) {
            chunkRenderData.addBlockEntity(te);
            if (tesr.m_5932_(te)) {
                blockEntities.add(te);
            }
        }
    }

    private void preRenderBlocks(BufferBuilder buffer, RenderType layer) {
        buffer.m_166779_(VertexFormat.Mode.QUADS, layer.m_110508_());
    }

    private void postRenderBlocks(RenderType layer, float x, float y, float z, BufferBuilder buffer, ChunkRenderDataSchematic chunkRenderData) {
        if (layer == RenderType.m_110466_() && !chunkRenderData.isBlockLayerEmpty(layer)) {
            buffer.m_277127_(VertexSorting.m_277071_((float)x, (float)y, (float)z));
            chunkRenderData.setBlockBufferState(layer, buffer.m_166770_());
        }
        buffer.m_231175_();
    }

    private void preRenderOverlay(BufferBuilder buffer, OverlayRenderType type) {
        this.existingOverlays.add(type);
        this.hasOverlay = true;
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(type.getDrawMode(), DefaultVertexFormat.f_85815_);
    }

    private void preRenderOverlay(BufferBuilder buffer, VertexFormat.Mode drawMode) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(drawMode, DefaultVertexFormat.f_85815_);
    }

    private void postRenderOverlay(OverlayRenderType type, float x, float y, float z, BufferBuilder buffer, ChunkRenderDataSchematic chunkRenderData) {
        RenderSystem.applyModelViewMatrix();
        if (type == OverlayRenderType.QUAD && !chunkRenderData.isOverlayTypeEmpty(type)) {
            buffer.m_277127_(VertexSorting.m_277071_((float)x, (float)y, (float)z));
            chunkRenderData.setOverlayBufferState(type, buffer.m_166770_());
        }
        buffer.m_231175_();
    }

    public ChunkRenderTaskSchematic makeCompileTaskChunkSchematic(Supplier<Vec3> cameraPosSupplier) {
        this.chunkRenderLock.lock();
        ChunkRenderTaskSchematic generator = null;
        try {
            this.finishCompileTask();
            this.rebuildWorldView();
            generator = this.compileTask = new ChunkRenderTaskSchematic(this, ChunkRenderTaskSchematic.Type.REBUILD_CHUNK, cameraPosSupplier, this.getDistanceSq());
        }
        finally {
            this.chunkRenderLock.unlock();
        }
        return generator;
    }

    @Nullable
    public ChunkRenderTaskSchematic makeCompileTaskTransparencySchematic(Supplier<Vec3> cameraPosSupplier) {
        this.chunkRenderLock.lock();
        try {
            if (this.compileTask == null || this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.PENDING) {
                if (this.compileTask != null && this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.DONE) {
                    this.compileTask.finish();
                }
                this.compileTask = new ChunkRenderTaskSchematic(this, ChunkRenderTaskSchematic.Type.RESORT_TRANSPARENCY, cameraPosSupplier, this.getDistanceSq());
                this.compileTask.setChunkRenderData(this.chunkRenderData);
                ChunkRenderTaskSchematic chunkRenderTaskSchematic = this.compileTask;
                return chunkRenderTaskSchematic;
            }
        }
        finally {
            this.chunkRenderLock.unlock();
        }
        return null;
    }

    protected void finishCompileTask() {
        this.chunkRenderLock.lock();
        try {
            if (this.compileTask != null && this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.DONE) {
                this.compileTask.finish();
                this.compileTask = null;
            }
        }
        finally {
            this.chunkRenderLock.unlock();
        }
    }

    public ReentrantLock getLockCompileTask() {
        return this.chunkRenderLock;
    }

    public void clear() {
        this.finishCompileTask();
        this.chunkRenderData = ChunkRenderDataSchematic.EMPTY;
    }

    public void setNeedsUpdate(boolean immediate) {
        if (this.needsUpdate) {
            immediate |= this.needsImmediateUpdate;
        }
        this.needsUpdate = true;
        this.needsImmediateUpdate = immediate;
    }

    public void clearNeedsUpdate() {
        this.needsUpdate = false;
        this.needsImmediateUpdate = false;
    }

    public boolean needsUpdate() {
        return this.needsUpdate;
    }

    public boolean needsImmediateUpdate() {
        return this.needsUpdate && this.needsImmediateUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildWorldView() {
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            this.ignoreClientWorldFluids = Configs.Visuals.IGNORE_EXISTING_FLUIDS.getBooleanValue();
            ClientLevel worldClient = Minecraft.m_91087_().f_91073_;
            this.schematicWorldView = new ChunkCacheSchematic(this.world, worldClient, (BlockPos)this.position, 2);
            this.clientWorldView = new ChunkCacheSchematic((Level)worldClient, worldClient, (BlockPos)this.position, 2);
            this.boxes.clear();
            int chunkX = this.position.m_123341_() >> 4;
            int chunkZ = this.position.m_123343_() >> 4;
            for (SchematicPlacementManager.PlacementPart part : DataManager.getSchematicPlacementManager().getPlacementPartsInChunk(chunkX, chunkZ)) {
                this.boxes.add(part.bb);
            }
        }
    }

    public static enum OverlayRenderType {
        OUTLINE(VertexFormat.Mode.DEBUG_LINES),
        QUAD(VertexFormat.Mode.QUADS);

        private final VertexFormat.Mode drawMode;

        private OverlayRenderType(VertexFormat.Mode drawMode) {
            this.drawMode = drawMode;
        }

        public VertexFormat.Mode getDrawMode() {
            return this.drawMode;
        }
    }
}

