/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.litematica.util.BlockInfoAlignment;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.gui.LeftRight;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.phys.Vec3;

public class RenderUtils {
    private static final SingleThreadedRandomSource RAND = new SingleThreadedRandomSource(0L);

    public static int getMaxStringRenderLength(List<String> list) {
        int length = 0;
        for (String str : list) {
            length = Math.max(length, StringUtils.getStringWidth((String)str));
        }
        return length;
    }

    static void startDrawingLines(BufferBuilder buffer) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.applyModelViewMatrix();
        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
    }

    public static void renderBlockOutline(BlockPos pos, float expand, float lineWidth, Color4f color, Minecraft mc) {
        RenderSystem.lineWidth((float)lineWidth);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderUtils.startDrawingLines(buffer);
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(pos, color, expand, buffer, mc);
        tessellator.m_85914_();
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(BlockPos pos, Color4f color, double expand, BufferBuilder buffer, Minecraft mc) {
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        double dx = cameraPos.f_82479_;
        double dy = cameraPos.f_82480_;
        double dz = cameraPos.f_82481_;
        double minX = (double)pos.m_123341_() - dx - expand;
        double minY = (double)pos.m_123342_() - dy - expand;
        double minZ = (double)pos.m_123343_() - dz - expand;
        double maxX = (double)pos.m_123341_() - dx + expand + 1.0;
        double maxY = (double)pos.m_123342_() - dy + expand + 1.0;
        double maxZ = (double)pos.m_123343_() - dz + expand + 1.0;
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllEdgesBatchedLines((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (BufferBuilder)buffer);
    }

    public static void drawConnectingLineBatchedLines(BlockPos pos1, BlockPos pos2, boolean center, Color4f color, BufferBuilder buffer, Minecraft mc) {
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        double dx = cameraPos.f_82479_;
        double dy = cameraPos.f_82480_;
        double dz = cameraPos.f_82481_;
        double x1 = (double)pos1.m_123341_() - dx;
        double y1 = (double)pos1.m_123342_() - dy;
        double z1 = (double)pos1.m_123343_() - dz;
        double x2 = (double)pos2.m_123341_() - dx;
        double y2 = (double)pos2.m_123342_() - dy;
        double z2 = (double)pos2.m_123343_() - dz;
        if (center) {
            x1 += 0.5;
            y1 += 0.5;
            z1 += 0.5;
            x2 += 0.5;
            y2 += 0.5;
            z2 += 0.5;
        }
        buffer.m_5483_(x1, y1, z1).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(x2, y2, z2).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
    }

    public static void renderBlockOutlineOverlapping(BlockPos pos, float expand, float lineWidth, Color4f color1, Color4f color2, Color4f color3, PoseStack matrices, Minecraft mc) {
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        double dx = cameraPos.f_82479_;
        double dy = cameraPos.f_82480_;
        double dz = cameraPos.f_82481_;
        double minX = (double)pos.m_123341_() - dx - (double)expand;
        double minY = (double)pos.m_123342_() - dy - (double)expand;
        double minZ = (double)pos.m_123343_() - dz - (double)expand;
        double maxX = (double)pos.m_123341_() - dx + (double)expand + 1.0;
        double maxY = (double)pos.m_123342_() - dy + (double)expand + 1.0;
        double maxZ = (double)pos.m_123343_() - dz + (double)expand + 1.0;
        RenderSystem.lineWidth((float)lineWidth);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderUtils.startDrawingLines(buffer);
        buffer.m_5483_(minX, minY, minZ).m_85950_(color1.r, color1.g, color1.b, color1.a).m_5752_();
        buffer.m_5483_(maxX, minY, minZ).m_85950_(color1.r, color1.g, color1.b, color1.a).m_5752_();
        buffer.m_5483_(minX, minY, minZ).m_85950_(color1.r, color1.g, color1.b, color1.a).m_5752_();
        buffer.m_5483_(minX, maxY, minZ).m_85950_(color1.r, color1.g, color1.b, color1.a).m_5752_();
        buffer.m_5483_(minX, minY, minZ).m_85950_(color1.r, color1.g, color1.b, color1.a).m_5752_();
        buffer.m_5483_(minX, minY, maxZ).m_85950_(color1.r, color1.g, color1.b, color1.a).m_5752_();
        buffer.m_5483_(minX, maxY, maxZ).m_85950_(color2.r, color2.g, color2.b, color2.a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color2.r, color2.g, color2.b, color2.a).m_5752_();
        buffer.m_5483_(maxX, minY, maxZ).m_85950_(color2.r, color2.g, color2.b, color2.a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color2.r, color2.g, color2.b, color2.a).m_5752_();
        buffer.m_5483_(maxX, maxY, minZ).m_85950_(color2.r, color2.g, color2.b, color2.a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color2.r, color2.g, color2.b, color2.a).m_5752_();
        buffer.m_5483_(minX, maxY, minZ).m_85950_(color3.r, color3.g, color3.b, color3.a).m_5752_();
        buffer.m_5483_(maxX, maxY, minZ).m_85950_(color3.r, color3.g, color3.b, color3.a).m_5752_();
        buffer.m_5483_(minX, minY, maxZ).m_85950_(color3.r, color3.g, color3.b, color3.a).m_5752_();
        buffer.m_5483_(maxX, minY, maxZ).m_85950_(color3.r, color3.g, color3.b, color3.a).m_5752_();
        buffer.m_5483_(maxX, minY, minZ).m_85950_(color3.r, color3.g, color3.b, color3.a).m_5752_();
        buffer.m_5483_(maxX, maxY, minZ).m_85950_(color3.r, color3.g, color3.b, color3.a).m_5752_();
        buffer.m_5483_(minX, minY, maxZ).m_85950_(color3.r, color3.g, color3.b, color3.a).m_5752_();
        buffer.m_5483_(minX, maxY, maxZ).m_85950_(color3.r, color3.g, color3.b, color3.a).m_5752_();
        buffer.m_5483_(maxX, minY, minZ).m_85950_(color3.r, color3.g, color3.b, color3.a).m_5752_();
        buffer.m_5483_(maxX, minY, maxZ).m_85950_(color3.r, color3.g, color3.b, color3.a).m_5752_();
        buffer.m_5483_(minX, maxY, minZ).m_85950_(color3.r, color3.g, color3.b, color3.a).m_5752_();
        buffer.m_5483_(minX, maxY, maxZ).m_85950_(color3.r, color3.g, color3.b, color3.a).m_5752_();
        tessellator.m_85914_();
    }

    public static void renderAreaOutline(BlockPos pos1, BlockPos pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ, Minecraft mc) {
        RenderSystem.lineWidth((float)lineWidth);
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        double dx = cameraPos.f_82479_;
        double dy = cameraPos.f_82480_;
        double dz = cameraPos.f_82481_;
        double minX = (double)Math.min(pos1.m_123341_(), pos2.m_123341_()) - dx;
        double minY = (double)Math.min(pos1.m_123342_(), pos2.m_123342_()) - dy;
        double minZ = (double)Math.min(pos1.m_123343_(), pos2.m_123343_()) - dz;
        double maxX = (double)Math.max(pos1.m_123341_(), pos2.m_123341_()) - dx + 1.0;
        double maxY = (double)Math.max(pos1.m_123342_(), pos2.m_123342_()) - dy + 1.0;
        double maxZ = (double)Math.max(pos1.m_123343_(), pos2.m_123343_()) - dz + 1.0;
        RenderUtils.drawBoundingBoxEdges(minX, minY, minZ, maxX, maxY, maxZ, colorX, colorY, colorZ);
    }

    private static void drawBoundingBoxEdges(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f colorX, Color4f colorY, Color4f colorZ) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        RenderUtils.startDrawingLines(bufferbuilder);
        RenderUtils.drawBoundingBoxLinesX(bufferbuilder, minX, minY, minZ, maxX, maxY, maxZ, colorX);
        RenderUtils.drawBoundingBoxLinesY(bufferbuilder, minX, minY, minZ, maxX, maxY, maxZ, colorY);
        RenderUtils.drawBoundingBoxLinesZ(bufferbuilder, minX, minY, minZ, maxX, maxY, maxZ, colorZ);
        tessellator.m_85914_();
    }

    private static void drawBoundingBoxLinesX(BufferBuilder buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color) {
        buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
    }

    private static void drawBoundingBoxLinesY(BufferBuilder buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color) {
        buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
    }

    private static void drawBoundingBoxLinesZ(BufferBuilder buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color) {
        buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
    }

    public static void renderAreaSides(BlockPos pos1, BlockPos pos2, Color4f color, PoseStack matrices, Minecraft mc) {
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderUtils.renderAreaSidesBatched(pos1, pos2, color, 0.002, buffer, mc);
        tessellator.m_85914_();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    public static void renderAreaSidesBatched(BlockPos pos1, BlockPos pos2, Color4f color, double expand, BufferBuilder buffer, Minecraft mc) {
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        double dx = cameraPos.f_82479_;
        double dy = cameraPos.f_82480_;
        double dz = cameraPos.f_82481_;
        double minX = (double)Math.min(pos1.m_123341_(), pos2.m_123341_()) - dx - expand;
        double minY = (double)Math.min(pos1.m_123342_(), pos2.m_123342_()) - dy - expand;
        double minZ = (double)Math.min(pos1.m_123343_(), pos2.m_123343_()) - dz - expand;
        double maxX = (double)(Math.max(pos1.m_123341_(), pos2.m_123341_()) + 1) - dx + expand;
        double maxY = (double)(Math.max(pos1.m_123342_(), pos2.m_123342_()) + 1) - dy + expand;
        double maxZ = (double)(Math.max(pos1.m_123343_(), pos2.m_123343_()) + 1) - dz + expand;
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllSidesBatchedQuads((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (BufferBuilder)buffer);
    }

    public static void renderAreaOutlineNoCorners(BlockPos pos1, BlockPos pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ, Minecraft mc) {
        int end;
        int xMin = Math.min(pos1.m_123341_(), pos2.m_123341_());
        int yMin = Math.min(pos1.m_123342_(), pos2.m_123342_());
        int zMin = Math.min(pos1.m_123343_(), pos2.m_123343_());
        int xMax = Math.max(pos1.m_123341_(), pos2.m_123341_());
        int yMax = Math.max(pos1.m_123342_(), pos2.m_123342_());
        int zMax = Math.max(pos1.m_123343_(), pos2.m_123343_());
        double expand = 0.001;
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        double dx = cameraPos.f_82479_;
        double dy = cameraPos.f_82480_;
        double dz = cameraPos.f_82481_;
        double dxMin = -dx - 0.001;
        double dyMin = -dy - 0.001;
        double dzMin = -dz - 0.001;
        double dxMax = -dx + 0.001;
        double dyMax = -dy + 0.001;
        double dzMax = -dz + 0.001;
        double minX = (double)xMin + dxMin;
        double minY = (double)yMin + dyMin;
        double minZ = (double)zMin + dzMin;
        double maxX = (double)xMax + dxMax;
        double maxY = (double)yMax + dyMax;
        double maxZ = (double)zMax + dzMax;
        RenderSystem.lineWidth((float)lineWidth);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderUtils.startDrawingLines(buffer);
        int start = pos1.m_123341_() == xMin && pos1.m_123342_() == yMin && pos1.m_123343_() == zMin || pos2.m_123341_() == xMin && pos2.m_123342_() == yMin && pos2.m_123343_() == zMin ? xMin + 1 : xMin;
        int n = end = pos1.m_123341_() == xMax && pos1.m_123342_() == yMin && pos1.m_123343_() == zMin || pos2.m_123341_() == xMax && pos2.m_123342_() == yMin && pos2.m_123343_() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.m_5483_((double)start + dxMin, minY, minZ).m_85950_(colorX.r, colorX.g, colorX.b, colorX.a).m_5752_();
            buffer.m_5483_((double)end + dxMax, minY, minZ).m_85950_(colorX.r, colorX.g, colorX.b, colorX.a).m_5752_();
        }
        start = pos1.m_123341_() == xMin && pos1.m_123342_() == yMax && pos1.m_123343_() == zMin || pos2.m_123341_() == xMin && pos2.m_123342_() == yMax && pos2.m_123343_() == zMin ? xMin + 1 : xMin;
        int n2 = end = pos1.m_123341_() == xMax && pos1.m_123342_() == yMax && pos1.m_123343_() == zMin || pos2.m_123341_() == xMax && pos2.m_123342_() == yMax && pos2.m_123343_() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.m_5483_((double)start + dxMin, maxY + 1.0, minZ).m_85950_(colorX.r, colorX.g, colorX.b, colorX.a).m_5752_();
            buffer.m_5483_((double)end + dxMax, maxY + 1.0, minZ).m_85950_(colorX.r, colorX.g, colorX.b, colorX.a).m_5752_();
        }
        start = pos1.m_123341_() == xMin && pos1.m_123342_() == yMin && pos1.m_123343_() == zMax || pos2.m_123341_() == xMin && pos2.m_123342_() == yMin && pos2.m_123343_() == zMax ? xMin + 1 : xMin;
        int n3 = end = pos1.m_123341_() == xMax && pos1.m_123342_() == yMin && pos1.m_123343_() == zMax || pos2.m_123341_() == xMax && pos2.m_123342_() == yMin && pos2.m_123343_() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.m_5483_((double)start + dxMin, minY, maxZ + 1.0).m_85950_(colorX.r, colorX.g, colorX.b, colorX.a).m_5752_();
            buffer.m_5483_((double)end + dxMax, minY, maxZ + 1.0).m_85950_(colorX.r, colorX.g, colorX.b, colorX.a).m_5752_();
        }
        start = pos1.m_123341_() == xMin && pos1.m_123342_() == yMax && pos1.m_123343_() == zMax || pos2.m_123341_() == xMin && pos2.m_123342_() == yMax && pos2.m_123343_() == zMax ? xMin + 1 : xMin;
        int n4 = end = pos1.m_123341_() == xMax && pos1.m_123342_() == yMax && pos1.m_123343_() == zMax || pos2.m_123341_() == xMax && pos2.m_123342_() == yMax && pos2.m_123343_() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.m_5483_((double)start + dxMin, maxY + 1.0, maxZ + 1.0).m_85950_(colorX.r, colorX.g, colorX.b, colorX.a).m_5752_();
            buffer.m_5483_((double)end + dxMax, maxY + 1.0, maxZ + 1.0).m_85950_(colorX.r, colorX.g, colorX.b, colorX.a).m_5752_();
        }
        start = pos1.m_123341_() == xMin && pos1.m_123342_() == yMin && pos1.m_123343_() == zMin || pos2.m_123341_() == xMin && pos2.m_123342_() == yMin && pos2.m_123343_() == zMin ? yMin + 1 : yMin;
        int n5 = end = pos1.m_123341_() == xMin && pos1.m_123342_() == yMax && pos1.m_123343_() == zMin || pos2.m_123341_() == xMin && pos2.m_123342_() == yMax && pos2.m_123343_() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.m_5483_(minX, (double)start + dyMin, minZ).m_85950_(colorY.r, colorY.g, colorY.b, colorY.a).m_5752_();
            buffer.m_5483_(minX, (double)end + dyMax, minZ).m_85950_(colorY.r, colorY.g, colorY.b, colorY.a).m_5752_();
        }
        start = pos1.m_123341_() == xMax && pos1.m_123342_() == yMin && pos1.m_123343_() == zMin || pos2.m_123341_() == xMax && pos2.m_123342_() == yMin && pos2.m_123343_() == zMin ? yMin + 1 : yMin;
        int n6 = end = pos1.m_123341_() == xMax && pos1.m_123342_() == yMax && pos1.m_123343_() == zMin || pos2.m_123341_() == xMax && pos2.m_123342_() == yMax && pos2.m_123343_() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.m_5483_(maxX + 1.0, (double)start + dyMin, minZ).m_85950_(colorY.r, colorY.g, colorY.b, colorY.a).m_5752_();
            buffer.m_5483_(maxX + 1.0, (double)end + dyMax, minZ).m_85950_(colorY.r, colorY.g, colorY.b, colorY.a).m_5752_();
        }
        start = pos1.m_123341_() == xMin && pos1.m_123342_() == yMin && pos1.m_123343_() == zMax || pos2.m_123341_() == xMin && pos2.m_123342_() == yMin && pos2.m_123343_() == zMax ? yMin + 1 : yMin;
        int n7 = end = pos1.m_123341_() == xMin && pos1.m_123342_() == yMax && pos1.m_123343_() == zMax || pos2.m_123341_() == xMin && pos2.m_123342_() == yMax && pos2.m_123343_() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.m_5483_(minX, (double)start + dyMin, maxZ + 1.0).m_85950_(colorY.r, colorY.g, colorY.b, colorY.a).m_5752_();
            buffer.m_5483_(minX, (double)end + dyMax, maxZ + 1.0).m_85950_(colorY.r, colorY.g, colorY.b, colorY.a).m_5752_();
        }
        start = pos1.m_123341_() == xMax && pos1.m_123342_() == yMin && pos1.m_123343_() == zMax || pos2.m_123341_() == xMax && pos2.m_123342_() == yMin && pos2.m_123343_() == zMax ? yMin + 1 : yMin;
        int n8 = end = pos1.m_123341_() == xMax && pos1.m_123342_() == yMax && pos1.m_123343_() == zMax || pos2.m_123341_() == xMax && pos2.m_123342_() == yMax && pos2.m_123343_() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.m_5483_(maxX + 1.0, (double)start + dyMin, maxZ + 1.0).m_85950_(colorY.r, colorY.g, colorY.b, colorY.a).m_5752_();
            buffer.m_5483_(maxX + 1.0, (double)end + dyMax, maxZ + 1.0).m_85950_(colorY.r, colorY.g, colorY.b, colorY.a).m_5752_();
        }
        start = pos1.m_123341_() == xMin && pos1.m_123342_() == yMin && pos1.m_123343_() == zMin || pos2.m_123341_() == xMin && pos2.m_123342_() == yMin && pos2.m_123343_() == zMin ? zMin + 1 : zMin;
        int n9 = end = pos1.m_123341_() == xMin && pos1.m_123342_() == yMin && pos1.m_123343_() == zMax || pos2.m_123341_() == xMin && pos2.m_123342_() == yMin && pos2.m_123343_() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.m_5483_(minX, minY, (double)start + dzMin).m_85950_(colorZ.r, colorZ.g, colorZ.b, colorZ.a).m_5752_();
            buffer.m_5483_(minX, minY, (double)end + dzMax).m_85950_(colorZ.r, colorZ.g, colorZ.b, colorZ.a).m_5752_();
        }
        start = pos1.m_123341_() == xMax && pos1.m_123342_() == yMin && pos1.m_123343_() == zMin || pos2.m_123341_() == xMax && pos2.m_123342_() == yMin && pos2.m_123343_() == zMin ? zMin + 1 : zMin;
        int n10 = end = pos1.m_123341_() == xMax && pos1.m_123342_() == yMin && pos1.m_123343_() == zMax || pos2.m_123341_() == xMax && pos2.m_123342_() == yMin && pos2.m_123343_() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.m_5483_(maxX + 1.0, minY, (double)start + dzMin).m_85950_(colorZ.r, colorZ.g, colorZ.b, colorZ.a).m_5752_();
            buffer.m_5483_(maxX + 1.0, minY, (double)end + dzMax).m_85950_(colorZ.r, colorZ.g, colorZ.b, colorZ.a).m_5752_();
        }
        start = pos1.m_123341_() == xMin && pos1.m_123342_() == yMax && pos1.m_123343_() == zMin || pos2.m_123341_() == xMin && pos2.m_123342_() == yMax && pos2.m_123343_() == zMin ? zMin + 1 : zMin;
        int n11 = end = pos1.m_123341_() == xMin && pos1.m_123342_() == yMax && pos1.m_123343_() == zMax || pos2.m_123341_() == xMin && pos2.m_123342_() == yMax && pos2.m_123343_() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.m_5483_(minX, maxY + 1.0, (double)start + dzMin).m_85950_(colorZ.r, colorZ.g, colorZ.b, colorZ.a).m_5752_();
            buffer.m_5483_(minX, maxY + 1.0, (double)end + dzMax).m_85950_(colorZ.r, colorZ.g, colorZ.b, colorZ.a).m_5752_();
        }
        start = pos1.m_123341_() == xMax && pos1.m_123342_() == yMax && pos1.m_123343_() == zMin || pos2.m_123341_() == xMax && pos2.m_123342_() == yMax && pos2.m_123343_() == zMin ? zMin + 1 : zMin;
        int n12 = end = pos1.m_123341_() == xMax && pos1.m_123342_() == yMax && pos1.m_123343_() == zMax || pos2.m_123341_() == xMax && pos2.m_123342_() == yMax && pos2.m_123343_() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.m_5483_(maxX + 1.0, maxY + 1.0, (double)start + dzMin).m_85950_(colorZ.r, colorZ.g, colorZ.b, colorZ.a).m_5752_();
            buffer.m_5483_(maxX + 1.0, maxY + 1.0, (double)end + dzMax).m_85950_(colorZ.r, colorZ.g, colorZ.b, colorZ.a).m_5752_();
        }
        tessellator.m_85914_();
    }

    public static void drawBlockModelOutlinesBatched(BakedModel model, BlockState state, BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        for (Direction side : fi.dy.masa.malilib.util.PositionUtils.ALL_DIRECTIONS) {
            RenderUtils.renderModelQuadOutlines(model, state, pos, side, color, expand, buffer);
        }
        RenderUtils.renderModelQuadOutlines(model, state, pos, null, color, expand, buffer);
    }

    private static void renderModelQuadOutlines(BakedModel model, BlockState state, BlockPos pos, Direction side, Color4f color, double expand, BufferBuilder buffer) {
        try {
            RenderUtils.renderModelQuadOutlines(pos, buffer, color, model.m_213637_(state, side, (RandomSource)RAND));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void renderModelQuadOutlines(BlockPos pos, BufferBuilder buffer, Color4f color, List<BakedQuad> quads) {
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            RenderUtils.renderQuadOutlinesBatched(pos, buffer, color, quads.get(i).m_111303_());
        }
    }

    private static void renderQuadOutlinesBatched(BlockPos pos, BufferBuilder buffer, Color4f color, int[] vertexData) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        int vertexSize = vertexData.length / 4;
        float[] fx = new float[4];
        float[] fy = new float[4];
        float[] fz = new float[4];
        for (int index = 0; index < 4; ++index) {
            fx[index] = (float)x + Float.intBitsToFloat(vertexData[index * vertexSize]);
            fy[index] = (float)y + Float.intBitsToFloat(vertexData[index * vertexSize + 1]);
            fz[index] = (float)z + Float.intBitsToFloat(vertexData[index * vertexSize + 2]);
        }
        buffer.m_5483_((double)fx[0], (double)fy[0], (double)fz[0]).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_((double)fx[1], (double)fy[1], (double)fz[1]).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_((double)fx[1], (double)fy[1], (double)fz[1]).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_((double)fx[2], (double)fy[2], (double)fz[2]).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_((double)fx[2], (double)fy[2], (double)fz[2]).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_((double)fx[3], (double)fy[3], (double)fz[3]).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_((double)fx[3], (double)fy[3], (double)fz[3]).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_((double)fx[0], (double)fy[0], (double)fz[0]).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
    }

    public static void drawBlockModelQuadOverlayBatched(BakedModel model, BlockState state, BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        for (Direction side : fi.dy.masa.malilib.util.PositionUtils.ALL_DIRECTIONS) {
            RenderUtils.drawBlockModelQuadOverlayBatched(model, state, pos, side, color, expand, buffer);
        }
        RenderUtils.drawBlockModelQuadOverlayBatched(model, state, pos, null, color, expand, buffer);
    }

    public static void drawBlockModelQuadOverlayBatched(BakedModel model, BlockState state, BlockPos pos, Direction side, Color4f color, double expand, BufferBuilder buffer) {
        try {
            RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, model.m_213637_(state, side, (RandomSource)RAND));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void renderModelQuadOverlayBatched(BlockPos pos, BufferBuilder buffer, Color4f color, List<BakedQuad> quads) {
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, quads.get(i).m_111303_());
        }
    }

    private static void renderModelQuadOverlayBatched(BlockPos pos, BufferBuilder buffer, Color4f color, int[] vertexData) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        int vertexSize = vertexData.length / 4;
        for (int index = 0; index < 4; ++index) {
            float fx = (float)x + Float.intBitsToFloat(vertexData[index * vertexSize]);
            float fy = (float)y + Float.intBitsToFloat(vertexData[index * vertexSize + 1]);
            float fz = (float)z + Float.intBitsToFloat(vertexData[index * vertexSize + 2]);
            buffer.m_5483_((double)fx, (double)fy, (double)fz).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
    }

    public static void drawBlockBoxSideBatchedQuads(BlockPos pos, Direction side, Color4f color, double expand, BufferBuilder buffer) {
        double minX = (double)pos.m_123341_() - expand;
        double minY = (double)pos.m_123342_() - expand;
        double minZ = (double)pos.m_123343_() - expand;
        double maxX = (double)pos.m_123341_() + expand + 1.0;
        double maxY = (double)pos.m_123342_() + expand + 1.0;
        double maxZ = (double)pos.m_123343_() + expand + 1.0;
        switch (side) {
            case DOWN: {
                buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case UP: {
                buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case NORTH: {
                buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case SOUTH: {
                buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case WEST: {
                buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case EAST: {
                buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            }
        }
    }

    public static void drawBlockBoxEdgeBatchedLines(BlockPos pos, Direction.Axis axis, int cornerIndex, Color4f color, BufferBuilder buffer) {
        Vec3i offset = PositionUtils.getEdgeNeighborOffsets(axis, cornerIndex)[cornerIndex];
        double minX = pos.m_123341_() + offset.m_123341_();
        double minY = pos.m_123342_() + offset.m_123342_();
        double minZ = pos.m_123343_() + offset.m_123343_();
        double maxX = pos.m_123341_() + offset.m_123341_() + (axis == Direction.Axis.X ? 1 : 0);
        double maxY = pos.m_123342_() + offset.m_123342_() + (axis == Direction.Axis.Y ? 1 : 0);
        double maxZ = pos.m_123343_() + offset.m_123343_() + (axis == Direction.Axis.Z ? 1 : 0);
        buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
    }

    public static int renderInventoryOverlays(BlockInfoAlignment align, int offY, Level worldSchematic, Level worldClient, BlockPos pos, Minecraft mc, GuiGraphics drawContext) {
        int heightSch = RenderUtils.renderInventoryOverlay(align, LeftRight.LEFT, offY, worldSchematic, pos, mc, drawContext);
        int heightCli = RenderUtils.renderInventoryOverlay(align, LeftRight.RIGHT, offY, worldClient, pos, mc, drawContext);
        return Math.max(heightSch, heightCli);
    }

    public static int renderInventoryOverlay(BlockInfoAlignment align, LeftRight side, int offY, Level world, BlockPos pos, Minecraft mc, GuiGraphics drawContext) {
        Container inv = InventoryUtils.getInventory((Level)world, (BlockPos)pos);
        if (inv != null) {
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType((Container)inv);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)inv.m_6643_());
            return RenderUtils.renderInventoryOverlay(align, side, offY, inv, type, props, mc, drawContext);
        }
        return 0;
    }

    public static int renderInventoryOverlay(BlockInfoAlignment align, LeftRight side, int offY, Container inv, InventoryOverlay.InventoryRenderType type, InventoryOverlay.InventoryProperties props, Minecraft mc, GuiGraphics drawContext) {
        int xInv = 0;
        int yInv = 0;
        switch (align) {
            case CENTER: {
                xInv = GuiUtils.getScaledWindowWidth() / 2 - props.width / 2;
                yInv = GuiUtils.getScaledWindowHeight() / 2 - props.height - offY;
                break;
            }
            case TOP_CENTER: {
                xInv = GuiUtils.getScaledWindowWidth() / 2 - props.width / 2;
                yInv = offY;
            }
        }
        if (side == LeftRight.LEFT) {
            xInv -= props.width / 2 + 4;
        } else if (side == LeftRight.RIGHT) {
            xInv += props.width / 2 + 4;
        }
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)props.slotsPerRow, (int)props.totalSlots, (Minecraft)mc);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (Container)inv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)props.slotsPerRow, (int)0, (int)-1, (Minecraft)mc, (GuiGraphics)drawContext);
        return props.height;
    }
}

