/*
 * Decompiled with CFR 0.152.
 */
package mrunknown404.dice.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import mrunknown404.dice.entity.D6Model;
import mrunknown404.dice.entity.DiceEntity;
import mrunknown404.dice.entity.DiceModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class DiceEntityRenderer
extends EntityRenderer<DiceEntity> {
    private static final ResourceLocation D6_TEX = new ResourceLocation("dice", "textures/entity/d6.png");
    private static D6Model d6Model;
    private final Minecraft minecraft = Minecraft.m_91087_();

    public DiceEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        d6Model = new D6Model(ctx.m_174023_(D6Model.LAYER_LOCATION));
    }

    public void render(DiceEntity dice, float noidea, float partial, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        switch (dice.getDiceType()) {
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + dice.getRolled());
            }
        }
        D6Model model = d6Model;
        boolean flag = !dice.m_20145_();
        boolean flag1 = !flag && !dice.m_20177_((Player)this.minecraft.f_91074_);
        RenderType rendertype = this.getRenderType(dice, model, flag, flag1);
        if (rendertype != null) {
            ((DiceModel)model).setupRotation(dice);
            model.m_7695_(stack, buffer.m_6299_(rendertype), packedLight, OverlayTexture.f_118083_, (float)dice.getRed() / 255.0f, (float)dice.getGreen() / 255.0f, (float)dice.getBlue() / 255.0f, flag1 ? 0.15f : 1.0f);
        }
        super.m_7392_((Entity)dice, noidea, partial, stack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(DiceEntity dice) {
        switch (dice.getDiceType()) {
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + dice.getDiceType());
            }
        }
        return D6_TEX;
    }

    private RenderType getRenderType(DiceEntity dice, DiceModel model, boolean flag1, boolean flag2) {
        ResourceLocation resourcelocation = this.getTextureLocation(dice);
        if (flag2) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (flag1) {
            return model.m_103119_(resourcelocation);
        }
        return this.minecraft.m_91314_((Entity)dice) ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }
}

