/*
 * Decompiled with CFR 0.152.
 */
package mrunknown404.dice.entity;

import java.awt.Color;
import mrunknown404.dice.registries.DiceRegistry;
import mrunknown404.dice.utils.DiceConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;

public class DiceEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private int r;
    private int g;
    private int b;
    private byte type;
    private byte rolled;
    private int life;

    public DiceEntity(EntityType<? extends Entity> type, Level level) {
        super(type, level);
    }

    public DiceEntity(Level world, Vec3 pos, Color color, byte type) {
        super((EntityType)DiceRegistry.DICE_ENTITY.get(), world);
        this.m_146884_(pos);
        this.type = type;
        this.rolled = (byte)(1 + this.f_19796_.m_188503_((int)type));
        this.r = color.getRed();
        this.g = color.getGreen();
        this.b = color.getBlue();
    }

    public void m_8119_() {
        double d0;
        super.m_8119_();
        ++this.life;
        if (this.life >= 20 * (Integer)DiceConfig.COMMON.diceExpireTime.get()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.15625, 0.0);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (!this.m_6084_()) {
            return;
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        Vec3 vec3 = this.m_20184_();
        float f = this.m_20192_() - 0.11111111f;
        FluidType fluidType = this.getMaxHeightFluidType();
        if (!fluidType.isAir() && !fluidType.isVanilla() && this.getFluidTypeHeight(fluidType) > (double)f) {
            this.m_20334_(vec3.f_82479_ * (double)0.99f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.99f);
        } else if (this.m_20069_() && this.getFluidTypeHeight((FluidType)ForgeMod.WATER_TYPE.get()) > (double)f) {
            this.m_20334_(vec3.f_82479_ * (double)0.99f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.99f);
        } else if (this.m_20077_() && this.getFluidTypeHeight((FluidType)ForgeMod.LAVA_TYPE.get()) > (double)f) {
            this.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
        } else if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        Level level = this.m_9236_();
        if (level.f_46443_) {
            this.f_19794_ = false;
        } else {
            boolean bl = this.f_19794_ = !this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82406_(1.0E-7));
            if (this.f_19794_) {
                this.m_20314_(this.m_20185_(), (this.m_20191_().f_82289_ + this.m_20191_().f_82292_) / 2.0, this.m_20189_());
            }
        }
        if (!this.m_20096_() || this.m_20184_().m_165925_() > (double)1.0E-5f || (this.f_19797_ + this.m_19879_()) % 4 == 0) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
            float f1 = 0.98f;
            if (this.m_20096_()) {
                BlockPos groundPos = this.m_20099_();
                f1 = this.m_9236_().m_8055_(groundPos).getFriction((LevelReader)this.m_9236_(), groundPos, (Entity)this) * 0.98f;
            }
            this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.98, (double)f1));
            if (this.m_20096_()) {
                Vec3 vec31 = this.m_20184_();
                if (vec31.f_82480_ < 0.0) {
                    this.m_20256_(vec31.m_82542_(1.0, -0.5, 1.0));
                }
            }
        }
        this.f_19812_ |= this.m_20073_();
        if (!level.f_46443_ && (d0 = this.m_20184_().m_82546_(vec3).m_82556_()) > 0.01) {
            this.f_19812_ = true;
        }
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_271807_() {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public void shoot(double p_37266_, double p_37267_, double p_37268_, float p_37269_, float p_37270_) {
        Vec3 vec3 = new Vec3(p_37266_, p_37267_, p_37268_).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.0172275 * (double)p_37270_), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)p_37270_), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)p_37270_)).m_82490_((double)p_37269_);
        this.m_20256_(vec3);
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)vec3.m_165924_()) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void shootFromRotation(Entity entity, float p_37253_, float p_37254_, float p_37255_, float p_37256_, float p_37257_) {
        this.shoot(-Mth.m_14031_((float)(p_37254_ * ((float)Math.PI / 180))) * Mth.m_14089_((float)(p_37253_ * ((float)Math.PI / 180))), -Mth.m_14031_((float)((p_37253_ + p_37255_) * ((float)Math.PI / 180))), Mth.m_14089_((float)(p_37254_ * ((float)Math.PI / 180))) * Mth.m_14089_((float)(p_37253_ * ((float)Math.PI / 180))), p_37256_, p_37257_);
        Vec3 vec3 = entity.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_, entity.m_20096_() ? 0.0 : vec3.f_82480_, vec3.f_82481_));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("R", this.r);
        tag.m_128405_("G", this.g);
        tag.m_128405_("B", this.b);
        tag.m_128344_("Type", this.type);
        tag.m_128344_("Rolled", this.rolled);
    }

    protected void m_7378_(CompoundTag tag) {
        this.r = tag.m_128425_("R", 3) ? tag.m_128451_("R") : 255;
        this.g = tag.m_128425_("G", 3) ? tag.m_128451_("G") : 255;
        this.b = tag.m_128425_("B", 3) ? tag.m_128451_("B") : 255;
        this.type = (byte)(tag.m_128425_("Type", 1) ? (int)tag.m_128445_("Type") : 6);
        this.rolled = tag.m_128425_("Rolled", 1) ? tag.m_128445_("Rolled") : (byte)(1 + this.f_19796_.m_188503_((int)this.type));
    }

    protected void m_8097_() {
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.r);
        buffer.writeInt(this.g);
        buffer.writeInt(this.b);
        buffer.writeByte((int)this.type);
        buffer.writeByte((int)this.rolled);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.r = additionalData.readInt();
        this.g = additionalData.readInt();
        this.b = additionalData.readInt();
        this.type = additionalData.readByte();
        this.rolled = additionalData.readByte();
    }

    public boolean m_6783_(double dist) {
        return dist > 1.0;
    }

    public int getRed() {
        return this.r;
    }

    public int getGreen() {
        return this.g;
    }

    public int getBlue() {
        return this.b;
    }

    public byte getDiceType() {
        return this.type;
    }

    public byte getRolled() {
        return this.rolled;
    }
}

