/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.util.SimpleBlockPredicate;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class RainforestCliffsVinesFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.m_8055_(pos).m_60734_() == Blocks.f_50493_ || world.m_8055_(pos).m_60734_() == Blocks.f_50440_ || world.m_8055_(pos).m_60734_() == Blocks.f_50069_ || world.m_8055_(pos).m_60734_() == Blocks.f_50352_ || world.m_8055_(pos).m_60734_() == Blocks.f_50334_ || world.m_8055_(pos).m_60734_() == Blocks.f_50122_ || world.m_8055_(pos).m_60734_() == Blocks.f_50228_;
    protected SimpleBlockPredicate replace = (world, pos) -> RainforestCliffsVinesFeature.isAir((LevelSimulatedReader)world, pos);
    int minHeight = 7;
    int maxHeight = 14;

    public RainforestCliffsVinesFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.m_159774_();
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        RandomSource rand = featurePlaceContext.m_225041_();
        BlockPos startPos = featurePlaceContext.m_159777_();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.m_159778_();
        while (startPos.m_123342_() >= world.m_141937_() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.m_7495_();
        }
        if (!this.placeOn.matches(world, startPos.m_7918_(2, 0, 2))) {
            return false;
        }
        for (int i = 0; i < 128; ++i) {
            BlockPos genPos = startPos.m_7918_(rand.m_188503_(4) - rand.m_188503_(4), rand.m_188503_(3) - rand.m_188503_(3), rand.m_188503_(4) - rand.m_188503_(4));
            if (!this.replace.matches(world, genPos)) continue;
            BlockState vineState = Blocks.f_50191_.m_49966_();
            ArrayList validDirections = Lists.newArrayList();
            for (Direction facing : Direction.values()) {
                if (facing == Direction.UP || facing == Direction.DOWN || !this.placeOn.matches(world, genPos.m_121945_(facing))) continue;
                validDirections.add(facing);
            }
            if (validDirections.isEmpty()) continue;
            Direction direction = (Direction)validDirections.get(rand.m_188503_(validDirections.size()));
            vineState = (BlockState)vineState.m_61124_((Property)VineBlock.m_57883_((Direction)direction), (Comparable)Boolean.valueOf(true));
            int targetHeight = this.minHeight + rand.m_188503_(this.maxHeight);
            for (int height = 0; height <= targetHeight; ++height) {
                BlockPos offsetPos = genPos.m_6625_(height);
                if (!this.replace.matches(world, offsetPos) || !vineState.m_60734_().m_7898_(vineState, (LevelReader)world, offsetPos)) {
                    return false;
                }
                world.m_7731_(offsetPos, vineState, 2);
            }
        }
        return true;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.m_5974_((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public static boolean isAir(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_);
    }
}

