/*
 * Decompiled with CFR 0.152.
 */
package doublemoon.mahjongcraft.game.mahjong.riichi;

import doublemoon.mahjongcraft.entity.MahjongScoringStickEntity;
import doublemoon.mahjongcraft.entity.MahjongTileEntity;
import doublemoon.mahjongcraft.entity.TileFacing;
import doublemoon.mahjongcraft.entity.TilePosition;
import doublemoon.mahjongcraft.game.GameBase;
import doublemoon.mahjongcraft.game.mahjong.riichi.MahjongGame;
import doublemoon.mahjongcraft.game.mahjong.riichi.model.ClaimTarget;
import doublemoon.mahjongcraft.game.mahjong.riichi.model.Fuuro;
import doublemoon.mahjongcraft.game.mahjong.riichi.model.Kakantsu;
import doublemoon.mahjongcraft.game.mahjong.riichi.model.MahjongRule;
import doublemoon.mahjongcraft.game.mahjong.riichi.model.MahjongTile;
import doublemoon.mahjongcraft.game.mahjong.riichi.model.ScoringStick;
import doublemoon.mahjongcraft.game.mahjong.riichi.player.MahjongPlayerBase;
import doublemoon.mahjongcraft.scheduler.server.ServerScheduler;
import doublemoon.mahjongcraft.util.DelayUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mahjong4j.GeneralSituation;
import org.mahjong4j.hands.Kantsu;
import org.mahjong4j.tile.Tile;
import org.mahjong4j.tile.TileType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\bJ\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\bJ\r\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0086@\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001d\u0010\u001aJ'\u0010!\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010#\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b%\u0010\u001aJ\u0015\u0010&\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b&\u0010\u001aJ\u0015\u0010'\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b'\u0010\u001aR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010(\u001a\u0004\b)\u0010*R\u001d\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120+8\u0006\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\u001d\u00100\u001a\b\u0012\u0004\u0012\u00020\u00120+8\u0006\u00a2\u0006\f\n\u0004\b0\u0010-\u001a\u0004\b1\u0010/R\u001d\u00102\u001a\b\u0012\u0004\u0012\u00020\u00120+8\u0006\u00a2\u0006\f\n\u0004\b2\u0010-\u001a\u0004\b3\u0010/R$\u00105\u001a\u00020\f2\u0006\u00104\u001a\u00020\f8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R\u001d\u00109\u001a\b\u0012\u0004\u0012\u00020\u00120+8\u0006\u00a2\u0006\f\n\u0004\b9\u0010-\u001a\u0004\b:\u0010/R\u0014\u0010<\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u00108R\u0014\u0010@\u001a\u00020=8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0011\u0010A\u001a\u00020=8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010?R\u0011\u0010B\u001a\u00020=8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010?R\u0011\u0010C\u001a\u00020=8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010?R\u0014\u0010G\u001a\u00020D8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0017\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00120H8F\u00a2\u0006\u0006\u001a\u0004\bI\u0010/R\u0017\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00120H8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010/R\u001a\u0010N\u001a\b\u0012\u0004\u0012\u00020D0H8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010/R\u001a\u0010P\u001a\b\u0012\u0004\u0012\u00020D0H8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010/R\u0011\u0010T\u001a\u00020Q8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010S\u00a8\u0006U"}, d2={"Ldoublemoon/mahjongcraft/game/mahjong/riichi/MahjongBoard;", "", "Ldoublemoon/mahjongcraft/game/mahjong/riichi/MahjongGame;", "game", "<init>", "(Ldoublemoon/mahjongcraft/game/mahjong/riichi/MahjongGame;)V", "", "flipDoraIndicators", "()V", "clear", "generateAllTilesAndSpawnWall", "assignDeadWall", "", "dicePoints", "assignWallAndHands", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Ldoublemoon/mahjongcraft/game/mahjong/riichi/player/MahjongPlayerBase;", "player", "Ldoublemoon/mahjongcraft/entity/MahjongTileEntity;", "lastTile", "sortHands", "(Ldoublemoon/mahjongcraft/game/mahjong/riichi/player/MahjongPlayerBase;Ldoublemoon/mahjongcraft/entity/MahjongTileEntity;)V", "openDoorPlayer", "sortDiscardedTilesForDisplay", "(Ldoublemoon/mahjongcraft/game/mahjong/riichi/player/MahjongPlayerBase;Ldoublemoon/mahjongcraft/game/mahjong/riichi/player/MahjongPlayerBase;)V", "sortFuuro", "(Ldoublemoon/mahjongcraft/game/mahjong/riichi/player/MahjongPlayerBase;)V", "drawRinshanTile", "(Ldoublemoon/mahjongcraft/game/mahjong/riichi/player/MahjongPlayerBase;)Ldoublemoon/mahjongcraft/entity/MahjongTileEntity;", "putRiichiStick", "index", "Ldoublemoon/mahjongcraft/entity/MahjongScoringStickEntity;", "stick", "moveStickTo", "(Ldoublemoon/mahjongcraft/game/mahjong/riichi/player/MahjongPlayerBase;ILdoublemoon/mahjongcraft/entity/MahjongScoringStickEntity;)V", "moveStickToLast", "(Ldoublemoon/mahjongcraft/game/mahjong/riichi/player/MahjongPlayerBase;Ldoublemoon/mahjongcraft/entity/MahjongScoringStickEntity;)V", "resortSticks", "addHonbaStick", "removeHonbaSticks", "Ldoublemoon/mahjongcraft/game/mahjong/riichi/MahjongGame;", "getGame", "()Ldoublemoon/mahjongcraft/game/mahjong/riichi/MahjongGame;", "", "allTiles", "Ljava/util/List;", "getAllTiles", "()Ljava/util/List;", "wall", "getWall", "deadWall", "getDeadWall", "value", "kanCount", "I", "getKanCount", "()I", "discards", "getDiscards", "getDiscardsCount", "discardsCount", "", "getNoFuuro", "()Z", "noFuuro", "isFirstRound", "isHoutei", "isSuufonRenda", "Lorg/mahjong4j/tile/Tile;", "getBakaze", "()Lorg/mahjong4j/tile/Tile;", "bakaze", "", "getDoraIndicators", "doraIndicators", "getUraDoraIndicators", "uraDoraIndicators", "getDoraList", "doraList", "getUraDoraList", "uraDoraList", "Lorg/mahjong4j/GeneralSituation;", "getGeneralSituation", "()Lorg/mahjong4j/GeneralSituation;", "generalSituation", "mahjongcraft-mc1.20.1"})
@SourceDebugExtension(value={"SMAP\nMahjongBoard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MahjongBoard.kt\ndoublemoon/mahjongcraft/game/mahjong/riichi/MahjongBoard\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,927:1\n1#2:928\n2632#3,3:929\n1557#3:932\n1628#3,3:933\n1557#3:936\n1628#3,3:937\n1863#3,2:940\n1863#3,2:942\n1863#3:944\n1557#3:945\n1628#3,3:946\n1864#3:949\n1872#3,3:950\n1863#3,2:953\n1872#3,2:955\n1863#3,2:957\n1874#3:959\n1010#3,2:960\n1872#3,3:962\n1872#3,3:965\n1863#3:968\n1872#3,3:969\n1864#3:972\n1053#3:973\n1872#3,3:974\n774#3:977\n865#3,2:978\n1863#3,2:980\n1863#3,2:982\n1062#3:984\n1863#3,2:985\n*S KotlinDebug\n*F\n+ 1 MahjongBoard.kt\ndoublemoon/mahjongcraft/game/mahjong/riichi/MahjongBoard\n*L\n75#1:929,3\n136#1:932\n136#1:933,3\n143#1:936\n143#1:937,3\n149#1:940,2\n178#1:942,2\n194#1:944\n202#1:945\n202#1:946,3\n194#1:949\n211#1:950,3\n265#1:953,2\n281#1:955,2\n287#1:957,2\n281#1:959\n405#1:960,2\n410#1:962,3\n518#1:965,3\n719#1:968\n722#1:969,3\n719#1:972\n890#1:973\n891#1:974,3\n921#1:977\n921#1:978,2\n921#1:980,2\n248#1:982,2\n648#1:984\n665#1:985,2\n*E\n"})
public final class MahjongBoard {
    @NotNull
    private final MahjongGame game;
    @NotNull
    private final List<MahjongTileEntity> allTiles;
    @NotNull
    private final List<MahjongTileEntity> wall;
    @NotNull
    private final List<MahjongTileEntity> deadWall;
    private int kanCount;
    @NotNull
    private final List<MahjongTileEntity> discards;

    public MahjongBoard(@NotNull MahjongGame game) {
        Intrinsics.checkNotNullParameter((Object)game, (String)"game");
        this.game = game;
        this.allTiles = new ArrayList();
        this.wall = new ArrayList();
        this.deadWall = new ArrayList();
        this.discards = new ArrayList();
    }

    @NotNull
    public final MahjongGame getGame() {
        return this.game;
    }

    @NotNull
    public final List<MahjongTileEntity> getAllTiles() {
        return this.allTiles;
    }

    @NotNull
    public final List<MahjongTileEntity> getWall() {
        return this.wall;
    }

    @NotNull
    public final List<MahjongTileEntity> getDeadWall() {
        return this.deadWall;
    }

    public final int getKanCount() {
        return this.kanCount;
    }

    @NotNull
    public final List<MahjongTileEntity> getDiscards() {
        return this.discards;
    }

    /*
     * WARNING - void declaration
     */
    private final int getDiscardsCount() {
        Iterable iterable = this.game.getPlayers();
        int n = 0;
        for (Object t : iterable) {
            void it;
            MahjongPlayerBase mahjongPlayerBase = (MahjongPlayerBase)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getDiscardedTiles().size();
            n = n2 + n3;
        }
        return n;
    }

    private final boolean getNoFuuro() {
        boolean bl;
        block3: {
            Iterable $this$none$iv = this.game.getPlayers();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    MahjongPlayerBase it = (MahjongPlayerBase)element$iv;
                    boolean bl2 = false;
                    if (!(it.getFuuroList().size() > 0)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean isFirstRound() {
        return this.getDiscardsCount() <= 4 && this.getNoFuuro();
    }

    public final boolean isHoutei() {
        return this.wall.size() <= 4;
    }

    public final boolean isSuufonRenda() {
        if (this.discards.size() < 4) {
            return false;
        }
        List discards = CollectionsKt.asReversedMutable(this.discards);
        MahjongTileEntity fonTile = (MahjongTileEntity)((Object)discards.get(0));
        if (fonTile.getMahjong4jTile().getType() != TileType.FONPAI) {
            return false;
        }
        int n = 4;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            if (((MahjongTileEntity)((Object)discards.get(it))).getCode() == fonTile.getCode()) continue;
            return false;
        }
        return true;
    }

    private final Tile getBakaze() {
        return this.game.getRound().getWind().getTile();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MahjongTileEntity> getDoraIndicators() {
        int n = this.kanCount + 1;
        ArrayList<MahjongTileEntity> arrayList = new ArrayList<MahjongTileEntity>(n);
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<MahjongTileEntity> arrayList2 = arrayList;
            boolean bl = false;
            int doraIndicatorIndex = (4 - it) * 2 + this.kanCount;
            arrayList2.add(this.deadWall.get(doraIndicatorIndex));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MahjongTileEntity> getUraDoraIndicators() {
        int n = this.kanCount + 1;
        ArrayList<MahjongTileEntity> arrayList = new ArrayList<MahjongTileEntity>(n);
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<MahjongTileEntity> arrayList2 = arrayList;
            boolean bl = false;
            int uraDoraIndicatorIndex = (4 - it) * 2 + 1 + this.kanCount;
            arrayList2.add(this.deadWall.get(uraDoraIndicatorIndex));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Tile> getDoraList() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getDoraIndicators();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MahjongTileEntity mahjongTileEntity = (MahjongTileEntity)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMahjongTile().getNextTile().getMahjong4jTile());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Tile> getUraDoraList() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getUraDoraIndicators();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MahjongTileEntity mahjongTileEntity = (MahjongTileEntity)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMahjongTile().getNextTile().getMahjong4jTile());
        }
        return (List)destination$iv$iv;
    }

    private final void flipDoraIndicators() {
        Iterable $this$forEach$iv = this.getDoraIndicators();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MahjongTileEntity it = (MahjongTileEntity)((Object)element$iv);
            boolean bl = false;
            if (it.getFacing() != TileFacing.UP) {
                it.setFacing(TileFacing.UP);
            }
            if (it.getInGameTilePosition() == TilePosition.OTHER) continue;
            it.setInGameTilePosition(TilePosition.OTHER);
        }
    }

    @NotNull
    public final GeneralSituation getGeneralSituation() {
        return new GeneralSituation(this.isFirstRound(), this.isHoutei(), this.getBakaze(), this.getDoraList(), this.getUraDoraList());
    }

    public final void clear() {
        this.kanCount = 0;
        this.discards.clear();
        this.wall.clear();
        this.deadWall.clear();
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.allTiles);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MahjongTileEntity it = (MahjongTileEntity)((Object)element$iv);
            boolean bl = false;
            if (it.method_31481()) continue;
            it.method_5650(class_1297.class_5529.field_26999);
        }
        this.allTiles.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void generateAllTilesAndSpawnWall() {
        class_243 class_2432;
        Object object;
        List<MahjongTileEntity> list;
        class_243 tableCenterPos = this.game.getTableCenterPos();
        class_3218 world = this.game.getWorld();
        List<MahjongTileEntity> $this$generateAllTilesAndSpawnWall_u24lambda_u2411 = list = this.allTiles;
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.shuffled((Iterable)(switch (WhenMappings.$EnumSwitchMapping$0[this.game.getRule().getRedFive().ordinal()]) {
            case 1 -> MahjongTile.Companion.getNormalWall();
            case 2 -> MahjongTile.Companion.getRedFive3Wall();
            case 3 -> MahjongTile.Companion.getRedFive4Wall();
            default -> throw new NoWhenBranchMatchedException();
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            MahjongTile it = (MahjongTile)element$iv;
            boolean bl2 = false;
            object = $this$generateAllTilesAndSpawnWall_u24lambda_u2411;
            Iterable iterable = this.game.getPlayers();
            TilePosition tilePosition = TilePosition.WALL;
            boolean bl3 = true;
            class_2338 class_23382 = this.game.getPos();
            int n = it.getCode();
            class_1937 class_19372 = (class_1937)world;
            boolean $i$f$map = false;
            void var22_25 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            class_2432 = $this$mapTo$iv$iv.iterator();
            while (class_2432.hasNext()) {
                void player;
                Object item$iv$iv = class_2432.next();
                MahjongPlayerBase mahjongPlayerBase = (MahjongPlayerBase)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(player.getUuid());
            }
            collection = (List)destination$iv$iv;
            TileFacing tileFacing = TileFacing.DOWN;
            boolean bl5 = this.game.getRule().getSpectate();
            Collection<String> collection2 = collection;
            TilePosition tilePosition2 = tilePosition;
            boolean bl6 = bl3;
            class_2338 class_23383 = class_23382;
            int n2 = n;
            class_1937 class_19373 = class_19372;
            object.add(new MahjongTileEntity(class_19373, n2, class_23383, bl6, tilePosition2, (List<String>)collection2, bl5, tileFacing));
        }
        List<MahjongTileEntity> $this$generateAllTilesAndSpawnWall_u24lambda_u2419 = list = this.wall;
        boolean bl7 = false;
        CollectionsKt.addAll((Collection)$this$generateAllTilesAndSpawnWall_u24lambda_u2419, (Iterable)this.allTiles);
        Iterable $this$forEachIndexed$iv = $this$generateAllTilesAndSpawnWall_u24lambda_u2419;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object = (MahjongTileEntity)((Object)item$iv);
            int index = n;
            boolean bl8 = false;
            double directionOffset = 1.0;
            int topOrBottom = 1 - index % 2;
            double yOffset = (double)((float)topOrBottom * 0.075f) + (topOrBottom == 1 ? 0.0025 : 0.0);
            double startingPos = 0.8062500320374966;
            int stackNum = index / 2 % 17;
            double stackWidth = (double)stackNum * 0.11500000447034836;
            switch (index / 34) {
                case 0: {
                    void tile;
                    class_243 $this$generateAllTilesAndSpawnWall_u24lambda_u2419_u24lambda_u2416_u24lambda_u2412 = class_2432 = tableCenterPos.method_1031(directionOffset, yOffset, -startingPos + stackWidth);
                    boolean bl9 = false;
                    tile.method_29495($this$generateAllTilesAndSpawnWall_u24lambda_u2419_u24lambda_u2416_u24lambda_u2412);
                    tile.method_36456(-90.0f);
                    break;
                }
                case 1: {
                    void tile;
                    class_243 $this$generateAllTilesAndSpawnWall_u24lambda_u2419_u24lambda_u2416_u24lambda_u2413 = class_2432 = tableCenterPos.method_1031(startingPos - stackWidth, yOffset, directionOffset);
                    boolean bl10 = false;
                    tile.method_29495($this$generateAllTilesAndSpawnWall_u24lambda_u2419_u24lambda_u2416_u24lambda_u2413);
                    tile.method_36456(0.0f);
                    break;
                }
                case 2: {
                    void tile;
                    class_243 $this$generateAllTilesAndSpawnWall_u24lambda_u2419_u24lambda_u2416_u24lambda_u2414 = class_2432 = tableCenterPos.method_1031(-directionOffset, yOffset, startingPos - stackWidth);
                    boolean bl11 = false;
                    tile.method_29495($this$generateAllTilesAndSpawnWall_u24lambda_u2419_u24lambda_u2416_u24lambda_u2414);
                    tile.method_36456(90.0f);
                    break;
                }
                default: {
                    void tile;
                    class_243 $this$generateAllTilesAndSpawnWall_u24lambda_u2419_u24lambda_u2416_u24lambda_u2415 = class_2432 = tableCenterPos.method_1031(-startingPos + stackWidth, yOffset, -directionOffset);
                    boolean bl12 = false;
                    tile.method_29495($this$generateAllTilesAndSpawnWall_u24lambda_u2419_u24lambda_u2416_u24lambda_u2415);
                    tile.method_36456(180.0f);
                }
            }
        }
        ServerScheduler.scheduleDelayAction$default(ServerScheduler.INSTANCE, 0L, () -> MahjongBoard.generateAllTilesAndSpawnWall$lambda$19$lambda$18($this$generateAllTilesAndSpawnWall_u24lambda_u2419, world), 1, null);
        GameBase gameBase = this.game;
        class_3414 class_34142 = class_3417.field_15197;
        Intrinsics.checkNotNullExpressionValue((Object)class_34142, (String)"ENTITY_ITEM_PICKUP");
        GameBase.DefaultImpls.playSound$default(gameBase, null, null, class_34142, null, 0.0f, 0.0f, 59, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void assignDeadWall() {
        List<MahjongTileEntity> $this$assignDeadWall_u24lambda_u2425 = this.deadWall;
        boolean bl = false;
        for (int index = 0; index < 14; ++index) {
            ((Collection)$this$assignDeadWall_u24lambda_u2425).add(CollectionsKt.last(this.wall));
            this.wall.removeLast();
        }
        CollectionsKt.reverse($this$assignDeadWall_u24lambda_u2425);
        Iterable $this$forEach$iv = $this$assignDeadWall_u24lambda_u2425;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MahjongTileEntity it = (MahjongTileEntity)((Object)element$iv);
            boolean bl2 = false;
            double gap = 0.05;
            class_2350 class_23502 = it.method_5735();
            switch (class_23502 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[class_23502.ordinal()]) {
                case 1: {
                    it.method_24203(it.method_23317(), it.method_23318(), it.method_23321() + gap);
                    break;
                }
                case 2: {
                    it.method_24203(it.method_23317() - gap, it.method_23318(), it.method_23321());
                    break;
                }
                case 3: {
                    it.method_24203(it.method_23317(), it.method_23318(), it.method_23321() - gap);
                    break;
                }
                case 4: {
                    it.method_24203(it.method_23317() + gap, it.method_23318(), it.method_23321());
                }
            }
        }
        class_2350 direction = ((MahjongTileEntity)((Object)CollectionsKt.last(this.deadWall))).method_5735();
        List it = CollectionsKt.reversed((Iterable)$this$assignDeadWall_u24lambda_u2425);
        boolean bl3 = false;
        Iterable $this$forEachIndexed$iv = it;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void mahjongTile;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MahjongTileEntity mahjongTileEntity = (MahjongTileEntity)((Object)item$iv);
            int index = n;
            boolean bl4 = false;
            void $this$assignDeadWall_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422 = mahjongTile;
            boolean bl5 = false;
            if ($this$assignDeadWall_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.method_5735() == direction) continue;
            $this$assignDeadWall_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.method_36456(direction.method_10144());
            if (index % 2 == 0) {
                Iterable $this$forEach$iv2 = it;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    MahjongTileEntity tile = (MahjongTileEntity)((Object)element$iv);
                    boolean bl6 = false;
                    class_2350 class_23503 = direction;
                    switch (class_23503 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[class_23503.ordinal()]) {
                        case 1: {
                            tile.method_24203(tile.method_23317(), tile.method_23318(), tile.method_23321() + (double)0.112500004f);
                            break;
                        }
                        case 2: {
                            tile.method_24203(tile.method_23317() - (double)0.112500004f, tile.method_23318(), tile.method_23321());
                            break;
                        }
                        case 3: {
                            tile.method_24203(tile.method_23317(), tile.method_23318(), tile.method_23321() - (double)0.112500004f);
                            break;
                        }
                        case 4: {
                            tile.method_24203(tile.method_23317() + (double)0.112500004f, tile.method_23318(), tile.method_23321());
                        }
                    }
                }
            }
            double posY = index % 2 == 0 ? ((MahjongTileEntity)((Object)it.get(0))).method_23318() : ((MahjongTileEntity)((Object)it.get(1))).method_23318();
            double offset = 0.11500000447034836 * (double)(index / 2);
            class_2350 class_23504 = direction;
            switch (class_23504 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[class_23504.ordinal()]) {
                case 1: {
                    mahjongTile.method_24203(((MahjongTileEntity)((Object)it.get(0))).method_23317(), posY, ((MahjongTileEntity)((Object)it.get(0))).method_23321() - offset);
                    break;
                }
                case 2: {
                    mahjongTile.method_24203(((MahjongTileEntity)((Object)it.get(0))).method_23317() + offset, posY, ((MahjongTileEntity)((Object)it.get(0))).method_23321());
                    break;
                }
                case 3: {
                    mahjongTile.method_24203(((MahjongTileEntity)((Object)it.get(0))).method_23317(), posY, ((MahjongTileEntity)((Object)it.get(0))).method_23321() + offset);
                    break;
                }
                case 4: {
                    mahjongTile.method_24203(((MahjongTileEntity)((Object)it.get(0))).method_23317() - offset, posY, ((MahjongTileEntity)((Object)it.get(0))).method_23321());
                }
            }
        }
        this.flipDoraIndicators();
    }

    @Nullable
    public final Object assignWallAndHands(int dicePoints, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(dicePoints, this, null){
            int I$0;
            int I$1;
            Object L$0;
            int label;
            final /* synthetic */ int $dicePoints;
            final /* synthetic */ MahjongBoard this$0;
            {
                this.$dicePoints = $dicePoints;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var19_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        directionIndex = 4 - (this.$dicePoints % 4 - 1 + this.this$0.getGame().getRound().getRound()) % 4;
                        startingStackIndex = 2 * this.$dicePoints;
                        dealer = this.this$0.getGame().getSeat().get(this.this$0.getGame().getRound().getRound());
                        var6_6 = this.this$0.getWall().size();
                        var7_9 = this.this$0;
                        var8_10 = new ArrayList<MahjongTileEntity>(var6_6);
                        var9_12 = 0;
                        while (var9_12 < var6_6) {
                            var11_18 = var10_15 = var9_12++;
                            var18_24 = var8_10;
                            $i$a$-MutableList-MahjongBoard$assignWallAndHands$2$newWall$1 = false;
                            tileIndex = (directionIndex * 34 + startingStackIndex + it) % var7_9.getWall().size();
                            var18_24.add(var7_9.getWall().get(tileIndex));
                        }
                        newWall = var8_10;
                        var6_7 = this.this$0.getGame().getSeat();
                        var7_9 = this.this$0;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            mjPlayer = (MahjongPlayerBase)element$iv;
                            $i$a$-forEach-MahjongBoard$assignWallAndHands$2$1 = false;
                            tileAmount = Intrinsics.areEqual((Object)mjPlayer, (Object)dealer) != false ? 14 : 13;
                            for (var14_26 = 0; var14_26 < tileAmount; ++var14_26) {
                                it = var14_26;
                                $i$a$-repeat-MahjongBoard$assignWallAndHands$2$1$1 = false;
                                tile = (MahjongTileEntity)newWall.removeFirst();
                                tile.method_5648(true);
                                Intrinsics.checkNotNull((Object)tile);
                                mjPlayer.drawTile(tile);
                                if (it == 13) {
                                    var7_9.sortHands(mjPlayer, tile);
                                    continue;
                                }
                                MahjongBoard.sortHands$default(var7_9, mjPlayer, null, 2, null);
                            }
                        }
                        this.this$0.getWall().clear();
                        CollectionsKt.addAll((Collection)this.this$0.getWall(), (Iterable)newWall);
                        var6_8 = 4;
                        var7_9 = this.this$0;
                        var8_11 = 0;
lbl48:
                        // 2 sources

                        while (var8_11 < var6_8) {
                            times = var8_11;
                            $i$a$-repeat-MahjongBoard$assignWallAndHands$2$2 = false;
                            if (var7_9.getGame().getSeat().size() != 0) {
                                seatIndex = (var7_9.getGame().getRound().getRound() + times) % 4;
                                $this$forEach$iv = var7_9.getGame().getSeat().get(seatIndex).getHands();
                                $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    it = (MahjongTileEntity)element$iv;
                                    $i$a$-forEach-MahjongBoard$assignWallAndHands$2$2$1 = false;
                                    it.method_5648(false);
                                }
                                v0 = var7_9.getGame();
                                v1 = class_3417.field_15197;
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"ENTITY_ITEM_PICKUP");
                                GameBase.DefaultImpls.playSound$default(v0, null, null, v1, null, 0.3f, 2.0f, 11, null);
                                this.L$0 = var7_9;
                                this.I$0 = var6_8;
                                this.I$1 = var8_11;
                                this.label = 1;
                                v2 = DelayUtilsKt.delayOnServer(250L, (Continuation<? super Unit>)this);
                                if (v2 == var19_2) {
                                    return var19_2;
                                }
                            }
                            ** GOTO lbl80
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-repeat-MahjongBoard$assignWallAndHands$2$2 = false;
                        var8_11 = this.I$1;
                        var6_8 = this.I$0;
                        var7_9 = (MahjongBoard)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl80:
                        // 2 sources

                        ++var8_11;
                        ** GOTO lbl48
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public final void sortHands(@NotNull MahjongPlayerBase player, @Nullable MahjongTileEntity lastTile) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.game.getSeat().contains(player)) {
            return;
        }
        int seatIndex = this.game.getSeat().indexOf(player);
        class_243 tableCenterPos = this.game.getTableCenterPos();
        MahjongPlayerBase $this$sortHands_u24lambda_u2433 = player;
        boolean bl = false;
        int tileAmount = $this$sortHands_u24lambda_u2433.getHands().size();
        if (player.getAutoArrangeHands()) {
            List<MahjongTileEntity> $this$sortBy$iv = $this$sortHands_u24lambda_u2433.getHands();
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        MahjongTileEntity it = (MahjongTileEntity)((Object)a);
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getMahjongTile().getSortOrder());
                        it = (MahjongTileEntity)((Object)b);
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getMahjongTile().getSortOrder()));
                    }
                });
            }
        }
        MahjongTileEntity mahjongTileEntity = lastTile;
        if (mahjongTileEntity != null) {
            MahjongTileEntity it = mahjongTileEntity;
            boolean bl2 = false;
            ((Collection)$this$sortHands_u24lambda_u2433.getHands()).remove((Object)it);
            ((Collection)$this$sortHands_u24lambda_u2433.getHands()).add(it);
        }
        Iterable $this$forEachIndexed$iv = $this$sortHands_u24lambda_u2433.getHands();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void hTile;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MahjongTileEntity mahjongTileEntity2 = (MahjongTileEntity)((Object)item$iv);
            int index = n;
            boolean bl3 = false;
            double directionOffset = 1.2250000089406967;
            double fuuroOffset = $this$sortHands_u24lambda_u2433.getFuuroList().size() < 3 ? 0.0 : ((double)$this$sortHands_u24lambda_u2433.getFuuroList().size() - 2.0) * (double)0.112500004f;
            double sticksOffset = $this$sortHands_u24lambda_u2433.getSticks().size() < 3 ? 0.0 : ((double)$this$sortHands_u24lambda_u2433.getSticks().size() - 2.0) * (double)0.0625f;
            double startingPos = ((double)((float)tileAmount * 0.112500004f) + (double)(tileAmount - 1) * 0.0025) / 2.0 + fuuroOffset + sticksOffset;
            double stackOffset = (double)index * 0.11500000447034836 + (Intrinsics.areEqual((Object)hTile, (Object)((Object)lastTile)) ? 0.0375 : 0.0);
            switch (seatIndex) {
                case 0: {
                    class_243 class_2432;
                    class_243 $this$sortHands_u24lambda_u2433_u24lambda_u2432_u24lambda_u2428 = class_2432 = tableCenterPos.method_1031(directionOffset, 0.0, startingPos - stackOffset);
                    boolean bl4 = false;
                    hTile.method_29495($this$sortHands_u24lambda_u2433_u24lambda_u2432_u24lambda_u2428);
                    hTile.method_36456(-90.0f);
                    break;
                }
                case 3: {
                    class_243 class_2432;
                    class_243 $this$sortHands_u24lambda_u2433_u24lambda_u2432_u24lambda_u2429 = class_2432 = tableCenterPos.method_1031(-startingPos + stackOffset, 0.0, directionOffset);
                    boolean bl5 = false;
                    hTile.method_29495($this$sortHands_u24lambda_u2433_u24lambda_u2432_u24lambda_u2429);
                    hTile.method_36456(0.0f);
                    break;
                }
                case 2: {
                    class_243 class_2432;
                    class_243 $this$sortHands_u24lambda_u2433_u24lambda_u2432_u24lambda_u2430 = class_2432 = tableCenterPos.method_1031(-directionOffset, 0.0, -startingPos + stackOffset);
                    boolean bl6 = false;
                    hTile.method_29495($this$sortHands_u24lambda_u2433_u24lambda_u2432_u24lambda_u2430);
                    hTile.method_36456(90.0f);
                    break;
                }
                default: {
                    class_243 class_2432;
                    class_243 $this$sortHands_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431 = class_2432 = tableCenterPos.method_1031(startingPos - stackOffset, 0.0, -directionOffset);
                    boolean bl7 = false;
                    hTile.method_29495($this$sortHands_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431);
                    hTile.method_36456(180.0f);
                }
            }
        }
    }

    public static /* synthetic */ void sortHands$default(MahjongBoard mahjongBoard, MahjongPlayerBase mahjongPlayerBase, MahjongTileEntity mahjongTileEntity, int n, Object object) {
        if ((n & 2) != 0) {
            mahjongTileEntity = null;
        }
        mahjongBoard.sortHands(mahjongPlayerBase, mahjongTileEntity);
    }

    /*
     * WARNING - void declaration
     */
    public final void sortDiscardedTilesForDisplay(@NotNull MahjongPlayerBase player, @NotNull MahjongPlayerBase openDoorPlayer) {
        MahjongTileEntity mahjongTileEntity;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)openDoorPlayer, (String)"openDoorPlayer");
        if (!this.game.getSeat().contains(player)) {
            return;
        }
        int seatIndex = this.game.getSeat().indexOf(player);
        class_243 tableCenterPos = this.game.getTableCenterPos();
        double halfWidthOfSixTiles = 0.3375f;
        double paddingFromCenter = halfWidthOfSixTiles + (double)0.075f + (double)0.0375f;
        double basicOffset = halfWidthOfSixTiles - 0.05625000223517418;
        double halfTileWidthAndHalfTileHeight = 0.13125000894069672;
        class_243 startingPos = switch (seatIndex) {
            case 0 -> tableCenterPos.method_1031(paddingFromCenter, 0.0, basicOffset);
            case 3 -> tableCenterPos.method_1031(-basicOffset, 0.0, paddingFromCenter);
            case 2 -> tableCenterPos.method_1031(-paddingFromCenter, 0.0, -basicOffset);
            default -> tableCenterPos.method_1031(basicOffset, 0.0, -paddingFromCenter);
        };
        class_243 tileOffset = switch (seatIndex) {
            case 0 -> new class_243(0.0, 0.0, -0.11250000447034836);
            case 3 -> new class_243(0.11250000447034836, 0.0, 0.0);
            case 2 -> new class_243(0.0, 0.0, 0.11250000447034836);
            default -> new class_243(-0.11250000447034836, 0.0, 0.0);
        };
        class_243 riichiTileOffset = switch (seatIndex) {
            case 0 -> new class_243(0.0, 0.0, -halfTileWidthAndHalfTileHeight);
            case 3 -> new class_243(halfTileWidthAndHalfTileHeight, 0.0, 0.0);
            case 2 -> new class_243(0.0, 0.0, halfTileWidthAndHalfTileHeight);
            default -> new class_243(-halfTileWidthAndHalfTileHeight, 0.0, 0.0);
        };
        class_243 lineOffset = switch (seatIndex) {
            case 0 -> new class_243(0.15250000596046448, 0.0, 0.0);
            case 3 -> new class_243(0.0, 0.0, 0.15250000596046448);
            case 2 -> new class_243(-0.15250000596046448, 0.0, 0.0);
            default -> new class_243(0.0, 0.0, -0.15250000596046448);
        };
        class_243 smallGapOffset = switch (seatIndex) {
            case 0 -> new class_243(0.0, 0.0, -0.0025);
            case 3 -> new class_243(0.0025, 0.0, 0.0);
            case 2 -> new class_243(0.0, 0.0, 0.0025);
            default -> new class_243(-0.0025, 0.0, 0.0);
        };
        float tileRot = switch (seatIndex) {
            case 0 -> -90.0f;
            case 3 -> 0.0f;
            case 2 -> 90.0f;
            default -> 180.0f;
        };
        class_243 nowPos = null;
        nowPos = startingPos;
        MahjongTileEntity mahjongTileEntity2 = player.getRiichiSengenTile();
        if (mahjongTileEntity2 != null) {
            MahjongTileEntity it = mahjongTileEntity2;
            boolean bl = false;
            if (!player.getDiscardedTilesForDisplay().contains((Object)it)) {
                Object v7;
                block40: {
                    int indexOfRiichiSengenTile = player.getDiscardedTiles().indexOf((Object)it);
                    List<MahjongTileEntity> tiles = player.getDiscardedTiles();
                    boolean bl2 = false;
                    Iterable iterable = tiles;
                    for (Object t : iterable) {
                        MahjongTileEntity tile = (MahjongTileEntity)((Object)t);
                        boolean bl3 = false;
                        if (!(tiles.indexOf((Object)tile) > indexOfRiichiSengenTile)) continue;
                        v7 = t;
                        break block40;
                    }
                    v7 = null;
                }
                mahjongTileEntity = v7;
            } else {
                mahjongTileEntity = it;
            }
        } else {
            mahjongTileEntity = null;
        }
        MahjongTileEntity riichiSengenTile = mahjongTileEntity;
        Iterable $this$forEachIndexed$iv = player.getDiscardedTilesForDisplay();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void tileEntity;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MahjongTileEntity bl2 = (MahjongTileEntity)((Object)item$iv);
            int index = n;
            boolean bl = false;
            boolean firstTileInThisLine = index % 6 == 0;
            boolean isRiichiTile = Intrinsics.areEqual((Object)tileEntity, (Object)((Object)riichiSengenTile));
            boolean lastTileIsRiichiTile = index == 0 ? false : Intrinsics.areEqual((Object)((Object)player.getDiscardedTilesForDisplay().get(index - 1)), (Object)((Object)riichiSengenTile));
            int lineCount = index / 6;
            if (lineCount > 0 && firstTileInThisLine && (!Intrinsics.areEqual((Object)openDoorPlayer, (Object)player) || index < 18)) {
                nowPos = startingPos;
                int n2 = 0;
                while (n2 < lineCount) {
                    int it = n2++;
                    boolean bl4 = false;
                    nowPos = nowPos.method_1019(lineOffset);
                }
            }
            nowPos = firstTileInThisLine ? (isRiichiTile ? nowPos.method_1019(riichiTileOffset).method_1020(tileOffset) : nowPos) : (isRiichiTile || lastTileIsRiichiTile ? nowPos.method_1019(riichiTileOffset) : nowPos.method_1019(tileOffset));
            nowPos = firstTileInThisLine ? nowPos : nowPos.method_1019(smallGapOffset);
            float yRot = isRiichiTile ? tileRot - (float)90 : tileRot;
            tileEntity.method_5808(nowPos.field_1352, nowPos.field_1351, nowPos.field_1350, yRot, 0.0f);
            tileEntity.setFacing(TileFacing.UP);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sortFuuro(@NotNull MahjongPlayerBase player) {
        class_243 class_2432;
        MahjongScoringStickEntity mahjongScoringStickEntity;
        class_243 it;
        int seatIndex;
        block61: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (!this.game.getSeat().contains(player)) {
                return;
            }
            seatIndex = this.game.getSeat().indexOf(player);
            class_243 tableCenterPos = this.game.getTableCenterPos();
            double halfTableLengthNoBorder = 1.4375;
            double halfHeightOfTile = 0.075f;
            it = switch (seatIndex) {
                case 0 -> tableCenterPos.method_1031(halfTableLengthNoBorder - halfHeightOfTile, 0.0, -halfTableLengthNoBorder);
                case 3 -> tableCenterPos.method_1031(halfTableLengthNoBorder, 0.0, halfTableLengthNoBorder - halfHeightOfTile);
                case 2 -> tableCenterPos.method_1031(-halfTableLengthNoBorder + halfHeightOfTile, 0.0, halfTableLengthNoBorder);
                default -> tableCenterPos.method_1031(-halfTableLengthNoBorder, 0.0, -halfTableLengthNoBorder + halfHeightOfTile);
            };
            boolean bl = false;
            List<MahjongScoringStickEntity> list = player.getSticks();
            ListIterator<MahjongScoringStickEntity> listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                MahjongScoringStickEntity mahjongScoringStickEntity2;
                MahjongScoringStickEntity stick = mahjongScoringStickEntity2 = listIterator.previous();
                boolean bl2 = false;
                if (!(player.getSticks().indexOf((Object)stick) < 5)) continue;
                mahjongScoringStickEntity = mahjongScoringStickEntity2;
                break block61;
            }
            mahjongScoringStickEntity = null;
        }
        MahjongScoringStickEntity mahjongScoringStickEntity3 = mahjongScoringStickEntity;
        if (mahjongScoringStickEntity3 == null) {
            class_2432 = it;
        } else {
            MahjongScoringStickEntity lastStickOfFirstStack = mahjongScoringStickEntity3;
            class_243 stickPos = lastStickOfFirstStack.method_19538();
            class_243 offset = stickPos.method_1020(it);
            double halfDepthOfStick = 0.03125;
            class_243 pos = switch (seatIndex) {
                case 0 -> it.method_1019(offset.method_18805(0.0, 0.0, 1.0));
                case 3 -> it.method_1019(offset.method_18805(1.0, 0.0, 0.0));
                case 2 -> it.method_1019(offset.method_18805(0.0, 0.0, 1.0));
                default -> it.method_1019(offset.method_18805(1.0, 0.0, 0.0));
            };
            switch (seatIndex) {
                case 0: {
                    class_2432 = pos.method_1031(0.0, 0.0, halfDepthOfStick);
                    break;
                }
                case 3: {
                    class_2432 = pos.method_1031(-halfDepthOfStick, 0.0, 0.0);
                    break;
                }
                case 2: {
                    class_2432 = pos.method_1031(0.0, 0.0, -halfDepthOfStick);
                    break;
                }
                default: {
                    class_2432 = pos.method_1031(halfDepthOfStick, 0.0, 0.0);
                }
            }
        }
        class_243 startingPos = class_2432;
        double tileGap = 0.0025;
        class_243 verticalTileOffset = switch (seatIndex) {
            case 0 -> new class_243(0.0, 0.0, 0.11250000447034836 + tileGap);
            case 3 -> new class_243(-0.11250000447034836 - tileGap, 0.0, 0.0);
            case 2 -> new class_243(0.0, 0.0, -0.11250000447034836 - tileGap);
            default -> new class_243(0.11250000447034836 + tileGap, 0.0, 0.0);
        };
        class_243 halfVerticalTileOffset = switch (seatIndex) {
            case 0 -> verticalTileOffset.method_18805(1.0, 1.0, 0.5);
            case 3 -> verticalTileOffset.method_18805(0.5, 1.0, 1.0);
            case 2 -> verticalTileOffset.method_18805(1.0, 1.0, 0.5);
            default -> verticalTileOffset.method_18805(0.5, 1.0, 1.0);
        };
        class_243 horizontalTileOffset = switch (seatIndex) {
            case 0 -> new class_243(0.0, 0.0, (double)0.15f + tileGap);
            case 3 -> new class_243((double)-0.15f - tileGap, 0.0, 0.0);
            case 2 -> new class_243(0.0, 0.0, (double)-0.15f - tileGap);
            default -> new class_243((double)0.15f + tileGap, 0.0, 0.0);
        };
        class_243 halfHorizontalTileOffset = switch (seatIndex) {
            case 0 -> horizontalTileOffset.method_18805(1.0, 1.0, 0.5);
            case 3 -> horizontalTileOffset.method_18805(0.5, 1.0, 1.0);
            case 2 -> horizontalTileOffset.method_18805(1.0, 1.0, 0.5);
            default -> horizontalTileOffset.method_18805(0.5, 1.0, 1.0);
        };
        class_243 kakanOffset = switch (seatIndex) {
            case 0 -> new class_243(-0.11250000447034836 - tileGap, 0.0, 0.0);
            case 3 -> new class_243(0.0, 0.0, -0.11250000447034836 - tileGap);
            case 2 -> new class_243(0.11250000447034836 + tileGap, 0.0, 0.0);
            default -> new class_243(0.0, 0.0, 0.11250000447034836 + tileGap);
        };
        double halfGapBetweenHeightAndWidth = 0.01875f;
        class_243 horizontalTileGravityOffset = switch (seatIndex) {
            case 0 -> new class_243(halfGapBetweenHeightAndWidth, 0.0, 0.0);
            case 3 -> new class_243(0.0, 0.0, halfGapBetweenHeightAndWidth);
            case 2 -> new class_243(-halfGapBetweenHeightAndWidth, 0.0, 0.0);
            default -> new class_243(0.0, 0.0, -halfGapBetweenHeightAndWidth);
        };
        float tileRot = switch (seatIndex) {
            case 0 -> -90.0f;
            case 3 -> 0.0f;
            case 2 -> 90.0f;
            default -> 180.0f;
        };
        Ref.ObjectRef nowPos = new Ref.ObjectRef();
        nowPos.element = startingPos;
        Ref.IntRef tileCount = new Ref.IntRef();
        Ref.ObjectRef lastTile = new Ref.ObjectRef();
        Ref.ObjectRef lastClaimTile = new Ref.ObjectRef();
        Iterable $this$forEach$iv = player.getFuuroList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Fuuro fuuro = (Fuuro)element$iv;
            boolean bl = false;
            if (fuuro.getMentsu() instanceof Kantsu && fuuro.getClaimTarget() == ClaimTarget.SELF) {
                Iterable $this$forEachIndexed$iv = fuuro.getTileMjEntities();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void tileMjEntity;
                    boolean isLastTileHorizontal;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    MahjongTileEntity mahjongTileEntity = (MahjongTileEntity)((Object)item$iv);
                    int index = n;
                    boolean bl3 = false;
                    boolean bl4 = isLastTileHorizontal = lastTile.element != null && lastClaimTile.element != null && Intrinsics.areEqual((Object)lastTile.element, (Object)lastClaimTile.element);
                    nowPos.element = tileCount.element == 0 ? ((class_243)nowPos.element).method_1019(halfVerticalTileOffset) : (isLastTileHorizontal ? ((class_243)nowPos.element).method_1019(halfHorizontalTileOffset).method_1019(halfVerticalTileOffset) : ((class_243)nowPos.element).method_1019(verticalTileOffset));
                    tileMjEntity.method_5808(((class_243)nowPos.element).field_1352, ((class_243)nowPos.element).field_1351, ((class_243)nowPos.element).field_1350, tileRot, 0.0f);
                    tileMjEntity.setFacing(switch (index) {
                        case 1, 2 -> TileFacing.UP;
                        default -> TileFacing.DOWN;
                    });
                    lastTile.element = tileMjEntity;
                    int n2 = tileCount.element;
                    tileCount.element = n2 + 1;
                }
                continue;
            }
            MahjongBoard.sortFuuro$placeEachTile((Ref.ObjectRef<MahjongTileEntity>)lastTile, (Ref.ObjectRef<MahjongTileEntity>)lastClaimTile, (Ref.ObjectRef<class_243>)nowPos, tileCount, halfHorizontalTileOffset, halfVerticalTileOffset, horizontalTileOffset, verticalTileOffset, horizontalTileGravityOffset, tileRot, kakanOffset, fuuro);
        }
    }

    @NotNull
    public final MahjongTileEntity drawRinshanTile(@NotNull MahjongPlayerBase player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        MahjongTileEntity tile = this.kanCount % 2 == 0 ? this.deadWall.get(this.deadWall.size() - 2) : this.deadWall.get(this.deadWall.size() - 1);
        MahjongTileEntity lastWallTile = this.wall.removeLast();
        class_2350 direction = ((MahjongTileEntity)((Object)CollectionsKt.last(this.deadWall))).method_5735();
        MahjongTileEntity baseTile = this.deadWall.get(1);
        class_243 basePos = baseTile.method_19538();
        class_2350 class_23502 = direction;
        class_243 tilePos = switch (class_23502 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[class_23502.ordinal()]) {
            case 1 -> basePos.method_1031(0.0, 0.0, -0.11250000447034836);
            case 2 -> basePos.method_1031(0.11250000447034836, 0.0, 0.0);
            case 3 -> basePos.method_1031(0.0, 0.0, 0.11250000447034836);
            case 4 -> basePos.method_1031(-0.11250000447034836, 0.0, 0.0);
            default -> basePos;
        };
        lastWallTile.method_29495(tilePos);
        lastWallTile.method_36456(direction.method_10144());
        Intrinsics.checkNotNull((Object)((Object)lastWallTile));
        this.deadWall.add(0, lastWallTile);
        ((Collection)this.deadWall).remove((Object)tile);
        int n = this.kanCount;
        this.kanCount = n + 1;
        this.flipDoraIndicators();
        player.drawTile(tile);
        if (this.kanCount % 2 == 1) {
            MahjongTileEntity nowLastWallTile = (MahjongTileEntity)((Object)CollectionsKt.last(this.wall));
            nowLastWallTile.method_29495(nowLastWallTile.method_19538().method_1031(0.0, (double)-0.075f, 0.0));
        }
        return tile;
    }

    public final void putRiichiStick(@NotNull MahjongPlayerBase player) {
        MahjongScoringStickEntity mahjongScoringStickEntity;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.game.getSeat().contains(player)) {
            return;
        }
        int seatIndex = this.game.getSeat().indexOf(player);
        class_243 tableCenterPos = this.game.getTableCenterPos();
        double halfWidthOfSixTiles = 0.3375f;
        double paddingFromCenter = halfWidthOfSixTiles - 0.03125;
        class_243 stickPos = switch (seatIndex) {
            case 0 -> tableCenterPos.method_1031(paddingFromCenter, 0.0, 0.0);
            case 3 -> tableCenterPos.method_1031(0.0, 0.0, paddingFromCenter);
            case 2 -> tableCenterPos.method_1031(-paddingFromCenter, 0.0, 0.0);
            default -> tableCenterPos.method_1031(0.0, 0.0, -paddingFromCenter);
        };
        float stickYaw = switch (seatIndex) {
            case 0 -> -90.0f;
            case 3 -> 0.0f;
            case 2 -> 90.0f;
            default -> 180.0f;
        };
        Collection collection = player.getSticks();
        MahjongScoringStickEntity $this$putRiichiStick_u24lambda_u2447 = mahjongScoringStickEntity = new MahjongScoringStickEntity(null, (class_1937)this.game.getWorld(), 1, null);
        boolean bl = false;
        $this$putRiichiStick_u24lambda_u2447.setCode(ScoringStick.P1000.getCode());
        $this$putRiichiStick_u24lambda_u2447.setGameBlockPos(this.game.getPos());
        $this$putRiichiStick_u24lambda_u2447.setSpawnedByGame(true);
        $this$putRiichiStick_u24lambda_u2447.method_29495(stickPos);
        $this$putRiichiStick_u24lambda_u2447.method_36456(stickYaw);
        ServerScheduler.scheduleDelayAction$default(ServerScheduler.INSTANCE, 0L, () -> MahjongBoard.putRiichiStick$lambda$47$lambda$46($this$putRiichiStick_u24lambda_u2447), 1, null);
        collection.add(mahjongScoringStickEntity);
    }

    private final void moveStickTo(MahjongPlayerBase player, int index, MahjongScoringStickEntity stick) {
        if (!this.game.getSeat().contains(player)) {
            return;
        }
        int seatIndex = this.game.getSeat().indexOf(player);
        class_243 tableCenterPos = this.game.getTableCenterPos();
        double halfTableLengthNoBorder = 1.4375;
        double halfWidthOfStick = 0.2f;
        double halfDepthOfStick = 0.03125;
        class_243 startingPos = switch (seatIndex) {
            case 0 -> tableCenterPos.method_1031(halfTableLengthNoBorder - halfWidthOfStick, 0.0, -halfTableLengthNoBorder + halfDepthOfStick);
            case 3 -> tableCenterPos.method_1031(halfTableLengthNoBorder - halfDepthOfStick, 0.0, halfTableLengthNoBorder - halfWidthOfStick);
            case 2 -> tableCenterPos.method_1031(-halfTableLengthNoBorder + halfWidthOfStick, 0.0, halfTableLengthNoBorder - halfDepthOfStick);
            default -> tableCenterPos.method_1031(-halfTableLengthNoBorder + halfDepthOfStick, 0.0, -halfTableLengthNoBorder + halfWidthOfStick);
        };
        double stickGap = 0.0025;
        class_243 stickOffset = switch (seatIndex) {
            case 0 -> new class_243(0.0, 0.0, (double)0.0625f + stickGap);
            case 3 -> new class_243((double)-0.0625f - stickGap, 0.0, 0.0);
            case 2 -> new class_243(0.0, 0.0, (double)-0.0625f - stickGap);
            default -> new class_243((double)0.0625f + stickGap, 0.0, 0.0);
        };
        class_243 stackOffset = new class_243(0.0, (double)0.0125f + stickGap, 0.0);
        float stickYaw = (switch (seatIndex) {
            case 0 -> -90.0f;
            case 3 -> 0.0f;
            case 2 -> 90.0f;
            default -> 180.0f;
        }) - 90.0f;
        double stackIndex = index / 5;
        double stickIndex = index % 5;
        class_243 offsetXZ = stickOffset.method_18805(stickIndex, stickIndex, stickIndex);
        class_243 offsetY = stackOffset.method_18805(stackIndex, stackIndex, stackIndex);
        class_243 pos = startingPos.method_1019(offsetXZ).method_1019(offsetY);
        stick.method_36456(stickYaw);
        stick.method_29495(pos);
    }

    private final void moveStickToLast(MahjongPlayerBase player, MahjongScoringStickEntity stick) {
        int n = CollectionsKt.getLastIndex(player.getSticks()) + 1;
        this.moveStickTo(player, n, stick);
    }

    /*
     * WARNING - void declaration
     */
    public final void resortSticks(@NotNull MahjongPlayerBase player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$sortedBy$iv = player.getSticks();
        boolean $i$f$sortedBy = false;
        Iterable $this$forEachIndexed$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MahjongScoringStickEntity it = (MahjongScoringStickEntity)((Object)a);
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getCode());
                it = (MahjongScoringStickEntity)((Object)b);
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getCode()));
            }
        });
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void stick;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MahjongScoringStickEntity mahjongScoringStickEntity = (MahjongScoringStickEntity)((Object)item$iv);
            int index = n;
            boolean bl = false;
            this.moveStickTo(player, index, (MahjongScoringStickEntity)stick);
        }
    }

    public final void addHonbaStick(@NotNull MahjongPlayerBase player) {
        MahjongScoringStickEntity mahjongScoringStickEntity;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.game.getSeat().contains(player)) {
            return;
        }
        Collection collection = player.getSticks();
        MahjongScoringStickEntity $this$addHonbaStick_u24lambda_u2451 = mahjongScoringStickEntity = new MahjongScoringStickEntity(null, (class_1937)this.game.getWorld(), 1, null);
        boolean bl = false;
        $this$addHonbaStick_u24lambda_u2451.setCode(ScoringStick.P100.getCode());
        $this$addHonbaStick_u24lambda_u2451.setGameBlockPos(this.game.getPos());
        $this$addHonbaStick_u24lambda_u2451.setSpawnedByGame(true);
        this.moveStickToLast(player, $this$addHonbaStick_u24lambda_u2451);
        ServerScheduler.scheduleDelayAction$default(ServerScheduler.INSTANCE, 0L, () -> MahjongBoard.addHonbaStick$lambda$51$lambda$50($this$addHonbaStick_u24lambda_u2451), 1, null);
        collection.add(mahjongScoringStickEntity);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeHonbaSticks(@NotNull MahjongPlayerBase player) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.game.getSeat().contains(player)) {
            return;
        }
        Iterable $this$filter$iv = player.getSticks();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MahjongScoringStickEntity it = (MahjongScoringStickEntity)((Object)element$iv$iv);
            boolean bl = false;
            if (!(it.getScoringStick() == ScoringStick.P100)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MahjongScoringStickEntity it = (MahjongScoringStickEntity)((Object)element$iv);
            boolean bl = false;
            it.method_5650(class_1297.class_5529.field_26999);
            ((Collection)player.getSticks()).remove((Object)it);
        }
        this.resortSticks(player);
    }

    private static final Unit generateAllTilesAndSpawnWall$lambda$19$lambda$18(List $this_apply, class_3218 $world) {
        Iterable $this$forEach$iv = $this_apply;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MahjongTileEntity it = (MahjongTileEntity)((Object)element$iv);
            boolean bl = false;
            $world.method_8649((class_1297)it);
        }
        return Unit.INSTANCE;
    }

    private static final void sortFuuro$placeEachTile(Ref.ObjectRef<MahjongTileEntity> lastTile, Ref.ObjectRef<MahjongTileEntity> lastClaimTile, Ref.ObjectRef<class_243> nowPos, Ref.IntRef tileCount, class_243 halfHorizontalTileOffset, class_243 halfVerticalTileOffset, class_243 horizontalTileOffset, class_243 verticalTileOffset, class_243 horizontalTileGravityOffset, float tileRot, class_243 kakanOffset, Fuuro fuuro) {
        block16: {
            List list;
            boolean isKakan = fuuro.getMentsu() instanceof Kakantsu;
            if (isKakan) {
                list = CollectionsKt.toMutableList((Collection)fuuro.getTileMjEntities());
            } else {
                Iterable $this$sortedByDescending$iv = fuuro.getTileMjEntities();
                boolean $i$f$sortedByDescending = false;
                list = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        MahjongTileEntity it = (MahjongTileEntity)((Object)b);
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getMahjongTile().getSortOrder());
                        it = (MahjongTileEntity)((Object)a);
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getMahjongTile().getSortOrder()));
                    }
                }));
            }
            List tiles = list;
            MahjongTileEntity kakanTile = isKakan ? (MahjongTileEntity)((Object)tiles.removeLast()) : null;
            ((Collection)tiles).remove((Object)fuuro.getClaimTile());
            switch (WhenMappings.$EnumSwitchMapping$2[fuuro.getClaimTarget().ordinal()]) {
                case 1: {
                    tiles.add(0, fuuro.getClaimTile());
                    break;
                }
                case 2: {
                    tiles.add(fuuro.getClaimTile());
                    break;
                }
                case 3: {
                    tiles.add(1, fuuro.getClaimTile());
                }
            }
            Iterable $this$forEach$iv = tiles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                float f;
                class_243 pos;
                boolean isLastTileHorizontal;
                MahjongTileEntity it = (MahjongTileEntity)((Object)element$iv);
                boolean bl = false;
                boolean isClaimTile = Intrinsics.areEqual((Object)((Object)it), (Object)((Object)fuuro.getClaimTile()));
                boolean bl2 = isLastTileHorizontal = lastTile.element != null && lastClaimTile.element != null && Intrinsics.areEqual((Object)lastTile.element, (Object)lastClaimTile.element);
                nowPos.element = tileCount.element == 0 ? (isClaimTile ? ((class_243)nowPos.element).method_1019(halfHorizontalTileOffset) : ((class_243)nowPos.element).method_1019(halfVerticalTileOffset)) : (isClaimTile || isLastTileHorizontal ? (isClaimTile && isLastTileHorizontal ? ((class_243)nowPos.element).method_1019(horizontalTileOffset) : ((class_243)nowPos.element).method_1019(halfHorizontalTileOffset).method_1019(halfVerticalTileOffset)) : ((class_243)nowPos.element).method_1019(verticalTileOffset));
                class_243 class_2432 = pos = !isClaimTile ? (class_243)nowPos.element : ((class_243)nowPos.element).method_1019(horizontalTileGravityOffset);
                if (Intrinsics.areEqual((Object)((Object)it), (Object)((Object)fuuro.getClaimTile()))) {
                    switch (WhenMappings.$EnumSwitchMapping$2[fuuro.getClaimTarget().ordinal()]) {
                        case 1: {
                            f = tileRot + (float)90;
                            break;
                        }
                        case 2: {
                            f = tileRot - (float)90;
                            break;
                        }
                        case 3: {
                            f = tileRot + (float)90;
                            break;
                        }
                        default: {
                            f = tileRot;
                            break;
                        }
                    }
                } else {
                    f = tileRot;
                }
                float yRot = f;
                it.method_5808(pos.field_1352, pos.field_1351, pos.field_1350, yRot, 0.0f);
                it.setFacing(TileFacing.UP);
                lastTile.element = it;
                if (isClaimTile) {
                    lastClaimTile.element = it;
                }
                int n = tileCount.element;
                tileCount.element = n + 1;
            }
            MahjongTileEntity mahjongTileEntity = kakanTile;
            if (mahjongTileEntity == null) break block16;
            MahjongTileEntity it = mahjongTileEntity;
            boolean bl = false;
            MahjongTileEntity claimTile = fuuro.getClaimTile();
            class_243 claimTilePos = fuuro.getClaimTile().method_19538();
            class_243 pos = claimTilePos.method_1019(kakanOffset);
            it.method_5808(pos.field_1352, pos.field_1351, pos.field_1350, claimTile.method_36454(), 0.0f);
            it.setFacing(TileFacing.UP);
        }
    }

    private static final Unit putRiichiStick$lambda$47$lambda$46(MahjongScoringStickEntity $this_apply) {
        $this_apply.method_37908().method_8649((class_1297)$this_apply);
        return Unit.INSTANCE;
    }

    private static final Unit addHonbaStick$lambda$51$lambda$50(MahjongScoringStickEntity $this_apply) {
        $this_apply.method_37908().method_8649((class_1297)$this_apply);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[MahjongRule.RedFive.values().length];
            try {
                nArray[MahjongRule.RedFive.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MahjongRule.RedFive.THREE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MahjongRule.RedFive.FOUR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[class_2350.values().length];
            try {
                nArray[class_2350.field_11034.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_2350.field_11035.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_2350.field_11039.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_2350.field_11043.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ClaimTarget.values().length];
            try {
                nArray[ClaimTarget.RIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClaimTarget.LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClaimTarget.ACROSS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

