/*
 * Decompiled with CFR 0.152.
 */
package doublemoon.mahjongcraft.client.render;

import doublemoon.mahjongcraft.MahjongCraftClient;
import doublemoon.mahjongcraft.block.MahjongTable;
import doublemoon.mahjongcraft.block.enums.MahjongTablePart;
import doublemoon.mahjongcraft.blockentity.MahjongTableBlockEntity;
import doublemoon.mahjongcraft.game.GameStatus;
import doublemoon.mahjongcraft.game.mahjong.riichi.model.MahjongRound;
import doublemoon.mahjongcraft.game.mahjong.riichi.model.Wind;
import doublemoon.mahjongcraft.util.RenderHelper;
import doublemoon.mahjongcraft.util.TextUtilsKt;
import io.github.cottonmc.cotton.gui.widget.data.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J?\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0015R\u001c\u0010\u0019\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Ldoublemoon/mahjongcraft/client/render/MahjongTableBlockEntityRenderer;", "Lnet/minecraft/class_827;", "Ldoublemoon/mahjongcraft/blockentity/MahjongTableBlockEntity;", "Lnet/minecraft/class_5614$class_5615;", "context", "<init>", "(Lnet/minecraft/class_5614$class_5615;)V", "blockEntity", "", "tickDelta", "Lnet/minecraft/class_4587;", "matrices", "Lnet/minecraft/class_4597;", "vertexConsumers", "", "light", "overlay", "", "render", "(Ldoublemoon/mahjongcraft/blockentity/MahjongTableBlockEntity;FLnet/minecraft/class_4587;Lnet/minecraft/class_4597;II)V", "renderPlayerLabels", "(Ldoublemoon/mahjongcraft/blockentity/MahjongTableBlockEntity;Lnet/minecraft/class_4587;Lnet/minecraft/class_4597;)V", "renderCenterLabels", "Lnet/minecraft/class_327;", "kotlin.jvm.PlatformType", "textRenderer", "Lnet/minecraft/class_327;", "Companion", "mahjongcraft-mc1.20.1"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nMahjongTableBlockEntityRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MahjongTableBlockEntityRenderer.kt\ndoublemoon/mahjongcraft/client/render/MahjongTableBlockEntityRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1#2:137\n1872#3,2:138\n1872#3,3:140\n1874#3:143\n1782#3,4:144\n1782#3,4:148\n1872#3,3:152\n*S KotlinDebug\n*F\n+ 1 MahjongTableBlockEntityRenderer.kt\ndoublemoon/mahjongcraft/client/render/MahjongTableBlockEntityRenderer\n*L\n55#1:138,2\n67#1:140,3\n55#1:143\n92#1:144,4\n93#1:148,4\n109#1:152,3\n*E\n"})
public final class MahjongTableBlockEntityRenderer
implements class_827<MahjongTableBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final class_327 textRenderer;
    private static final double WAITING_PADDING = 0.4;
    private static final double PLAYING_PADDING = 1.6;
    private static final double WIND_PADDING = 1.6;
    private static final double LABEL_INTERVAL = 0.25;
    @NotNull
    private static final class_2561 WAITING = GameStatus.WAITING.toText();
    @NotNull
    private static final class_2561 PLAYING = GameStatus.PLAYING.toText();

    public MahjongTableBlockEntityRenderer(@NotNull class_5614.class_5615 context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.textRenderer = context.method_32143();
    }

    public void render(@NotNull MahjongTableBlockEntity blockEntity, float tickDelta, @NotNull class_4587 matrices, @NotNull class_4597 vertexConsumers, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        if (!MahjongCraftClient.INSTANCE.getConfig().getDisplayTableLabels()) {
            return;
        }
        if (blockEntity.method_11010().method_11654((class_2769)MahjongTable.Companion.getPART()) != MahjongTablePart.BOTTOM_CENTER) {
            return;
        }
        this.renderCenterLabels(blockEntity, matrices, vertexConsumers);
        this.renderPlayerLabels(blockEntity, matrices, vertexConsumers);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderPlayerLabels(MahjongTableBlockEntity blockEntity, class_4587 matrices, class_4597 vertexConsumers) {
        int n;
        if (!blockEntity.getPlaying() || blockEntity.getSeat().size() != 4) {
            return;
        }
        class_2338 blockPos = blockEntity.method_11016();
        String dealer = blockEntity.getDealer();
        ArrayList<String> seat = blockEntity.getSeat();
        int it = n = seat.indexOf(dealer);
        boolean bl = false;
        if (it == -1) {
            return;
        }
        int dealerSeatIndex = n;
        Iterable $this$forEachIndexed$iv = seat;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            List list;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n2;
            boolean bl2 = false;
            class_2338 bPos = switch (index) {
                case 0 -> blockPos.method_10078().method_10078();
                case 1 -> blockPos.method_10095().method_10095();
                case 2 -> blockPos.method_10067().method_10067();
                default -> blockPos.method_10072().method_10072();
            };
            int it2 = dealerSeatIndex - index;
            boolean bl3 = false;
            int windIndex = (it2 >= 0 ? 4 - it2 : -it2) % 4;
            List $this$renderPlayerLabels_u24lambda_u244_u24lambda_u243 = list = CollectionsKt.createListBuilder();
            boolean bl4 = false;
            ((Collection)$this$renderPlayerLabels_u24lambda_u244_u24lambda_u243).add(Wind.values()[windIndex].toText());
            ((Collection)$this$renderPlayerLabels_u24lambda_u244_u24lambda_u243).add(class_2561.method_30163((String)String.valueOf(((Number)blockEntity.getPoints().get(index)).intValue())));
            CollectionsKt.reverse((List)$this$renderPlayerLabels_u24lambda_u244_u24lambda_u243);
            Iterable $this$forEachIndexed$iv2 = $this$renderPlayerLabels_u24lambda_u244_u24lambda_u243;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void text;
                void stringUUID;
                int n3;
                if ((n3 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                class_2561 class_25612 = (class_2561)item$iv2;
                int index1 = n3;
                boolean bl5 = false;
                class_327 class_3272 = this.textRenderer;
                Intrinsics.checkNotNullExpressionValue((Object)class_3272, (String)"textRenderer");
                double d = 0.5 + (double)(bPos.method_10263() - blockPos.method_10263());
                double d2 = 1.0 + (double)(bPos.method_10264() - blockPos.method_10264()) + 1.6 + 0.25 * (double)index1;
                double d3 = 0.5 + (double)(bPos.method_10260() - blockPos.method_10260());
                int n4 = Intrinsics.areEqual((Object)stringUUID, (Object)dealer) ? 15643215 : Color.WHITE.toRgb();
                class_1937 class_19372 = blockEntity.method_10997();
                Intrinsics.checkNotNull((Object)class_19372);
                class_2338 class_23382 = blockEntity.method_11016().method_10084();
                Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"up(...)");
                RenderHelper.renderLabel$default(RenderHelper.INSTANCE, class_3272, matrices, d, d2, d3, (class_2561)text, n4, 0.0f, 0, RenderHelper.INSTANCE.getLightLevel(class_19372, class_23382), vertexConsumers, false, null, 6528, null);
            }
            CollectionsKt.build((List)list);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderCenterLabels(MahjongTableBlockEntity blockEntity, class_4587 matrices, class_4597 vertexConsumers) {
        List list;
        int n;
        int n2;
        Iterable $this$count$iv = blockEntity.getPlayers();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int playerAmount = n2;
        Iterable $this$count$iv2 = blockEntity.getReady();
        boolean $i$f$count2 = false;
        if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv2) {
                boolean it = (Boolean)element$iv;
                boolean bl = false;
                if (!it || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int readyAmount = n;
        class_5250 currentReady = TextUtilsKt.plus(MahjongTableBlockEntityRenderer.Companion.getREADY(), ": " + readyAmount + "/4");
        class_5250 currentPlayers = TextUtilsKt.plus(MahjongTableBlockEntityRenderer.Companion.getPLAYER(), ": " + playerAmount + "/4");
        class_5250 currentStatus = TextUtilsKt.plus(TextUtilsKt.plus(MahjongTableBlockEntityRenderer.Companion.getSTATUS(), ": "), blockEntity.getPlaying() ? PLAYING : WAITING);
        double labelPadding = blockEntity.getPlaying() ? 1.6 : 0.4;
        List $this$renderCenterLabels_u24lambda_u248 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ((Collection)$this$renderCenterLabels_u24lambda_u248).add(currentStatus);
        if (!blockEntity.getPlaying()) {
            ((Collection)$this$renderCenterLabels_u24lambda_u248).add(currentPlayers);
            ((Collection)$this$renderCenterLabels_u24lambda_u248).add(currentReady);
        } else {
            MahjongRound round = blockEntity.getRound();
            class_2561 windText = round.getWind().toText();
            Collection collection = $this$renderCenterLabels_u24lambda_u248;
            Object[] objectArray = new Object[]{windText, round.getRound() + 1};
            collection.add(class_2561.method_43469((String)"mahjongcraft.game.round.title", (Object[])objectArray));
        }
        CollectionsKt.reverse((List)$this$renderCenterLabels_u24lambda_u248);
        Iterable $this$forEachIndexed$iv = $this$renderCenterLabels_u24lambda_u248;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void text;
            int n3;
            if ((n3 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            class_5250 class_52502 = (class_5250)item$iv;
            int index = n3;
            boolean bl3 = false;
            class_327 class_3272 = this.textRenderer;
            Intrinsics.checkNotNullExpressionValue((Object)class_3272, (String)"textRenderer");
            double d = 1.0 + labelPadding + 0.25 * (double)index;
            Intrinsics.checkNotNull((Object)text);
            class_2561 class_25612 = (class_2561)text;
            int n4 = Color.WHITE.toRgb();
            class_1937 class_19372 = blockEntity.method_10997();
            Intrinsics.checkNotNull((Object)class_19372);
            class_2338 class_23382 = blockEntity.method_11016().method_10084();
            Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"up(...)");
            RenderHelper.renderLabel$default(RenderHelper.INSTANCE, class_3272, matrices, 0.5, d, 0.5, class_25612, n4, 0.0f, 0, RenderHelper.INSTANCE.getLightLevel(class_19372, class_23382), vertexConsumers, false, null, 6528, null);
        }
        CollectionsKt.build((List)list);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u001c\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0010\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u001c\u0010\u0012\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015\u00a8\u0006\u0017"}, d2={"Ldoublemoon/mahjongcraft/client/render/MahjongTableBlockEntityRenderer$Companion;", "", "<init>", "()V", "", "WAITING_PADDING", "D", "PLAYING_PADDING", "WIND_PADDING", "LABEL_INTERVAL", "Lnet/minecraft/class_5250;", "kotlin.jvm.PlatformType", "getREADY", "()Lnet/minecraft/class_5250;", "READY", "getPLAYER", "PLAYER", "getSTATUS", "STATUS", "Lnet/minecraft/class_2561;", "WAITING", "Lnet/minecraft/class_2561;", "PLAYING", "mahjongcraft-mc1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        private final class_5250 getREADY() {
            return class_2561.method_43471((String)"mahjongcraft.gui.button.ready");
        }

        private final class_5250 getPLAYER() {
            return class_2561.method_43471((String)"mahjongcraft.game.player");
        }

        private final class_5250 getSTATUS() {
            return class_2561.method_43471((String)"mahjongcraft.game.status");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

