/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.player;

import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import java.util.Random;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public final class ImmediateSoundPlayer
implements SoundPlayer {
    private final Random random = new Random();
    private final SoundEngine engine;

    public ImmediateSoundPlayer(SoundEngine engine) {
        this.engine = engine;
    }

    @Override
    public Random getRNG() {
        return this.random;
    }

    @Override
    public void playSound(class_1309 location, String soundName, float volume, float pitch, Options options) {
        volume *= options.getOrDefault("volume_percentage", 1.0f);
        pitch *= options.getOrDefault("pitch_percentage", 1.0f);
        class_310 mc = class_310.method_1551();
        double distance = mc.field_1773.method_19418().method_19326().method_1025(location.method_19538());
        UncappedSoundInstance sound = new UncappedSoundInstance(soundName, volume *= this.engine.getVolumeForSource(location), pitch /= (PlayerUtil.getScale(location) - 1.0f) * 0.6f + 1.0f, (class_1297)location);
        if (distance > 100.0) {
            mc.method_1483().method_4872((class_1113)sound, (int)Math.floor(Math.sqrt(distance) / 2.0));
        } else {
            mc.method_1483().method_4873((class_1113)sound);
        }
    }

    public static class UncappedSoundInstance
    extends class_1109 {
        public UncappedSoundInstance(String soundName, float volume, float pitch, class_1297 entity) {
            super(UncappedSoundInstance.getSoundId(soundName, entity), entity.method_5634(), volume, pitch, class_1113.method_43221(), false, 0, class_1113.class_1114.field_5476, entity.method_23317(), entity.method_23318(), entity.method_23321(), false);
        }

        public float getMaxVolume() {
            return 3.0f;
        }

        private static class_2960 getSoundId(String name, class_1297 location) {
            if (name.indexOf(58) >= 0) {
                return new class_2960(name);
            }
            Object domain = "presencefootsteps";
            if (!PlayerUtil.isClientPlayer(location)) {
                domain = (String)domain + "mono";
            }
            return new class_2960((String)domain, name);
        }
    }
}

