/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.item.BirdEggItem;

public class BirdEggEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<ItemStack> EGG_ITEM = SynchedEntityData.m_135353_(BirdEggEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private EntityType<? extends AbstractBirdEntity> bird;
    private int spawnChance = 30;
    private int variant = -1;

    public BirdEggEntity(EntityType<? extends BirdEggEntity> type, Level level) {
        super(type, level);
        this.setEggData((EntityType<? extends AbstractBirdEntity>)((EntityType)ExoticBirdsEntities.KIWI.get()), ItemStack.f_41583_);
    }

    public BirdEggEntity(Level level, LivingEntity entity, EntityType<? extends AbstractBirdEntity> birdType, ItemStack birdEgg) {
        super((EntityType)ExoticBirdsEntities.BIRD_EGG.get(), entity, level);
        this.setEggData(birdType, birdEgg);
    }

    public BirdEggEntity(Level level, double x, double y, double z, EntityType<? extends AbstractBirdEntity> birdType, ItemStack birdEgg) {
        super((EntityType)ExoticBirdsEntities.BIRD_EGG.get(), x, y, z, level);
        this.setEggData(birdType, birdEgg);
    }

    private void setEggData(EntityType<? extends AbstractBirdEntity> birdType, ItemStack birdEgg) {
        this.bird = birdType;
        this.setSpawnChance(birdEgg);
        this.m_20088_().m_135381_(EGG_ITEM, (Object)birdEgg);
    }

    public void setSpawnChance(ItemStack itemstack) {
        CompoundTag tag = itemstack.m_41737_("EggValues");
        if (tag != null) {
            if (tag.m_128441_("SpawnChance")) {
                this.spawnChance = tag.m_128451_("SpawnChance");
            }
            if (tag.m_128441_("Variant")) {
                this.variant = tag.m_128451_("Variant");
            }
        }
    }

    public void m_7822_(byte b) {
        if (b == 3) {
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08);
            }
        }
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        hitResult.m_82443_().m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), 0.0f);
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (!this.m_9236_().f_46443_) {
            if (((Boolean)ExoticBirdsCommonConfig.allowCreateExoticEggshell.get()).booleanValue() && this.f_19796_.m_188503_(3) == 0) {
                this.m_19983_(new ItemStack((ItemLike)ExoticBirdsItems.EGGSHELL.get(), this.f_19796_.m_188503_(2) + 1));
            }
            if (this.bird != null && this.f_19796_.m_188503_(100 / this.spawnChance) == 0) {
                int i = 1;
                if (this.f_19796_.m_188503_(32) == 0) {
                    i = 4;
                }
                for (int j = 0; j < i; ++j) {
                    AbstractBirdEntity entityBird = (AbstractBirdEntity)this.bird.m_20615_(this.m_9236_());
                    if (entityBird == null) continue;
                    entityBird.m_146762_(-24000);
                    entityBird.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                    if (this.variant > -1) {
                        entityBird.setVariant(this.variant);
                        entityBird.setVariant(entityBird.getChildVariant());
                    } else {
                        entityBird.setVariant(entityBird.getRandomVariant());
                    }
                    this.m_9236_().m_7967_((Entity)entityBird);
                }
            }
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EGG_ITEM, (Object)ItemStack.f_41583_);
    }

    protected Item m_7881_() {
        ItemStack itemstack = (ItemStack)this.m_20088_().m_135370_(EGG_ITEM);
        if (itemstack.m_41720_() instanceof BirdEggItem) {
            return itemstack.m_41720_();
        }
        return Items.f_42521_;
    }
}

