/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.container;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.pavocado.exoticbirds.blockentity.BirdhouseBlockEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsMenus;
import net.pavocado.exoticbirds.item.BirdEggItem;

public class BirdhouseMenu
extends AbstractContainerMenu {
    public final Container birdhouse;

    public BirdhouseMenu(int windowId, Inventory inventory, FriendlyByteBuf extraData) {
        this(windowId, inventory, (Container)BirdhouseMenu.getBirdhouse(inventory, extraData));
    }

    public BirdhouseMenu(int windowId, Inventory inventory, Container container) {
        super((MenuType)ExoticBirdsMenus.BIRDHOUSE.get(), windowId);
        int column;
        BirdhouseMenu.m_38869_((Container)container, (int)15);
        this.birdhouse = container;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 5; ++column2) {
                this.m_38897_(new EggSlot(container, row * 5 + column2, 44 + column2 * 18, 17 + row * 18));
            }
        }
        int playerInventoryStartX = 8;
        int playerInventoryStartY = 84;
        int slotBuffer = 18;
        for (int row = 0; row < 3; ++row) {
            for (column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)inventory, 9 + row * 9 + column, playerInventoryStartX + column * slotBuffer, playerInventoryStartY + row * slotBuffer));
            }
        }
        int playerHotbarY = playerInventoryStartY + slotBuffer * 3 + 4;
        for (column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)inventory, column, playerInventoryStartX + column * slotBuffer, playerHotbarY));
        }
    }

    private static BirdhouseBlockEntity getBirdhouse(Inventory inventory, FriendlyByteBuf extraData) {
        BlockEntity entity = inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_());
        if (entity instanceof BirdhouseBlockEntity) {
            return (BirdhouseBlockEntity)entity;
        }
        throw new IllegalStateException("Tile entity is not correct! " + entity);
    }

    public boolean m_6875_(Player player) {
        return this.birdhouse.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.birdhouse.m_6643_() ? !this.m_38903_(itemstack1, this.birdhouse.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.birdhouse.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    static class EggSlot
    extends Slot {
        public EggSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return EggSlot.mayPlaceItem(stack);
        }

        public static boolean mayPlaceItem(ItemStack stack) {
            if (!stack.m_41619_()) {
                Item item = stack.m_41720_();
                return item == ExoticBirdsItems.MYSTERY_EGG.get() || item == Items.f_42521_ || item instanceof BirdEggItem;
            }
            return false;
        }
    }
}

