/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.pavocado.exoticbirds.ExoticBirdsMod;
import net.pavocado.exoticbirds.capabilities.BirdTrackingProvider;
import net.pavocado.exoticbirds.client.gui.book.BirdListButton;
import net.pavocado.exoticbirds.client.gui.book.BirdVariantButton;
import net.pavocado.exoticbirds.client.gui.book.CachedEntry;
import net.pavocado.exoticbirds.client.gui.book.ChildBirdButton;
import net.pavocado.exoticbirds.client.gui.book.RotateBirdButton;
import net.pavocado.exoticbirds.client.gui.book.SmallArrowButton;
import net.pavocado.exoticbirds.client.gui.book.ToggleSpinButton;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;
import org.apache.commons.compress.utils.Lists;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class BirdBookScreen
extends Screen {
    public static final ResourceLocation BOOK_LOCATION = new ResourceLocation("exoticbirds:textures/gui/birdbook.png");
    private EditBox searchField;
    private boolean ignoreTextInput;
    @Nullable
    public CachedEntry cachedEntry;
    public static int rotateAngle;
    public static boolean autoRotate;
    public static boolean rotateClockwise;
    private final int maxDisplayLength = 5;
    protected int leftPos;
    protected int topPos;
    protected final int imageWidth = 256;
    protected final int imageHeight = 166;
    private float currentMainScroll;
    private float currentSideScroll;
    private boolean isMainScrolling;
    private boolean isSideScrolling;
    private ItemStack hoveredItemStack = ItemStack.f_41583_;
    private int tamedItemIndex = 0;
    private int temptedItemIndex = 0;
    private SmallArrowButton tamedItemsScrollLeft;
    private SmallArrowButton tamedItemsScrollRight;
    private SmallArrowButton temptedItemsScrollLeft;
    private SmallArrowButton temptedItemsScrollRight;
    public static Set<Map.Entry<EntityType<?>, Integer>> trackedBirds;
    private final List<EntityType<?>> searchedBirdList = Lists.newArrayList();
    private final List<BirdListButton> birdListButtons = Lists.newArrayList();
    private final List<BirdVariantButton> birdVariantButtons = Lists.newArrayList();

    public BirdBookScreen(Player player) {
        super(CommonComponents.f_237098_);
        if (player != null) {
            player.getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY).ifPresent(cap -> {
                trackedBirds = cap.getAll();
            });
        }
    }

    protected void m_7856_() {
        int i;
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        rotateAngle = -90;
        this.m_142416_((GuiEventListener)new RotateBirdButton(this.leftPos + 190, this.topPos + 76, true));
        this.m_142416_((GuiEventListener)new RotateBirdButton(this.leftPos + 232, this.topPos + 76, false));
        this.m_142416_((GuiEventListener)new ToggleSpinButton(this.leftPos + 203, this.topPos + 77, autoRotate, button -> {
            autoRotate = !autoRotate;
            button.m_93666_((Component)Component.m_237115_((String)("book.exoticbirds.button." + (autoRotate ? "pause" : "spin"))));
        }));
        this.m_142416_((GuiEventListener)new ChildBirdButton(this.leftPos + 162, this.topPos + 138, button -> {
            LivingEntity entity;
            if (this.cachedEntry != null && (entity = this.cachedEntry.getCachedEntity()) instanceof AgeableMob) {
                AgeableMob ageableMob = (AgeableMob)entity;
                ageableMob.m_146762_(entity.m_6162_() ? 0 : -24000);
            }
        }));
        this.birdListButtons.clear();
        for (i = 0; i < 9; ++i) {
            this.birdListButtons.add((BirdListButton)this.m_142416_((GuiEventListener)new BirdListButton(this.leftPos + 6, this.topPos + 22 + i * 15, b -> this.updatePageInfo(((BirdListButton)b).getEntityType()))));
        }
        this.birdVariantButtons.clear();
        for (i = 0; i < 5; ++i) {
            this.birdVariantButtons.add((BirdVariantButton)this.m_142416_((GuiEventListener)new BirdVariantButton(this.leftPos + 184, this.topPos + 96 + i * 12, b -> this.updateCurrentVariant(((BirdVariantButton)b).getVariantEntry()))));
        }
        this.tamedItemsScrollLeft = (SmallArrowButton)this.m_142416_((GuiEventListener)new SmallArrowButton(this.leftPos + 94, this.topPos + 84, true, b -> {
            this.tamedItemIndex = Mth.m_14045_((int)(--this.tamedItemIndex), (int)0, (int)(this.cachedEntry != null ? this.cachedEntry.getTamingItems().size() - this.maxDisplayLength : 0));
            this.tamedItemsScrollLeft.f_93624_ = this.tamedItemIndex > 0;
            this.tamedItemsScrollRight.f_93624_ = true;
        }));
        this.tamedItemsScrollRight = (SmallArrowButton)this.m_142416_((GuiEventListener)new SmallArrowButton(this.leftPos + 174, this.topPos + 84, false, button -> {
            this.tamedItemIndex = Mth.m_14045_((int)(++this.tamedItemIndex), (int)0, (int)(this.cachedEntry != null ? this.cachedEntry.getTamingItems().size() - this.maxDisplayLength : 0));
            this.tamedItemsScrollRight.f_93624_ = this.tamedItemIndex < (this.cachedEntry != null ? this.cachedEntry.getTamingItems().size() - this.maxDisplayLength : 0);
            this.tamedItemsScrollLeft.f_93624_ = true;
        }));
        this.temptedItemsScrollLeft = (SmallArrowButton)this.m_142416_((GuiEventListener)new SmallArrowButton(this.leftPos + 94, this.topPos + 64, true, button -> {
            this.temptedItemIndex = Mth.m_14045_((int)(--this.temptedItemIndex), (int)0, (int)(this.cachedEntry != null ? this.cachedEntry.getTemptingItems().size() - this.maxDisplayLength : 0));
            this.temptedItemsScrollLeft.f_93624_ = this.temptedItemIndex > 0;
            this.temptedItemsScrollRight.f_93624_ = true;
        }));
        this.temptedItemsScrollRight = (SmallArrowButton)this.m_142416_((GuiEventListener)new SmallArrowButton(this.leftPos + 174, this.topPos + 64, false, button -> {
            this.temptedItemIndex = Mth.m_14045_((int)(++this.temptedItemIndex), (int)0, (int)(this.cachedEntry != null ? this.cachedEntry.getTemptingItems().size() - this.maxDisplayLength : 0));
            this.temptedItemsScrollRight.f_93624_ = this.temptedItemIndex < (this.cachedEntry != null ? this.cachedEntry.getTemptingItems().size() - this.maxDisplayLength : 0);
            this.temptedItemsScrollLeft.f_93624_ = true;
        }));
        this.searchField = new EditBox(this.f_96547_, this.leftPos + 9, this.topPos + 9, 69, 9, (Component)Component.m_237115_((String)"itemGroup.search"));
        this.searchField.m_94199_(20);
        this.searchField.m_94182_(false);
        this.searchField.m_94194_(true);
        this.searchField.m_94202_(0xFFFFFF);
        this.m_7787_((GuiEventListener)this.searchField);
        this.updateBirdSearch();
        this.updatePageInfo((CachedEntry)null);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float ticks) {
        this.renderBackground(graphics, mouseX, mouseY, ticks);
        this.renderPageInfo(graphics, mouseX, mouseY, ticks);
        super.m_88315_(graphics, mouseX, mouseY, ticks);
        this.renderHoveredToolTip(graphics, mouseX, mouseY);
    }

    protected void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float ticks) {
        super.m_280273_(graphics);
        graphics.m_280218_(BOOK_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        graphics.m_280218_(BOOK_LOCATION, this.leftPos + 69, (int)((float)(this.topPos + 22) + 122.0f * this.currentMainScroll), this.searchedBirdList.size() > this.birdListButtons.size() ? 0 : 9, 220, 9, 13);
        graphics.m_280218_(BOOK_LOCATION, this.leftPos + 240, (int)((float)(this.topPos + 96) + 47.0f * this.currentSideScroll), this.cachedEntry != null && this.cachedEntry.getBirdVariantList().size() > this.birdVariantButtons.size() ? 0 : 9, 233, 9, 13);
        this.searchField.m_88315_(graphics, mouseX, mouseY, ticks);
    }

    public void renderPageInfo(GuiGraphics graphics, int mouseX, int mouseY, float ticks) {
        if (this.cachedEntry != null) {
            this.displayFilledInfo(this.cachedEntry.getCachedEntity(), graphics, mouseX, mouseY, ticks);
        } else {
            this.displayAbsentInfo(graphics, mouseX, mouseY, ticks);
        }
    }

    public void m_86600_() {
        if (this.searchField != null) {
            this.searchField.m_94120_();
        }
        if (autoRotate) {
            rotateAngle = Mth.m_14098_((int)(rotateAngle + (rotateClockwise ? 2 : -2)));
        }
        this.hoveredItemStack = ItemStack.f_41583_;
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String s = this.searchField.m_94155_();
        CachedEntry entry = this.cachedEntry;
        int oldRotateAngle = rotateAngle;
        int oldTameIndex = this.tamedItemIndex;
        int oldTemptedIndex = this.temptedItemIndex;
        float oldSideScroll = this.currentSideScroll;
        super.m_6574_(minecraft, width, height);
        this.searchField.m_94144_(s);
        this.updateBirdSearch();
        this.updatePageInfo(entry);
        rotateAngle = oldRotateAngle;
        this.tamedItemIndex = oldTameIndex;
        this.temptedItemIndex = oldTemptedIndex;
        this.currentSideScroll = oldSideScroll;
        this.temptedItemsScrollLeft.f_93624_ = this.temptedItemIndex > 0;
        this.tamedItemsScrollLeft.f_93624_ = this.tamedItemIndex > 0;
        this.temptedItemsScrollRight.f_93624_ = this.cachedEntry != null && this.temptedItemIndex < this.cachedEntry.getTemptingItems().size() - this.maxDisplayLength;
        this.tamedItemsScrollRight.f_93624_ = this.cachedEntry != null && this.tamedItemIndex < this.cachedEntry.getTamingItems().size() - this.maxDisplayLength;
    }

    public boolean m_5534_(char c, int keyCode) {
        if (this.ignoreTextInput) {
            return false;
        }
        String s = this.searchField.m_94155_();
        if (this.searchField.m_5534_(c, keyCode)) {
            if (!Objects.equals(s, this.searchField.m_94155_())) {
                this.currentMainScroll = 0.0f;
                this.updateBirdSearch();
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int p_98548_, int p_98549_) {
        if (this.ignoreTextInput) {
            return false;
        }
        String s = this.searchField.m_94155_();
        if (this.searchField.m_7933_(keyCode, p_98548_, p_98549_)) {
            if (!Objects.equals(s, this.searchField.m_94155_())) {
                this.currentMainScroll = 0.0f;
                this.updateBirdSearch();
            }
            return true;
        }
        return this.searchField.m_93696_() && this.searchField.m_94213_() && keyCode != 256 || super.m_7933_(keyCode, p_98548_, p_98549_);
    }

    public boolean m_7920_(int p_98612_, int p_98613_, int p_98614_) {
        this.ignoreTextInput = false;
        return super.m_7920_(p_98612_, p_98613_, p_98614_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.inMainScrollbar(mouseX, mouseY)) {
                this.isMainScrolling = true;
                return true;
            }
            if (this.inSideScrollbar(mouseX, mouseY)) {
                this.isSideScrolling = true;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isMainScrolling = false;
            this.isSideScrolling = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        int x = (this.f_96543_ - this.imageWidth) / 2;
        if (mouseX - (double)x < 84.0 && this.searchedBirdList.size() > this.birdListButtons.size()) {
            int i = this.searchedBirdList.size() - this.birdListButtons.size();
            this.currentMainScroll = (float)((double)this.currentMainScroll - amount / (double)i);
            this.currentMainScroll = Mth.m_14036_((float)this.currentMainScroll, (float)0.0f, (float)1.0f);
            this.updateBirdListButtons();
            return true;
        }
        if (mouseX - (double)x > 84.0 && this.cachedEntry != null && this.cachedEntry.getBirdVariantList().size() > this.birdVariantButtons.size()) {
            int i = this.cachedEntry.getBirdVariantList().size() - this.birdVariantButtons.size();
            this.currentSideScroll = (float)((double)this.currentSideScroll - amount / (double)i);
            this.currentSideScroll = Mth.m_14036_((float)this.currentSideScroll, (float)0.0f, (float)1.0f);
            this.updateVariantButtons();
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        int y = (this.f_96544_ - this.imageHeight) / 2;
        if (this.isMainScrolling && this.searchedBirdList.size() > this.birdListButtons.size()) {
            int i = y + 22;
            this.currentMainScroll = ((float)mouseY - (float)i - 7.5f) / 121.0f;
            this.currentMainScroll = Mth.m_14036_((float)this.currentMainScroll, (float)0.0f, (float)1.0f);
            this.updateBirdListButtons();
            return true;
        }
        if (this.isSideScrolling && this.cachedEntry != null && this.cachedEntry.getBirdVariantList().size() > this.birdVariantButtons.size()) {
            int i = y + 96;
            this.currentSideScroll = ((float)mouseY - (float)i - 7.5f) / 46.0f;
            this.currentSideScroll = Mth.m_14036_((float)this.currentSideScroll, (float)0.0f, (float)1.0f);
            this.updateVariantButtons();
            return true;
        }
        return super.m_7979_(mouseX, mouseY, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    private boolean inMainScrollbar(double mouseX, double mouseY) {
        int x = (this.f_96543_ - this.imageWidth) / 2;
        int y = (this.f_96544_ - this.imageHeight) / 2;
        int i = x + 69;
        int j = y + 22;
        int k = i + 9;
        int l = j + 136;
        return mouseX >= (double)i && mouseY >= (double)j && mouseX < (double)k && mouseY < (double)l;
    }

    private boolean inSideScrollbar(double mouseX, double mouseY) {
        int x = (this.f_96543_ - this.imageWidth) / 2;
        int y = (this.f_96544_ - this.imageHeight) / 2;
        int i = x + 237;
        int j = y + 96;
        int k = i + 9;
        int l = j + 135;
        return mouseX >= (double)i && mouseY >= (double)j && mouseX < (double)k && mouseY < (double)l;
    }

    private void updateBirdSearch() {
        this.searchedBirdList.clear();
        String s = this.searchField.m_94155_().toLowerCase(Locale.ROOT);
        for (EntityType entityType2 : ForgeRegistries.ENTITY_TYPES) {
            try {
                String result;
                if (this.f_96541_ == null || this.f_96541_.f_91073_ == null || !(entityType2.m_20615_((Level)this.f_96541_.f_91073_) instanceof AbstractBirdEntity) || (result = ChatFormatting.m_126649_((String)entityType2.m_20676_().getString())) == null || !result.toLowerCase(Locale.ROOT).contains(s)) continue;
                this.searchedBirdList.add(entityType2);
            }
            catch (Exception e) {
                ExoticBirdsMod.LOGGER.warn("Failed to serialise forge entries. ", (Throwable)e);
            }
        }
        this.searchedBirdList.sort(Comparator.comparing(entityType -> entityType.m_20676_().getString()));
        this.updateBirdListButtons();
    }

    public void updatePageInfo(EntityType<?> entityType) {
        this.updatePageInfo(this.createCachedEntity(entityType));
    }

    public void updatePageInfo(CachedEntry entry) {
        this.cachedEntry = entry;
        this.currentSideScroll = 0.0f;
        this.tamedItemIndex = 0;
        this.temptedItemIndex = 0;
        if (!autoRotate) {
            rotateAngle = 225;
        }
        this.temptedItemsScrollLeft.f_93624_ = false;
        this.tamedItemsScrollLeft.f_93624_ = false;
        this.temptedItemsScrollRight.f_93624_ = this.cachedEntry != null && this.cachedEntry.getTemptingItems().size() > this.maxDisplayLength;
        this.tamedItemsScrollRight.f_93624_ = this.cachedEntry != null && this.cachedEntry.getTamingItems().size() > this.maxDisplayLength;
        this.updateVariantButtons();
    }

    public void updateCurrentVariant(CachedEntry.VariantEntry variant) {
        if (this.cachedEntry != null) {
            this.cachedEntry.setVariant(variant);
        }
    }

    @Nullable
    private CachedEntry createCachedEntity(EntityType<?> entityType) {
        Entity entity;
        CachedEntry entry = null;
        if (entityType != null && (entity = entityType.m_20615_((Level)this.f_96541_.f_91073_)) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            entry = new CachedEntry(livingEntity);
        }
        return entry;
    }

    private void updateBirdListButtons() {
        for (BirdListButton button : this.birdListButtons) {
            button.setEntityType(null);
            button.f_93624_ = false;
        }
        for (int i = 0; i < Mth.m_14045_((int)this.searchedBirdList.size(), (int)0, (int)this.birdListButtons.size()); ++i) {
            BirdListButton button;
            button = this.birdListButtons.get(i);
            int birdIndex = i + Mth.m_14045_((int)((int)(this.currentMainScroll * (float)(this.searchedBirdList.size() - this.birdListButtons.size()))), (int)0, (int)this.searchedBirdList.size());
            button.setEntityType(this.searchedBirdList.get(birdIndex));
            button.f_93624_ = true;
        }
    }

    private void updateVariantButtons() {
        for (BirdVariantButton button : this.birdVariantButtons) {
            button.setVariant(null);
            button.f_93624_ = false;
        }
        if (this.cachedEntry != null) {
            List<CachedEntry.VariantEntry> birdVariantList = this.cachedEntry.getBirdVariantList();
            for (int i = 0; i < Mth.m_14045_((int)birdVariantList.size(), (int)0, (int)this.birdVariantButtons.size()); ++i) {
                BirdVariantButton button = this.birdVariantButtons.get(i);
                int birdIndex = i + Mth.m_14045_((int)((int)(this.currentSideScroll * (float)(birdVariantList.size() - this.birdVariantButtons.size()))), (int)0, (int)birdVariantList.size());
                button.setVariant(birdVariantList.get(birdIndex));
                button.f_93624_ = true;
            }
        }
    }

    public static boolean isEntityUnlocked(LivingEntity entity) {
        if (entity instanceof AbstractBirdEntity) {
            AbstractBirdEntity birdEntity = (AbstractBirdEntity)entity;
            return BirdBookScreen.isEntityUnlocked(entity.m_6095_(), birdEntity.currentVariant());
        }
        return true;
    }

    public static boolean isEntityUnlocked(EntityType<?> entityType, int variant) {
        for (Map.Entry<EntityType<?>, Integer> pair : trackedBirds) {
            if (pair.getKey() != entityType || pair.getValue() != variant) continue;
            return true;
        }
        return false;
    }

    private void displayFilledInfo(LivingEntity entity, GuiGraphics graphics, int mouseX, int mouseY, float ticks) {
        entity.m_6853_(true);
        graphics.m_280056_(this.f_96547_, entity.m_5446_().getString(), this.leftPos + 96, this.topPos + 8, 0, false);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"book.exoticbirds.egg"), (this.leftPos + 96) * 2, (this.topPos + 32) * 2, 0, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"book.exoticbirds.tempting_items"), (this.leftPos + 96) * 2, (this.topPos + 57) * 2, 0, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"book.exoticbirds.taming_items"), (this.leftPos + 96) * 2, (this.topPos + 77) * 2, 0, false);
        graphics.m_280168_().m_85849_();
        float f = 2.0f;
        float f1 = Math.max(entity.m_20205_(), entity.m_20206_()) * (float)(entity.m_6162_() ? 2 : 1);
        if ((double)f1 > 1.0) {
            f /= f1;
        }
        BirdBookScreen.renderEntityInInventory(this.leftPos + 215, this.topPos + 70, (int)(f * 20.0f), this.leftPos + 180 - mouseX, this.topPos + 45 - 30 - mouseY, entity);
        if (entity instanceof AbstractBirdEntity) {
            int i;
            AbstractBirdEntity birdEntity = (AbstractBirdEntity)entity;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
            int discoveredVariants = this.cachedEntry != null ? this.cachedEntry.getDiscoveredVariants() : 0;
            graphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.exoticbirds.variant_count", (Object[])new Object[]{discoveredVariants, this.cachedEntry != null ? this.cachedEntry.getBirdVariantList().size() : 1}), (this.leftPos + 96) * 2, (this.topPos + 23) * 2, 0x404040, false);
            graphics.m_280614_(this.f_96547_, birdEntity.getTranslatedFamilyName(), (this.leftPos + 96) * 2, (this.topPos + 17) * 2, 0x404040, false);
            if (this.cachedEntry != null) {
                CachedEntry.VariantEntry currentVariant = this.cachedEntry.getVariant();
                graphics.m_280653_(this.f_96547_, currentVariant.getTranslatedName(), (this.leftPos + 216) * 2, (this.topPos + 15) * 2, 0xFFFFFF);
            }
            if (entity.m_6162_()) {
                graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"book.exoticbirds.child"), (this.leftPos + 216) * 2, (this.topPos + 21) * 2, 0xFFFFFF);
            }
            List<ItemStack> tamingItems = this.cachedEntry.getTamingItems();
            List<ItemStack> temptedItems = this.cachedEntry.getTemptingItems();
            if (tamingItems.size() == 0) {
                graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"book.exoticbirds.cannot_tame").m_130940_(ChatFormatting.ITALIC), (this.leftPos + 101) * 2, (this.topPos + 87) * 2, 0x404040, false);
            }
            if (temptedItems.size() == 0) {
                graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"book.exoticbirds.cannot_tempt").m_130940_(ChatFormatting.ITALIC), (this.leftPos + 101) * 2, (this.topPos + 67) * 2, 0x404040, false);
            }
            graphics.m_280168_().m_85849_();
            for (i = 0; i < this.maxDisplayLength; ++i) {
                if (i + this.tamedItemIndex >= tamingItems.size()) continue;
                graphics.m_280480_(tamingItems.get(i + this.tamedItemIndex), this.leftPos + 100 + i * 14, this.topPos + 81);
                if (!this.isItemSelected(this.leftPos + 100 + i * 14, this.topPos + 81, mouseX, mouseY)) continue;
                this.hoveredItemStack = tamingItems.get(i + this.tamedItemIndex);
            }
            for (i = 0; i < this.maxDisplayLength; ++i) {
                if (i + this.temptedItemIndex >= temptedItems.size()) continue;
                graphics.m_280480_(temptedItems.get(i + this.temptedItemIndex), this.leftPos + 100 + i * 14, this.topPos + 61);
                if (!this.isItemSelected(this.leftPos + 100 + i * 14, this.topPos + 61, mouseX, mouseY)) continue;
                this.hoveredItemStack = temptedItems.get(i + this.temptedItemIndex);
            }
            graphics.m_280480_(birdEntity.getEgg(), this.leftPos + 98, this.topPos + 38);
        }
    }

    private boolean isItemSelected(int topLeft, int topRight, double mouseX, double mouseY) {
        return mouseX >= (double)(topLeft - 1) && mouseX < (double)(topLeft + 17) && mouseY >= (double)(topRight - 1) && mouseY < (double)(topRight + 17);
    }

    private void renderHoveredToolTip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.hoveredItemStack != null && !this.hoveredItemStack.m_41619_()) {
            graphics.m_280153_(this.f_96547_, this.hoveredItemStack, mouseX, mouseY);
        }
    }

    private void displayAbsentInfo(GuiGraphics graphics, int mouseX, int mouseY, float ticks) {
    }

    public static void renderEntityInInventory(int p_98851_, int p_98852_, int p_98853_, float p_98854_, float p_98855_, LivingEntity entity) {
        float f1 = (float)Math.atan(p_98855_ / 40.0f);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_85837_((double)p_98851_, (double)p_98852_, 1050.0);
        posestack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_85837_(0.0, 0.0, 1000.0);
        posestack1.m_85841_((float)p_98853_, (float)p_98853_, (float)p_98853_);
        Quaternionf quaternion = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternion1 = new Quaternionf().rotateX(f1 * 20.0f * ((float)Math.PI / 180));
        quaternion.mul((Quaternionfc)quaternion1);
        posestack1.m_252781_(quaternion);
        float f2 = entity.f_20883_;
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        entity.f_20883_ = rotateAngle;
        entity.m_146922_((float)rotateAngle);
        entity.m_146926_(-f1 * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        quaternion1.conjugate();
        entityrenderdispatcher.m_252923_(quaternion1);
        entityrenderdispatcher.m_114468_(false);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        int packedLight = !BirdBookScreen.isEntityUnlocked(entity) ? -15728880 : 0xF000F0;
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack1, (MultiBufferSource)multibuffersource$buffersource, packedLight));
        multibuffersource$buffersource.m_109911_();
        entityrenderdispatcher.m_114468_(true);
        entity.f_20883_ = f2;
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }

    static {
        rotateClockwise = false;
        trackedBirds = new HashSet();
    }
}

