/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;

public class LogCagedBirdTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("exoticbirds", "log_caged_bird");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public TriggerInstance createInstance(JsonObject json, ContextAwarePredicate player, DeserializationContext context) {
        LocationPredicate locationpredicate = LocationPredicate.m_52629_((JsonElement)json.get("location"));
        ContextAwarePredicate entitypredicate$composite = EntityPredicate.m_285855_((JsonObject)json, (String)"entity", (DeserializationContext)context);
        return new TriggerInstance(player, locationpredicate, entitypredicate$composite);
    }

    public void trigger(ServerPlayer player, BlockPos blockPos, AbstractBirdEntity birdEntity) {
        LootContext lootcontext = EntityPredicate.m_36616_((ServerPlayer)player, (Entity)birdEntity);
        this.m_66234_(player, p_73934_ -> p_73934_.matches(player.m_284548_(), blockPos, lootcontext));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final LocationPredicate location;
        private final ContextAwarePredicate entity;

        public TriggerInstance(ContextAwarePredicate player, LocationPredicate location, ContextAwarePredicate entity) {
            super(ID, player);
            this.location = location;
            this.entity = entity;
        }

        public boolean matches(ServerLevel level, BlockPos blockPos, LootContext entity) {
            return this.location.m_52617_(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5) && this.entity.m_285831_(entity);
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject jsonobject = super.m_7683_(context);
            jsonobject.add("location", this.location.m_52616_());
            jsonobject.add("entity", this.entity.m_286026_(context));
            return jsonobject;
        }
    }
}

