/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.items;

import com.li64.tide.Tide;
import com.li64.tide.data.loot.TornNoteData;
import com.li64.tide.network.messages.ViewNoteMsg;
import com.li64.tide.registries.TideItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TornNoteItem
extends Item {
    public TornNoteItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack create(String id) {
        ItemStack note = new ItemStack((ItemLike)TideItems.TORN_NOTE);
        TornNoteData data = new TornNoteData(id);
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", data.id());
        tag.m_128379_("unlocked", data.unlocked());
        note.m_41784_().m_128365_("TornNoteData", (Tag)tag);
        return note;
    }

    public static void finalizeData(ItemStack note) {
        if (!note.m_41784_().m_128441_("TornNoteData")) {
            TornNoteItem.setData(note, TornNoteData.random());
        }
    }

    public static TornNoteData getData(ItemStack note) {
        CompoundTag tag = note.m_41784_().m_128469_("TornNoteData");
        if (!(note.m_41784_().m_128441_("TornNoteData") && tag.m_128441_("id") && tag.m_128441_("unlocked"))) {
            return TornNoteData.EMPTY;
        }
        return new TornNoteData(tag.m_128461_("id"), tag.m_128471_("unlocked"));
    }

    public static void setData(ItemStack note, TornNoteData data) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", data.id());
        tag.m_128379_("unlocked", data.unlocked());
        note.m_41784_().m_128365_("TornNoteData", (Tag)tag);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack note = player.m_21120_(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TornNoteItem.finalizeData(note);
            String id = TornNoteItem.getData(note).id();
            TornNoteItem.setData(note, new TornNoteData(id, true));
            int slot = player.m_150109_().m_36030_(note);
            player.m_150109_().m_6836_(slot, note);
            Tide.NETWORK.sendToPlayer(new ViewNoteMsg(id), serverPlayer);
        }
        return InteractionResultHolder.m_19092_((Object)note, (boolean)level.m_5776_());
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        TornNoteData data = TornNoteItem.getData(stack);
        if (data.unlocked() || flag.m_257552_()) {
            components.add((Component)Component.m_237115_((String)("item.tide.torn_note.variant." + data.id())).m_130940_(ChatFormatting.GRAY));
        } else {
            components.add((Component)Component.m_237115_((String)"item.tide.torn_note.variant.unknown").m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, level, components, flag);
    }
}

