/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.li64.tide.data.loot.DepthLayer;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record TideFishingPredicate(Optional<Boolean> isLavaFishing, Optional<Boolean> usingMagneticBait, Optional<String> depthLayer) implements EntitySubPredicate
{
    public static TideFishingPredicate isLavaFishing(boolean lavaFishing) {
        return new TideFishingPredicate(Optional.of(lavaFishing), Optional.empty(), Optional.empty());
    }

    public static TideFishingPredicate usingMagneticBait(boolean magneticBait) {
        return new TideFishingPredicate(Optional.empty(), Optional.of(magneticBait), Optional.empty());
    }

    public static TideFishingPredicate depthLayer(DepthLayer layer) {
        return new TideFishingPredicate(Optional.empty(), Optional.empty(), Optional.of(layer.key));
    }

    public boolean m_153246_(@NotNull Entity entity, @NotNull ServerLevel level, @Nullable Vec3 position) {
        if (entity instanceof TideFishingHook) {
            Optional<DepthLayer> layer;
            TideFishingHook hook = (TideFishingHook)entity;
            if (this.isLavaFishing.isPresent()) {
                return this.isLavaFishing.get().booleanValue() == hook.isLavaFishing();
            }
            if (this.usingMagneticBait.isPresent()) {
                return this.usingMagneticBait.get().booleanValue() == hook.usingMagneticBait();
            }
            if (this.depthLayer.isPresent() && (layer = DepthLayer.fromKey(this.depthLayer.get())).isPresent()) {
                return layer.get() == DepthLayer.getLayerAt(hook.m_20186_());
            }
        }
        return false;
    }

    public static TideFishingPredicate fromJson(JsonObject object) {
        return new TideFishingPredicate(Optional.ofNullable(object.get("is_lava_fishing")).map(element -> GsonHelper.m_13877_((JsonElement)element, (String)"is_lava_fishing")), Optional.ofNullable(object.get("using_magnetic_bait")).map(element -> GsonHelper.m_13877_((JsonElement)element, (String)"using_magnetic_bait")), Optional.ofNullable(object.get("depth_layer")).map(element -> GsonHelper.m_13805_((JsonElement)element, (String)"depth_layer")));
    }

    @NotNull
    public JsonObject m_213616_() {
        JsonObject object = new JsonObject();
        if (this.isLavaFishing().isPresent()) {
            object.add("is_lava_fishing", (JsonElement)new JsonPrimitive(this.isLavaFishing().get()));
        }
        if (this.usingMagneticBait().isPresent()) {
            object.add("using_magnetic_bait", (JsonElement)new JsonPrimitive(this.usingMagneticBait().get()));
        }
        if (this.depthLayer().isPresent()) {
            object.add("depth_layer", (JsonElement)new JsonPrimitive(this.depthLayer().get()));
        }
        return object;
    }

    @NotNull
    public JsonElement m_218837_() {
        if (this.m_213836_() == EntitySubPredicate.Types.f_218847_) {
            return JsonNull.INSTANCE;
        }
        JsonObject customData = this.m_213616_();
        customData.addProperty("type", "tide_fishing");
        return customData;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull EntitySubPredicate.Type m_213836_() {
        return TideFishingPredicate::fromJson;
    }
}

