/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.loot;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;

public enum DepthLayer {
    SURFACE("surface", y -> y >= 50.0),
    UNDERGROUND("underground", y -> y < 50.0 && y >= 0.0),
    DEPTHS("depths", y -> y < 0.0);

    public final String key;
    public final Function<Double, Boolean> predicate;

    private DepthLayer(String key, Function<Double, Boolean> predicate) {
        this.key = key;
        this.predicate = predicate;
    }

    public static DepthLayer getLayerAt(double y) {
        for (DepthLayer layer : DepthLayer.values()) {
            if (!layer.predicate.apply(y).booleanValue()) continue;
            return layer;
        }
        return SURFACE;
    }

    public static Optional<DepthLayer> fromKey(String key) {
        return Arrays.stream(DepthLayer.values()).filter(layer -> layer.key.matches(key)).findFirst();
    }
}

